/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.kubejs.recipe;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import dev.latvian.mods.kubejs.core.IngredientKJS;
import dev.latvian.mods.kubejs.core.RegistryObjectKJS;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.IngredientWrapper;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.SizedIngredientWrapper;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.component.SimpleRecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.recipe.match.ItemMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.rhino.Context;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class ItemInputComponent
extends SimpleRecipeComponent<MachineRecipe.ItemInput> {
    public static final RecipeComponentType<MachineRecipe.ItemInput> TYPE = RecipeComponentType.unit((ResourceLocation)MI.id("item_input"), ItemInputComponent::new);

    public ItemInputComponent(RecipeComponentType<?> type) {
        super(type, MachineRecipe.ItemInput.CODEC, SizedIngredientWrapper.TYPE_INFO);
    }

    public MachineRecipe.ItemInput wrap(RecipeScriptContext cx, Object from) {
        SizedIngredient sizedIngredient = SizedIngredientWrapper.wrap((Context)cx.cx(), (Object)from);
        return new MachineRecipe.ItemInput(sizedIngredient.ingredient(), sizedIngredient.count(), 1.0f);
    }

    public boolean matches(RecipeMatchContext cx, MachineRecipe.ItemInput value, ReplacementMatchInfo match) {
        ItemMatch m;
        ReplacementMatch replacementMatch = match.match();
        return replacementMatch instanceof ItemMatch && (m = (ItemMatch)replacementMatch).matches(cx, value.ingredient(), match.exact());
    }

    public MachineRecipe.ItemInput replace(RecipeScriptContext cx, MachineRecipe.ItemInput original, ReplacementMatchInfo match, Object with) {
        if (this.matches((RecipeMatchContext)cx, original, match)) {
            Ingredient withJava = IngredientWrapper.wrap((Context)cx.cx(), (Object)with);
            return new MachineRecipe.ItemInput(withJava, original.amount(), original.probability());
        }
        return original;
    }

    public boolean isEmpty(MachineRecipe.ItemInput value) {
        return value.amount() <= 0 || value.ingredient().isEmpty();
    }

    public void buildUniqueId(UniqueIdBuilder builder, MachineRecipe.ItemInput value) {
        TagKey tag = IngredientWrapper.tagKeyOf((Ingredient)value.ingredient());
        if (tag != null) {
            builder.append(tag.location());
        } else {
            ItemStack first = ((IngredientKJS)IngredientKJS.class.cast(value.ingredient())).kjs$getFirst();
            if (!first.isEmpty()) {
                builder.append(((RegistryObjectKJS)RegistryObjectKJS.class.cast(first)).kjs$getIdLocation());
            }
        }
    }
}

