/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.ae2.pipe;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.util.AEColor;
import aztech.modern_industrialization.compat.ae2.pipe.MENetwork;
import aztech.modern_industrialization.pipes.api.PipeEndpointType;
import aztech.modern_industrialization.pipes.api.PipeNetworkManager;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.impl.PipeNetworks;
import aztech.modern_industrialization.util.NbtHelper;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jspecify.annotations.Nullable;

public class MENetworkNode
extends PipeNetworkNode {
    @Nullable IManagedGridNode mainNode;
    int connectDelay = 0;
    final Set<Direction> connections = EnumSet.noneOf(Direction.class);

    void updateNode() {
        if (this.mainNode == null && this.connections.size() > 0) {
            this.mainNode = GridHelper.createManagedNode((Object)this, (nodeOwner, node) -> {}).setFlags(new GridFlags[]{GridFlags.PREFERRED}).setIdlePowerUsage(0.0);
        }
        if (this.mainNode != null && this.connections.size() == 0) {
            IManagedGridNode toDestroy = this.mainNode;
            this.mainNode = null;
            toDestroy.destroy();
        }
    }

    @Override
    public void buildInitialConnections(Level world, BlockPos pos) {
    }

    @Override
    public void updateConnections(Level world, BlockPos pos) {
        PipeNetworks levelNetworks = PipeNetworks.get((ServerLevel)world);
        this.connections.removeIf(connection -> {
            for (PipeNetworkType type : PipeNetworkType.getTypes().values()) {
                PipeNetworkManager manager = levelNetworks.getOptionalManager(type);
                if (manager == null || !manager.hasLink(pos, (Direction)connection)) continue;
                return true;
            }
            return false;
        });
        this.updateNode();
        this.connectDelay = 0;
    }

    @Override
    public @Nullable PipeEndpointType[] getConnections(BlockPos pos) {
        PipeEndpointType[] connections = new PipeEndpointType[6];
        for (Direction direction : this.network.manager.getNodeLinks(pos)) {
            connections[direction.get3DDataValue()] = PipeEndpointType.PIPE;
        }
        for (Direction connection : this.connections) {
            connections[connection.get3DDataValue()] = PipeEndpointType.BLOCK;
        }
        return connections;
    }

    @Override
    public void removeConnection(Level world, BlockPos pos, Direction direction) {
        this.connections.remove(direction);
        if (this.mainNode != null && this.mainNode.isReady()) {
            for (IGridConnection conn : this.mainNode.getNode().getConnections()) {
                if (conn.getDirection(this.mainNode.getNode()) != direction) continue;
                conn.destroy();
                break;
            }
        }
        this.updateNode();
    }

    @Override
    public void addConnection(PipeBlockEntity pipe, Player player, Level world, BlockPos pos, Direction direction) {
        if (this.canConnect(world, pos, direction)) {
            this.connections.add(direction);
            this.updateNode();
            this.connectDelay = 0;
        }
    }

    @Override
    public CompoundTag toTag(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putByte("connections", NbtHelper.encodeDirections(this.connections));
        if (this.mainNode != null) {
            this.mainNode.saveToNBT(tag);
        }
        return tag;
    }

    @Override
    public void fromTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.connections.clear();
        this.connections.addAll(Arrays.asList(NbtHelper.decodeDirections(tag.getByte("connections"))));
        this.updateNode();
        if (this.mainNode != null) {
            this.mainNode.loadFromNBT(tag);
        }
    }

    private boolean canConnect(Level world, BlockPos pos, Direction direction) {
        IGridNode node = GridHelper.getExposedNode((Level)world, (BlockPos)pos.relative(direction), (Direction)direction.getOpposite());
        return node != null && MENetworkNode.areColorsCompatible(((MENetwork)this.network).color, node.getGridColor());
    }

    static boolean areColorsCompatible(AEColor color1, AEColor color2) {
        return color1 == AEColor.TRANSPARENT || color2 == AEColor.TRANSPARENT || color1 == color2;
    }

    @Override
    public void onUnload() {
        if (this.mainNode != null) {
            this.mainNode.destroy();
            this.mainNode = null;
        }
    }
}

