/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.textures.coloramp;

import aztech.modern_industrialization.client.textures.TextureHelper;
import aztech.modern_industrialization.client.textures.TextureManager;
import aztech.modern_industrialization.client.textures.coloramp.Coloramp;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;

public class TabulatedColoramp
implements Coloramp {
    private final int[] colors;
    private final int meanRGB;

    public TabulatedColoramp(TextureManager mtm, int meanRGB, String name) {
        block10: {
            this.colors = new int[256];
            this.meanRGB = meanRGB;
            String gradientMapPath = "modern_industrialization:textures/gradient_maps/" + name + ".png";
            if (mtm.hasAsset(gradientMapPath)) {
                try (NativeImage gradientMap = mtm.getAssetAsTexture(gradientMapPath);){
                    for (int i = 0; i < 256; ++i) {
                        int color = gradientMap.getPixelRGBA(i, 0);
                        int r = TextureHelper.getR(color);
                        int g = TextureHelper.getG(color);
                        int b = TextureHelper.getB(color);
                        this.colors[i] = r << 16 | g << 8 | b;
                    }
                    break block10;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.fillUniform();
        }
    }

    public TabulatedColoramp(int meanRGB) {
        this.colors = new int[256];
        this.meanRGB = meanRGB;
        this.fillUniform();
    }

    private void fillUniform() {
        int meanR = TextureHelper.getRrgb(this.meanRGB);
        int meanG = TextureHelper.getGrgb(this.meanRGB);
        int meanB = TextureHelper.getBrgb(this.meanRGB);
        for (int i = 0; i < 256; ++i) {
            this.colors[i] = TextureHelper.toRGB(meanR * i / 255, meanG * i / 255, meanB * i / 255);
        }
    }

    @Override
    public int getRGB(double luminance) {
        int i = (int)(luminance * 255.0);
        return this.colors[i];
    }

    @Override
    public int getMeanRGB() {
        return this.meanRGB;
    }
}

