/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.machines.models;

import aztech.modern_industrialization.client.util.ModelHelper;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.pipeline.QuadBakingVertexConsumer;
import org.jspecify.annotations.Nullable;

public class MachineBakedModel
implements IDynamicBakedModel {
    public static float Z_OFFSET = 5.0E-4f;
    private static final ChunkRenderTypeSet CUTOUT_MIPPED = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.cutoutMipped()});
    public static final String CASING_FOLDER = "machine_casing";
    private final MachineCasing baseCasing;
    private final @Nullable TextureAtlasSprite[] defaultOverlays;
    private final Map<MachineCasing, @Nullable TextureAtlasSprite[]> tieredOverlays;
    private final boolean noOverlayOnOutputSide;
    private final MachineModelClientData defaultData;

    public static ModelResourceLocation getCasingModelId(MachineCasing casing) {
        return ModelResourceLocation.standalone((ResourceLocation)casing.key.withPath(p -> "machine_casing/" + p));
    }

    public static BakedModel getCasingModel(MachineCasing casing) {
        return Minecraft.getInstance().getModelManager().getModel(MachineBakedModel.getCasingModelId(casing));
    }

    MachineBakedModel(MachineCasing baseCasing, @Nullable TextureAtlasSprite[] defaultOverlays, Map<MachineCasing, @Nullable TextureAtlasSprite[]> tieredOverlays, boolean noOverlayOnOutputSide) {
        this.baseCasing = baseCasing;
        this.defaultOverlays = defaultOverlays;
        this.tieredOverlays = tieredOverlays;
        this.noOverlayOnOutputSide = noOverlayOnOutputSide;
        this.defaultData = new MachineModelClientData(baseCasing, Direction.NORTH);
    }

    public MachineCasing getBaseCasing() {
        return this.baseCasing;
    }

    public @Nullable TextureAtlasSprite[] getSprites(@Nullable MachineCasing casing) {
        if (casing == null) {
            return this.defaultOverlays;
        }
        return this.tieredOverlays.getOrDefault(casing, this.defaultOverlays);
    }

    public static @Nullable TextureAtlasSprite getSprite(@Nullable TextureAtlasSprite[] sprites, Direction side, Direction facingDirection, boolean isActive) {
        int spriteId;
        if (side.getAxis().isHorizontal()) {
            spriteId = (facingDirection.get2DDataValue() - side.get2DDataValue() + 4) % 4 * 2;
        } else {
            spriteId = (facingDirection.get2DDataValue() + 4) * 2;
            if (side == Direction.DOWN) {
                spriteId += 8;
            }
        }
        if (isActive) {
            ++spriteId;
        }
        return sprites[spriteId];
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
        MachineModelClientData machineData = (MachineModelClientData)modelData.get(MachineModelClientData.KEY);
        if (machineData == null) {
            return modelData;
        }
        MachineCasing casing = Objects.requireNonNullElse(machineData.casing, this.baseCasing);
        return MachineBakedModel.getCasingModel(casing).getModelData(level, pos, state, modelData);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        MachineModelClientData data = (MachineModelClientData)extraData.get(MachineModelClientData.KEY);
        if (data == null) {
            data = this.defaultData;
        }
        MachineCasing casing = Objects.requireNonNullElse(data.casing, this.baseCasing);
        TextureAtlasSprite[] sprites = this.getSprites(casing);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        QuadBakingVertexConsumer vc = new QuadBakingVertexConsumer();
        if (side != null) {
            Direction facingDirection;
            TextureAtlasSprite sprite;
            quads.addAll(MachineBakedModel.getCasingModel(casing).getQuads(state, side, rand, extraData, renderType));
            if (!(this.noOverlayOnOutputSide && side == data.outputDirection || (sprite = MachineBakedModel.getSprite(sprites, side, facingDirection = Objects.requireNonNullElse(data.frontDirection, Direction.NORTH), false)) == null)) {
                quads.add(ModelHelper.bakeSprite(vc, side, sprite, -Z_OFFSET));
            }
        }
        if (data.outputDirection != null && side == data.outputDirection) {
            if (sprites[24] != null) {
                quads.add(ModelHelper.bakeSprite(vc, data.outputDirection, sprites[24], -3.0f * Z_OFFSET));
            }
            if (data.itemAutoExtract) {
                quads.add(ModelHelper.bakeSprite(vc, data.outputDirection, sprites[25], -3.0f * Z_OFFSET));
            }
            if (data.fluidAutoExtract) {
                quads.add(ModelHelper.bakeSprite(vc, data.outputDirection, sprites[26], -3.0f * Z_OFFSET));
            }
        }
        return quads;
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return MachineBakedModel.getCasingModel(this.baseCasing).getParticleIcon();
    }

    public ItemTransforms getTransforms() {
        return ModelHelper.MODEL_TRANSFORM_BLOCK;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return CUTOUT_MIPPED;
    }
}

