/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.machines.guicomponents;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.client.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.client.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.client.machines.gui.MachineScreen;
import aztech.modern_industrialization.client.machines.guicomponents.GunpowderOverclockGuiClient;
import aztech.modern_industrialization.machines.guicomponents.CraftingMultiblockGui;
import aztech.modern_industrialization.util.TextHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;

public class CraftingMultiblockGuiClient
extends GuiComponentClient<Unit, CraftingMultiblockGui.Data> {
    public CraftingMultiblockGuiClient(Unit params, CraftingMultiblockGui.Data data) {
        super(params, data);
    }

    public boolean isShapeValid() {
        return ((CraftingMultiblockGui.Data)this.data).isShapeValid();
    }

    @Override
    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    public class Renderer
    extends BaseScreenRenderer
    implements ClientComponentRenderer {
        @Override
        public void renderBackground(GuiGraphics guiGraphics, int x, int y) {
            Font font = Minecraft.getInstance().font;
            int deltaY = this.renderScreenAndStatus(((CraftingMultiblockGui.Data)CraftingMultiblockGuiClient.this.data).isShapeValid(), font, guiGraphics, x, y);
            if (((CraftingMultiblockGui.Data)CraftingMultiblockGuiClient.this.data).isShapeValid() && ((CraftingMultiblockGui.Data)CraftingMultiblockGuiClient.this.data).activeRecipe().isPresent()) {
                CraftingMultiblockGui.RecipeData recipe = ((CraftingMultiblockGui.Data)CraftingMultiblockGuiClient.this.data).activeRecipe().get();
                guiGraphics.drawString(font, (Component)MIText.Progress.text(String.format("%.1f", Float.valueOf(recipe.progress() * 100.0f)) + " %"), x + 10, y + deltaY, 0xFFFFFF, false);
                deltaY += 11;
                if (recipe.efficiencyTicks() != 0 || recipe.maxEfficiencyTicks() != 0) {
                    guiGraphics.drawString(font, (Component)MIText.EfficiencyTicks.text(recipe.efficiencyTicks(), recipe.maxEfficiencyTicks()), x + 10, y + deltaY, 0xFFFFFF, false);
                    deltaY += 11;
                }
                guiGraphics.drawString(font, (Component)MIText.BaseEuRecipe.text(TextHelper.getEuTextTick(recipe.baseRecipeEu())), x + 10, y + deltaY, 0xFFFFFF, false);
                guiGraphics.drawString(font, (Component)MIText.CurrentEuRecipe.text(TextHelper.getEuTextTick(recipe.currentRecipeEu())), x + 10, y + (deltaY += 11), 0xFFFFFF, false);
                deltaY += 11;
            }
            if (((CraftingMultiblockGui.Data)CraftingMultiblockGuiClient.this.data).remainingOverclockTicks() > 0) {
                guiGraphics.drawString(font, GunpowderOverclockGuiClient.Renderer.formatOverclock(((CraftingMultiblockGui.Data)CraftingMultiblockGuiClient.this.data).remainingOverclockTicks()), x + 10, y + deltaY, 0xFFFFFF, false);
            }
        }
    }

    public static class BaseScreenRenderer {
        private static final ResourceLocation TEXTURE = MI.id("textures/gui/container/multiblock_info.png");

        public int renderScreenAndStatus(boolean shapeValid, Font font, GuiGraphics guiGraphics, int x, int y) {
            guiGraphics.blit(TEXTURE, x + 5, y + 16, 0.0f, 0.0f, 166, 80, 166, 80);
            int deltaY = 23;
            guiGraphics.drawString(font, (Component)(shapeValid ? MIText.MultiblockShapeValid.text() : MIText.MultiblockShapeInvalid.text()), x + 10, y + deltaY, shapeValid ? 0xFFFFFF : 0xFF0000, false);
            deltaY += 11;
            if (shapeValid) {
                guiGraphics.drawString(font, (Component)MIText.MultiblockStatusActive.text(), x + 10, y + deltaY, 0xFFFFFF, false);
                deltaY += 11;
            }
            return deltaY;
        }
    }
}

