/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.compat.viewer.impl.rei;

import aztech.modern_industrialization.client.screen.MIHandledScreen;
import aztech.modern_industrialization.compat.viewer.ReiDraggable;
import aztech.modern_industrialization.network.machines.DoSlotDraggingPacket;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.util.Simulation;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import java.util.ArrayList;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

class MIDraggableStackVisitor
implements DraggableStackVisitor<Screen> {
    MIDraggableStackVisitor() {
    }

    public DraggedAcceptorResult acceptDraggedStack(DraggingContext<Screen> context, DraggableStack stack) {
        return this.acceptsStack(context, stack) ? DraggedAcceptorResult.ACCEPTED : DraggedAcceptorResult.PASS;
    }

    private boolean acceptsStack(DraggingContext<Screen> context, DraggableStack stack) {
        Screen screen;
        ItemVariant itemVariant;
        FluidVariant fluidVariant;
        Object object = stack.getStack().getValue();
        if (object instanceof FluidStack) {
            FluidStack fs = (FluidStack)object;
            fluidVariant = FluidVariant.of(FluidStackHooksForge.toForge((FluidStack)fs));
        } else {
            fluidVariant = null;
        }
        FluidVariant fk = fluidVariant;
        Object object2 = stack.getStack().getValue();
        if (object2 instanceof ItemStack) {
            ItemStack is = (ItemStack)object2;
            itemVariant = ItemVariant.of(is);
        } else {
            itemVariant = null;
        }
        ItemVariant ik = itemVariant;
        @Nullable GuiEventListener element = context.getScreen().getChildAt((double)context.getCurrentPosition().x, (double)context.getCurrentPosition().y).orElse(null);
        if (element instanceof ReiDraggable) {
            ReiDraggable dw = (ReiDraggable)element;
            if (ik != null) {
                return dw.dragItem(ik, Simulation.ACT);
            }
            if (fk != null) {
                return dw.dragFluid(fk, Simulation.ACT);
            }
        }
        if ((screen = context.getScreen()) instanceof MIHandledScreen) {
            MIHandledScreen handledScreen = (MIHandledScreen)screen;
            AbstractContainerMenu handler = handledScreen.getMenu();
            Slot slot = handledScreen.getFocusedSlot();
            if (slot instanceof ReiDraggable) {
                ReiDraggable dw = (ReiDraggable)slot;
                int slotId = handler.slots.indexOf((Object)slot);
                if (ik != null && dw.dragItem(ik, Simulation.ACT)) {
                    new DoSlotDraggingPacket(handler.containerId, slotId, ik).sendToServer();
                    return true;
                }
                if (fk != null && dw.dragFluid(fk, Simulation.ACT)) {
                    new DoSlotDraggingPacket(handler.containerId, slotId, fk).sendToServer();
                    return true;
                }
            }
        }
        return false;
    }

    public Stream<DraggableStackVisitor.BoundsProvider> getDraggableAcceptingBounds(DraggingContext<Screen> context, DraggableStack stack) {
        Screen element2;
        ItemVariant itemVariant;
        FluidVariant fluidVariant;
        ArrayList<DraggableStackVisitor.BoundsProvider> bounds = new ArrayList<DraggableStackVisitor.BoundsProvider>();
        Object object = stack.getStack().getValue();
        if (object instanceof FluidStack) {
            FluidStack fs = (FluidStack)object;
            fluidVariant = FluidVariant.of(FluidStackHooksForge.toForge((FluidStack)fs));
        } else {
            fluidVariant = null;
        }
        FluidVariant fk = fluidVariant;
        Object object2 = stack.getStack().getValue();
        if (object2 instanceof ItemStack) {
            ItemStack is = (ItemStack)object2;
            itemVariant = ItemVariant.of(is);
        } else {
            itemVariant = null;
        }
        ItemVariant ik = itemVariant;
        for (Screen element2 : context.getScreen().children()) {
            if (!(element2 instanceof AbstractWidget)) continue;
            AbstractWidget cw = (AbstractWidget)element2;
            if (!(element2 instanceof ReiDraggable)) continue;
            ReiDraggable dw = (ReiDraggable)element2;
            if (ik != null && dw.dragItem(ik, Simulation.SIMULATE)) {
                bounds.add(MIDraggableStackVisitor.getWidgetBounds(cw));
            }
            if (fk == null || !dw.dragFluid(fk, Simulation.SIMULATE)) continue;
            bounds.add(MIDraggableStackVisitor.getWidgetBounds(cw));
        }
        element2 = context.getScreen();
        if (element2 instanceof MIHandledScreen) {
            MIHandledScreen handledScreen = (MIHandledScreen)element2;
            AbstractContainerMenu handler = handledScreen.getMenu();
            for (Slot slot : handler.slots) {
                if (!(slot instanceof ReiDraggable)) continue;
                ReiDraggable dw = (ReiDraggable)slot;
                if (ik != null && dw.dragItem(ik, Simulation.SIMULATE)) {
                    bounds.add(MIDraggableStackVisitor.getSlotBounds(slot, handledScreen));
                }
                if (fk == null || !dw.dragFluid(fk, Simulation.SIMULATE)) continue;
                bounds.add(MIDraggableStackVisitor.getSlotBounds(slot, handledScreen));
            }
        }
        return bounds.stream();
    }

    public <R extends Screen> boolean isHandingScreen(R screen) {
        return screen instanceof MIHandledScreen;
    }

    private static DraggableStackVisitor.BoundsProvider getWidgetBounds(AbstractWidget cw) {
        return DraggableStackVisitor.BoundsProvider.ofRectangle((Rectangle)new Rectangle(cw.getX(), cw.getY(), cw.getWidth(), cw.getHeight()));
    }

    private static DraggableStackVisitor.BoundsProvider getSlotBounds(Slot slot, MIHandledScreen<?> screen) {
        return DraggableStackVisitor.BoundsProvider.ofRectangle((Rectangle)new Rectangle(slot.x + screen.getX(), slot.y + screen.getY(), 16, 16));
    }
}

