/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.compat.viewer.impl.emi;

import aztech.modern_industrialization.client.compat.viewer.impl.emi.ViewerCategoryEmi;
import aztech.modern_industrialization.client.machines.gui.MachineMenuClient;
import aztech.modern_industrialization.client.machines.guicomponents.ReiSlotLockingClient;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.gui.MachineMenuCommon;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.network.machines.ReiLockSlotsPacket;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.mutable.MutableBoolean;

class MachineRecipeHandler
implements StandardRecipeHandler<MachineMenuCommon> {
    MachineRecipeHandler() {
    }

    public List<Slot> getInputSources(MachineMenuCommon menu) {
        return menu.slots.stream().filter(s -> {
            ConfigurableItemStack.ConfigurableItemSlot cis;
            return s.index < 36 || s instanceof ConfigurableItemStack.ConfigurableItemSlot && (cis = (ConfigurableItemStack.ConfigurableItemSlot)s).getConfStack().canPlayerInsert();
        }).toList();
    }

    public List<Slot> getCraftingSlots(MachineMenuCommon menu) {
        return menu.slots.stream().filter(s -> {
            ConfigurableItemStack.ConfigurableItemSlot cis;
            return s instanceof ConfigurableItemStack.ConfigurableItemSlot && (cis = (ConfigurableItemStack.ConfigurableItemSlot)s).getConfStack().canPlayerInsert();
        }).toList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean supportsRecipe(EmiRecipe recipe) {
        if (!(recipe instanceof ViewerCategoryEmi.ViewerRecipe)) return false;
        ViewerCategoryEmi.ViewerRecipe r = (ViewerCategoryEmi.ViewerRecipe)recipe;
        Object d = r.recipe;
        if (!(d instanceof RecipeHolder)) return false;
        RecipeHolder holder = (RecipeHolder)d;
        if (!(holder.value() instanceof MachineRecipe)) return false;
        return true;
    }

    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<MachineMenuCommon> context) {
        MachineMenuCommon handler = (MachineMenuCommon)context.getScreenHandler();
        if (!this.canApply(handler, (ViewerCategoryEmi<?>)((ViewerCategoryEmi.ViewerRecipe)recipe).getCategory())) {
            return false;
        }
        if (Minecraft.getInstance().screen == context.getScreen()) {
            return context.getInventory().canCraft(recipe);
        }
        return this.lockSlots(recipe, (AbstractContainerScreen<MachineMenuCommon>)context.getScreen(), false);
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<MachineMenuCommon> context) {
        MachineMenuCommon handler = (MachineMenuCommon)context.getScreenHandler();
        if (!this.canApply(handler, (ViewerCategoryEmi<?>)((ViewerCategoryEmi.ViewerRecipe)recipe).getCategory())) {
            return false;
        }
        if (Minecraft.getInstance().screen == context.getScreen()) {
            return super.craft(recipe, context);
        }
        return this.lockSlots(recipe, (AbstractContainerScreen<MachineMenuCommon>)context.getScreen(), true);
    }

    private boolean lockSlots(EmiRecipe recipe, AbstractContainerScreen<MachineMenuCommon> screen, boolean doTransfer) {
        MachineMenuCommon handler = (MachineMenuCommon)screen.getMenu();
        ReiSlotLockingClient slotLocking = ((MachineMenuClient)handler).getComponent(ReiSlotLockingClient.class);
        if (slotLocking == null || !slotLocking.isLockingAllowed()) {
            return false;
        }
        if (doTransfer) {
            new ReiLockSlotsPacket(handler.containerId, recipe.getId()).sendToServer();
            Minecraft.getInstance().setScreen(screen);
        }
        return true;
    }

    private boolean canApply(MachineMenuCommon handler, ViewerCategoryEmi<?> category) {
        ResourceLocation blockId = handler.guiParams.blockId;
        MutableBoolean hasWorkstation = new MutableBoolean(false);
        category.wrapped.buildWorkstations(items -> {
            for (ItemLike item : items) {
                if (!BuiltInRegistries.ITEM.getKey((Object)item.asItem()).equals((Object)blockId)) continue;
                hasWorkstation.setTrue();
            }
        });
        return hasWorkstation.booleanValue();
    }
}

