/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.blocks.FastBlockEntity;
import aztech.modern_industrialization.blocks.WrenchableBlockEntity;
import aztech.modern_industrialization.blocks.storage.AbstractStorageBlock;
import aztech.modern_industrialization.blocks.storage.ResourceStorage;
import aztech.modern_industrialization.blocks.storage.StorageBehaviour;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.StoragePreconditions;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.base.ResourceAmount;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.base.SingleSlotStorage;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.SnapshotJournal;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.TransactionContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jspecify.annotations.Nullable;

public abstract class AbstractStorageBlockEntity<T extends TransferVariant<?>>
extends FastBlockEntity
implements SingleSlotStorage<T>,
WrenchableBlockEntity {
    protected T resource;
    protected long amount;
    private long version;
    private boolean isLocked;
    public final StorageBehaviour<T> behaviour;
    private final ResourceParticipant participant = new ResourceParticipant();

    @Override
    public long getVersion() {
        return this.version;
    }

    public AbstractStorageBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resource = this.getBlankResource();
        this.behaviour = ((AbstractStorageBlock)state.getBlock()).behavior;
    }

    @Override
    protected boolean shouldSkipComparatorUpdate() {
        return this.behaviour.isCreative();
    }

    public void onChanged() {
        ++this.version;
        this.setChanged();
        if (!this.level.isClientSide) {
            this.sync();
        }
    }

    public @Nullable Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Override
    public boolean useWrench(Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.isShiftKeyDown()) {
            AbstractStorageBlock block = (AbstractStorageBlock)this.getBlockState().getBlock();
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, hit.getLocation().x, hit.getLocation().y, hit.getLocation().z, block.getStack(this)));
            this.level.setBlockAndUpdate(this.worldPosition, Blocks.AIR.defaultBlockState());
        } else if (this.behaviour.isLockable()) {
            this.toggleLocked();
            player.displayClientMessage((Component)(this.isLocked() ? MIText.Locked.text() : MIText.Unlocked.text()), true);
        }
        return true;
    }

    @Override
    public boolean supportsExtraction() {
        return true;
    }

    @Override
    public boolean supportsInsertion() {
        return !this.behaviour.isCreative();
    }

    public long insert(T resource, long maxAmount, TransactionContext transaction, boolean ignoreLock) {
        StoragePreconditions.notBlankNotNegative(resource, maxAmount);
        if (this.behaviour.isCreative()) {
            return 0L;
        }
        if (this.resource.isBlank() && (ignoreLock || !this.isLocked()) || this.resource.equals(resource)) {
            long inserted = Math.min(maxAmount, this.behaviour.getCapacityForResource(resource) - this.amount);
            if (inserted > 0L) {
                this.participant.updateSnapshots(transaction);
                this.amount += inserted;
                this.resource = resource;
            }
            return inserted;
        }
        return 0L;
    }

    @Override
    public long insert(T resource, long maxAmount, TransactionContext transaction) {
        return this.insert(resource, maxAmount, transaction, false);
    }

    @Override
    public long extract(T resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative(resource, maxAmount);
        if (this.behaviour.isCreative()) {
            return maxAmount;
        }
        if (resource.equals(this.resource)) {
            long extracted = Math.min(maxAmount, this.amount);
            if (extracted > 0L) {
                this.participant.updateSnapshots(transaction);
                this.amount -= extracted;
                if (this.amount == 0L && !this.isLocked()) {
                    this.resource = this.getBlankResource();
                }
            }
            return extracted;
        }
        return 0L;
    }

    @Override
    public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    @Override
    public T getResource() {
        return this.resource;
    }

    @Override
    public long getAmount() {
        if (this.isResourceBlank()) {
            return 0L;
        }
        if (!this.behaviour.isCreative()) {
            return this.amount;
        }
        return Long.MAX_VALUE;
    }

    public boolean isEmpty() {
        if (!this.behaviour.isCreative()) {
            return this.amount == 0L;
        }
        return this.resource.isBlank();
    }

    @Override
    public long getCapacity() {
        return this.behaviour.getCapacityForResource(this.resource);
    }

    public boolean isLocked() {
        if (!this.behaviour.isLockable()) {
            return false;
        }
        return this.isLocked;
    }

    public void toggleLocked() {
        if (this.behaviour.isLockable()) {
            boolean bl = this.isLocked = !this.isLocked;
            if (!this.isLocked && this.amount == 0L) {
                this.resource = this.getBlankResource();
            }
            this.setChanged();
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        ResourceStorage storage = (ResourceStorage)input.get(this.componentType());
        if (storage != null) {
            this.resource = storage.resource();
            if (this.behaviour.isLockable()) {
                this.isLocked = storage.locked();
            }
            if (!this.behaviour.isCreative()) {
                this.amount = storage.amount();
            }
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(this.componentType(), new ResourceStorage<T>(this.resource, this.amount, this.isLocked));
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("locked");
        tag.remove("amt");
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.resource = this.loadResource(tag, registries);
        if (this.behaviour.isLockable()) {
            this.isLocked = tag.getBoolean("locked");
        }
        if (!this.behaviour.isCreative()) {
            this.amount = tag.getLong("amt");
            if (this.resource.isBlank()) {
                this.amount = 0L;
            }
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (this.behaviour.isLockable()) {
            tag.putBoolean("locked", this.isLocked);
        }
        if (!this.behaviour.isCreative()) {
            tag.putLong("amt", this.amount);
        }
        this.saveResource(this.resource, tag, registries);
    }

    public void setResource(T resource) {
        this.resource = resource;
    }

    public abstract DataComponentType<ResourceStorage<T>> componentType();

    public abstract T loadResource(CompoundTag var1, HolderLookup.Provider var2);

    public abstract void saveResource(T var1, CompoundTag var2, HolderLookup.Provider var3);

    public abstract T getBlankResource();

    private class ResourceParticipant
    extends SnapshotJournal<ResourceAmount<T>> {
        private ResourceParticipant() {
        }

        @Override
        protected ResourceAmount<T> createSnapshot() {
            return new ResourceAmount(AbstractStorageBlockEntity.this.resource, AbstractStorageBlockEntity.this.amount);
        }

        @Override
        protected void revertToSnapshot(ResourceAmount<T> snapshot) {
            AbstractStorageBlockEntity.this.resource = (TransferVariant)snapshot.resource();
            AbstractStorageBlockEntity.this.amount = snapshot.amount();
        }

        @Override
        protected void onRootCommit(ResourceAmount<T> originalState) {
            AbstractStorageBlockEntity.this.onChanged();
        }
    }
}

