/*
 * Decompiled with CFR 0.152.
 */
package com.ankin.nostructureoverlap.mixin;

import com.ankin.nostructureoverlap.Config;
import com.ankin.nostructureoverlap.StructurePlacementValidator;
import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Structure.class})
public class StructureMixin {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Inject(method={"generate"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGenerate(RegistryAccess registryAccess, ChunkGenerator chunkGenerator, BiomeSource biomeSource, RandomState randomState, StructureTemplateManager structureTemplateManager, long seed, ChunkPos chunkPos, int references, LevelHeightAccessor levelHeightAccessor, Predicate<Structure> structurePredicate, CallbackInfoReturnable<StructureStart> cir) {
        if (!Config.enableOverlapPrevention) {
            return;
        }
        BlockPos center = chunkPos.getMiddleBlockPosition(0);
        ResourceLocation structureId = this.getStructureId((Structure)this);
        if (!Config.isStructureEnabled(structureId.toString())) {
            return;
        }
        if (!StructurePlacementValidator.canPlaceStructureAt(center, structureId, null)) {
            if (Config.logBlockedStructures) {
                LOGGER.debug("Blocked structure {} at chunk ({}, {}) due to overlap prevention", new Object[]{structureId, chunkPos.x, chunkPos.z});
            }
            cir.setReturnValue((Object)StructureStart.INVALID_START);
            return;
        }
        StructurePlacementValidator.registerStructurePlacement(center, structureId, null);
    }

    private ResourceLocation getStructureId(Structure structure) {
        try {
            Object structureType = structure.getClass().getMethod("getType", new Class[0]).invoke((Object)structure, new Object[0]);
            Object registryName = structureType.getClass().getMethod("getRegistryName", new Class[0]).invoke(structureType, new Object[0]);
            if (registryName != null) {
                return (ResourceLocation)registryName;
            }
        }
        catch (Exception structureType) {
            // empty catch block
        }
        String structureName = structure.getClass().getSimpleName().toLowerCase();
        return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)structureName);
    }
}

