/*
 * Decompiled with CFR 0.152.
 */
package com.ankin.nostructureoverlap;

import com.ankin.nostructureoverlap.Config;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.slf4j.Logger;

public class StructurePlacementValidator {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, Set<StructurePlacement>> placedStructures = new ConcurrentHashMap<String, Set<StructurePlacement>>();

    public static boolean canPlaceStructureAt(BlockPos center, ResourceLocation structureId, StructureSet structureSet) {
        if (!Config.enableOverlapPrevention) {
            return true;
        }
        String structureIdString = structureId.toString();
        if (!Config.isStructureEnabled(structureIdString)) {
            return true;
        }
        StructurePlacement newPlacement = new StructurePlacement(center, structureId, structureSet);
        int searchRadius = newPlacement.exclusionRadius / 16 + 2;
        ChunkPos centerChunk = new ChunkPos(center);
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int z = -searchRadius; z <= searchRadius; ++z) {
                ChunkPos nearbyChunk = new ChunkPos(centerChunk.x + x, centerChunk.z + z);
                String chunkKey = StructurePlacementValidator.getChunkKey(nearbyChunk);
                Set<StructurePlacement> nearbyStructures = placedStructures.get(chunkKey);
                if (nearbyStructures == null) continue;
                for (StructurePlacement existing : nearbyStructures) {
                    String existingStructureIdString = existing.structureId.toString();
                    if (!Config.isStructureEnabled(existingStructureIdString) || !newPlacement.overlaps(existing)) continue;
                    if (Config.logBlockedStructures) {
                        LOGGER.info("Blocked structure {} at {} due to overlap with {} at {} (distance: {:.1f})", new Object[]{structureId, center, existing.structureId, existing.center, Math.sqrt(center.distSqr((Vec3i)existing.center))});
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public static void registerStructurePlacement(BlockPos center, ResourceLocation structureId, StructureSet structureSet) {
        if (!Config.enableOverlapPrevention) {
            return;
        }
        String structureIdString = structureId.toString();
        if (!Config.isStructureEnabled(structureIdString)) {
            return;
        }
        StructurePlacement placement = new StructurePlacement(center, structureId, structureSet);
        ChunkPos chunkPos = new ChunkPos(center);
        String chunkKey = StructurePlacementValidator.getChunkKey(chunkPos);
        placedStructures.computeIfAbsent(chunkKey, k -> ConcurrentHashMap.newKeySet()).add(placement);
        if (Config.logBlockedStructures) {
            LOGGER.debug("Registered structure {} at {} with exclusion radius {}", new Object[]{structureId, center, placement.exclusionRadius});
        }
    }

    private static String getChunkKey(ChunkPos chunkPos) {
        return chunkPos.x + "," + chunkPos.z;
    }

    public static void clearStructures() {
        placedStructures.clear();
        LOGGER.info("Cleared all structure placements");
    }

    public static int getStructureCount() {
        return placedStructures.values().stream().mapToInt(Set::size).sum();
    }

    public static int getStructureCount(ResourceLocation structureId) {
        return (int)placedStructures.values().stream().flatMap(Collection::stream).filter(placement -> placement.structureId.equals((Object)structureId)).count();
    }

    public static void cleanupOldStructures() {
        long currentTime = System.currentTimeMillis();
        long maxAge = 86400000L;
        int totalBefore = StructurePlacementValidator.getStructureCount();
        placedStructures.values().forEach(placements -> placements.removeIf(placement -> currentTime - placement.timestamp > maxAge));
        int totalAfter = StructurePlacementValidator.getStructureCount();
        if (totalBefore > totalAfter) {
            LOGGER.debug("Cleaned up {} old structure placements", (Object)(totalBefore - totalAfter));
        }
    }

    public static class StructurePlacement {
        public final BlockPos center;
        public final ResourceLocation structureId;
        public final StructureSet structureSet;
        public final long timestamp;
        public final int exclusionRadius;

        public StructurePlacement(BlockPos center, ResourceLocation structureId, StructureSet structureSet) {
            this.center = center;
            this.structureId = structureId;
            this.structureSet = structureSet;
            this.timestamp = System.currentTimeMillis();
            this.exclusionRadius = this.calculateExclusionRadius(structureId);
        }

        public boolean overlaps(StructurePlacement other) {
            if (Config.use3DOverlapDetection) {
                return this.overlaps3D(other);
            }
            return this.overlaps2D(other);
        }

        public boolean overlaps3D(StructurePlacement other) {
            double minDistance;
            double distance = Math.sqrt(this.center.distSqr((Vec3i)other.center));
            return distance < (minDistance = (double)(this.exclusionRadius + other.exclusionRadius));
        }

        public boolean overlaps2D(StructurePlacement other) {
            double minDistance2D;
            double dz;
            double dx = this.center.getX() - other.center.getX();
            double distance2D = Math.sqrt(dx * dx + (dz = (double)(this.center.getZ() - other.center.getZ())) * dz);
            return distance2D < (minDistance2D = (double)(this.exclusionRadius + other.exclusionRadius));
        }

        public boolean isInExclusionZone(BlockPos otherCenter, int otherExclusionRadius) {
            if (Config.use3DOverlapDetection) {
                return this.isInExclusionZone3D(otherCenter, otherExclusionRadius);
            }
            return this.isInExclusionZone2D(otherCenter, otherExclusionRadius);
        }

        public boolean isInExclusionZone3D(BlockPos otherCenter, int otherExclusionRadius) {
            double distance = Math.sqrt(this.center.distSqr((Vec3i)otherCenter));
            return distance < (double)Math.max(this.exclusionRadius, otherExclusionRadius);
        }

        public boolean isInExclusionZone2D(BlockPos otherCenter, int otherExclusionRadius) {
            double dz;
            double dx = this.center.getX() - otherCenter.getX();
            double distance2D = Math.sqrt(dx * dx + (dz = (double)(this.center.getZ() - otherCenter.getZ())) * dz);
            return distance2D < (double)Math.max(this.exclusionRadius, otherExclusionRadius);
        }

        private int calculateExclusionRadius(ResourceLocation structureId) {
            String structureIdString = structureId.toString();
            int baseDistance = Config.getStructureDistance(structureIdString);
            int structureSize = this.getEstimatedStructureSize(structureId);
            return Math.max(baseDistance, structureSize);
        }

        private int getEstimatedStructureSize(ResourceLocation structureId) {
            String path = structureId.getPath();
            if (path.contains("village")) {
                return 64;
            }
            if (path.contains("mansion")) {
                return 80;
            }
            if (path.contains("monument")) {
                return 60;
            }
            if (path.contains("fortress")) {
                return 50;
            }
            if (path.contains("bastion")) {
                return 70;
            }
            if (path.contains("outpost")) {
                return 30;
            }
            if (path.contains("ruined_portal")) {
                return 20;
            }
            if (path.contains("desert_pyramid")) {
                return 25;
            }
            if (path.contains("jungle_pyramid")) {
                return 25;
            }
            if (path.contains("witch_hut")) {
                return 15;
            }
            if (path.contains("igloo")) {
                return 10;
            }
            if (path.contains("shipwreck")) {
                return 15;
            }
            if (path.contains("buried_treasure")) {
                return 5;
            }
            if (path.contains("mineshaft")) {
                return 40;
            }
            if (path.contains("stronghold")) {
                return 30;
            }
            if (path.contains("end_city")) {
                return 50;
            }
            if (path.contains("end_gateway")) {
                return 10;
            }
            if (path.contains("ancient_city")) {
                return 100;
            }
            if (path.contains("trail_ruins")) {
                return 20;
            }
            if (path.contains("trial_chambers")) {
                return 30;
            }
            return Config.minOverlapDistance;
        }
    }

    public static class StructureSetInfo {
        public final StructureSet structureSet;
        public final int exclusionZoneRadius;
        public final Set<ResourceLocation> conflictingStructures;

        public StructureSetInfo(StructureSet structureSet, int exclusionZoneRadius) {
            this.structureSet = structureSet;
            this.exclusionZoneRadius = exclusionZoneRadius;
            this.conflictingStructures = new HashSet<ResourceLocation>();
        }
    }
}

