/*
 * Decompiled with CFR 0.152.
 */
package com.ankin.nostructureoverlap;

import com.ankin.nostructureoverlap.Config;
import com.ankin.nostructureoverlap.StructurePlacementValidator;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="nostructureoverlap")
public class Nostructureoverlap {
    public static final String MODID = "nostructureoverlap";
    private static final Logger LOGGER = LogUtils.getLogger();

    public Nostructureoverlap(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("NoStructureOverlap mod loaded - structure overlap prevention system ready");
        LOGGER.info("Structure overlap prevention is active with early interception at ChunkGenerator level");
        LOGGER.info("This approach prevents overlaps before any generation work is done, improving performance");
        LOGGER.info("Use /nostructureoverlap status to check mod status and tracked structures");
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("NoStructureOverlap: Server starting - structure overlap prevention active");
        LOGGER.info("NoStructureOverlap: 3D overlap detection is " + (Config.use3DOverlapDetection ? "enabled" : "disabled"));
    }

    @SubscribeEvent
    public void onLevelLoad(LevelEvent.Load event) {
        if (event.getLevel().isClientSide()) {
            LOGGER.info("NoStructureOverlap: Client level loaded - structure overlap prevention ready");
        } else {
            LOGGER.info("NoStructureOverlap: Server level loaded - structure overlap prevention active");
        }
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)MODID).then(Commands.literal((String)"status").executes(context -> {
            int structureCount = StructurePlacementValidator.getStructureCount();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("NoStructureOverlap Status: " + (Config.enableOverlapPrevention ? "Enabled" : "Disabled") + " | Tracked Structures: " + structureCount)), false);
            return structureCount;
        }))).then(Commands.literal((String)"clear").executes(context -> {
            StructurePlacementValidator.clearStructures();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Cleared all tracked structures"), true);
            return 1;
        }))).then(Commands.literal((String)"cleanup").executes(context -> {
            StructurePlacementValidator.cleanupOldStructures();
            int structureCount = StructurePlacementValidator.getStructureCount();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Cleaned up old structures. Remaining: " + structureCount)), true);
            return 1;
        }))).then(Commands.literal((String)"toggle").executes(context -> {
            Config.enableOverlapPrevention = !Config.enableOverlapPrevention;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Overlap prevention " + (Config.enableOverlapPrevention ? "enabled" : "disabled"))), true);
            return 1;
        }))).then(Commands.literal((String)"toggle3D").executes(context -> {
            Config.use3DOverlapDetection = !Config.use3DOverlapDetection;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("3D overlap detection " + (Config.use3DOverlapDetection ? "enabled" : "disabled (using 2D only)"))), true);
            return 1;
        }))).then(Commands.literal((String)"info").executes(context -> {
            StringBuilder info = new StringBuilder();
            info.append("NoStructureOverlap Info:\n");
            info.append("\u2022 Overlap Prevention: ").append(Config.enableOverlapPrevention ? "Enabled" : "Disabled").append("\n");
            info.append("\u2022 3D Overlap Detection: ").append(Config.use3DOverlapDetection ? "Enabled" : "Disabled (2D only)").append("\n");
            info.append("\u2022 Min Overlap Distance: ").append(Config.minOverlapDistance).append(" blocks\n");
            info.append("\u2022 Log Blocked Structures: ").append(Config.logBlockedStructures ? "Enabled" : "Disabled").append("\n");
            info.append("\u2022 Tracked Structures: ").append(StructurePlacementValidator.getStructureCount()).append("\n");
            if (!Config.structureWhitelist.isEmpty()) {
                info.append("\u2022 Whitelisted Structures: ").append(Config.structureWhitelist.size()).append("\n");
            }
            if (!Config.structureBlacklist.isEmpty()) {
                info.append("\u2022 Blacklisted Structures: ").append(Config.structureBlacklist.size()).append("\n");
            }
            if (!Config.structureSpecificDistances.isEmpty()) {
                info.append("\u2022 Custom Distance Structures: ").append(Config.structureSpecificDistances.size()).append("\n");
            }
            if (!Config.structureSpecificEnabled.isEmpty()) {
                info.append("\u2022 Custom Enabled/Disabled Structures: ").append(Config.structureSpecificEnabled.size()).append("\n");
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)info.toString()), false);
            return 1;
        }))).then(Commands.literal((String)"structures").executes(context -> {
            StringBuilder structures = new StringBuilder();
            structures.append("Structure Configuration:\n");
            if (!Config.structureWhitelist.isEmpty()) {
                structures.append("Whitelisted: ").append(String.join((CharSequence)", ", Config.structureWhitelist)).append("\n");
            }
            if (!Config.structureBlacklist.isEmpty()) {
                structures.append("Blacklisted: ").append(String.join((CharSequence)", ", Config.structureBlacklist)).append("\n");
            }
            if (!Config.structureSpecificDistances.isEmpty()) {
                structures.append("Custom Distances:\n");
                Config.structureSpecificDistances.forEach((id, distance) -> structures.append("  ").append((String)id).append(": ").append(distance).append(" blocks\n"));
            }
            if (!Config.structureSpecificEnabled.isEmpty()) {
                structures.append("Custom Enabled/Disabled:\n");
                Config.structureSpecificEnabled.forEach((id, enabled) -> structures.append("  ").append((String)id).append(": ").append(enabled != false ? "Enabled" : "Disabled").append("\n"));
            }
            if (structures.toString().equals("Structure Configuration:\n")) {
                structures.append("No structure-specific configurations set (using defaults)");
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)structures.toString()), false);
            return 1;
        })));
    }
}

