/*
 * Decompiled with CFR 0.152.
 */
package com.ankin.nostructureoverlap;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="nostructureoverlap")
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.BooleanValue ENABLE_OVERLAP_PREVENTION = BUILDER.comment("Enable structure overlap prevention").define("enableOverlapPrevention", true);
    private static final ModConfigSpec.BooleanValue LOG_BLOCKED_STRUCTURES = BUILDER.comment("Log when structures are blocked due to overlap").define("logBlockedStructures", true);
    private static final ModConfigSpec.BooleanValue USE_3D_OVERLAP_DETECTION = BUILDER.comment("Use 3D overlap detection instead of 2D (X-Z only). 3D prevents underground structures from blocking surface structures and vice versa.").define("use3DOverlapDetection", true);
    private static final ModConfigSpec.IntValue MIN_OVERLAP_DISTANCE = BUILDER.comment("Minimum distance between structure centers to prevent overlap (in blocks)").defineInRange("minOverlapDistance", 16, 1, 1000);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> STRUCTURE_WHITELIST = BUILDER.comment(new String[]{"List of structure IDs that should have overlap prevention enabled. If empty, all structures are included.", "Note: Use the actual Minecraft registry names (e.g., minecraft:village_plains, minecraft:stronghold)"}).define("structureWhitelist", Arrays.asList(new String[0]), Config::isValidStructureIdList);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> STRUCTURE_BLACKLIST = BUILDER.comment(new String[]{"List of structure IDs that should have overlap prevention disabled", "Note: Use the actual Minecraft registry names, not display names.", "Common structure names: minecraft:jigsawstructure, minecraft:netherfossilstructure,", "minecraft:fossilstructure, minecraft:jungletemplestructure, minecraft:swamphutstructure,", "minecraft:igloostructure, minecraft:alternatejigsawstructure, etc."}).define("structureBlacklist", Arrays.asList("minecraft:jigsawstructure", "minecraft:netherfossilstructure", "minecraft:fossilstructure", "minecraft:jungletemplestructure", "minecraft:swamphutstructure", "minecraft:igloostructure", "minecraft:alternatejigsawstructure"), Config::isValidStructureIdList);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> STRUCTURE_SPECIFIC_DISTANCES_RAW = BUILDER.comment(new String[]{"Per-structure minimum overlap distances. Format: [\"structure_id=distance\", \"another_id=32\"]", "Note: Use actual Minecraft registry names (e.g., \"minecraft:village_plains=64\", \"minecraft:stronghold=32\")"}).define("structureSpecificDistances", Arrays.asList(new String[0]), Config::isValidStructureDistanceList);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> STRUCTURE_SPECIFIC_ENABLED_RAW = BUILDER.comment(new String[]{"Per-structure enable/disable settings. Format: [\"structure_id=true\", \"another_id=false\"]", "Note: Use actual Minecraft registry names (e.g., \"minecraft:village_plains=true\", \"minecraft:stronghold=false\")"}).define("structureSpecificEnabled", Arrays.asList(new String[0]), Config::isValidStructureBooleanList);
    static final ModConfigSpec SPEC = BUILDER.build();
    public static boolean enableOverlapPrevention;
    public static boolean logBlockedStructures;
    public static boolean use3DOverlapDetection;
    public static int minOverlapDistance;
    public static Set<String> structureWhitelist;
    public static Set<String> structureBlacklist;
    public static Map<String, Integer> structureSpecificDistances;
    public static Map<String, Boolean> structureSpecificEnabled;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        String[] parts;
        enableOverlapPrevention = (Boolean)ENABLE_OVERLAP_PREVENTION.get();
        logBlockedStructures = (Boolean)LOG_BLOCKED_STRUCTURES.get();
        use3DOverlapDetection = (Boolean)USE_3D_OVERLAP_DETECTION.get();
        minOverlapDistance = (Integer)MIN_OVERLAP_DISTANCE.get();
        structureWhitelist = new HashSet<String>((Collection)STRUCTURE_WHITELIST.get());
        structureBlacklist = new HashSet<String>((Collection)STRUCTURE_BLACKLIST.get());
        structureSpecificDistances = new LinkedHashMap<String, Integer>();
        for (String entry : (List)STRUCTURE_SPECIFIC_DISTANCES_RAW.get()) {
            parts = entry.split("=", 2);
            if (parts.length != 2) continue;
            try {
                structureSpecificDistances.put(parts[0], Integer.parseInt(parts[1]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        structureSpecificEnabled = new LinkedHashMap<String, Boolean>();
        for (String entry : (List)STRUCTURE_SPECIFIC_ENABLED_RAW.get()) {
            parts = entry.split("=", 2);
            if (parts.length != 2) continue;
            structureSpecificEnabled.put(parts[0], Boolean.parseBoolean(parts[1]));
        }
    }

    private static boolean isValidStructureId(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        String str = (String)obj;
        return str.contains(":") && str.length() > 3;
    }

    private static boolean isValidStructureIdList(Object obj) {
        if (!(obj instanceof List)) {
            return false;
        }
        List list = (List)obj;
        for (Object item : list) {
            if (Config.isValidStructureId(item)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidStructureDistanceList(Object obj) {
        if (!(obj instanceof List)) {
            return false;
        }
        List list = (List)obj;
        for (Object item : list) {
            if (!(item instanceof String)) {
                return false;
            }
            String str = (String)item;
            if (!str.contains("=")) {
                return false;
            }
            String[] parts = str.split("=", 2);
            if (parts.length != 2) {
                return false;
            }
            if (!Config.isValidStructureId(parts[0])) {
                return false;
            }
            try {
                int value = Integer.parseInt(parts[1]);
                if (value >= 1 && value <= 1000) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    private static boolean isValidStructureBooleanList(Object obj) {
        if (!(obj instanceof List)) {
            return false;
        }
        List list = (List)obj;
        for (Object item : list) {
            if (!(item instanceof String)) {
                return false;
            }
            String str = (String)item;
            if (!str.contains("=")) {
                return false;
            }
            String[] parts = str.split("=", 2);
            if (parts.length != 2) {
                return false;
            }
            if (!Config.isValidStructureId(parts[0])) {
                return false;
            }
            if (parts[1].equals("true") || parts[1].equals("false")) continue;
            return false;
        }
        return true;
    }

    public static boolean isStructureEnabled(String structureId) {
        if (structureSpecificEnabled.containsKey(structureId)) {
            return structureSpecificEnabled.get(structureId);
        }
        if (structureBlacklist.contains(structureId)) {
            return false;
        }
        if (!structureWhitelist.isEmpty()) {
            return structureWhitelist.contains(structureId);
        }
        return true;
    }

    public static int getStructureDistance(String structureId) {
        return structureSpecificDistances.getOrDefault(structureId, minOverlapDistance);
    }
}

