/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.structures.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.text2speech.Narrator;
import com.prefab.ClientModRegistryBase;
import com.prefab.PrefabBase;
import com.prefab.Triple;
import com.prefab.blocks.BlockStructureScanner;
import com.prefab.config.StructureScannerConfig;
import com.prefab.structures.base.BuildBlock;
import com.prefab.structures.base.Structure;
import com.prefab.structures.config.StructureConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class StructureRenderHandler {
    public static StructureConfiguration currentConfiguration;
    public static Structure currentStructure;
    public static boolean showedMessage;
    private static int dimension;
    private static HashMap<Integer, Integer> stateColor;
    private static HashMap<Integer, Triple<Float, Float, Float>> colorRGB;
    private static Minecraft mcInstance;
    private static final Direction[] DIRECTIONS;
    private static HashMap<Integer, ArrayList<List<BakedQuad>>> blockModelQuads;

    public static void setStructure(Structure structure, StructureConfiguration configuration) {
        currentStructure = structure;
        currentConfiguration = configuration;
        showedMessage = false;
        stateColor = new HashMap(40000, 1.0f);
        colorRGB = new HashMap(40000, 1.0f);
        blockModelQuads = new HashMap(40000, 1.0f);
        mcInstance = Minecraft.getInstance();
        if (StructureRenderHandler.mcInstance.level != null) {
            dimension = StructureRenderHandler.mcInstance.level.dimensionType().logicalHeight();
        }
    }

    public static void RenderTest(Level worldIn, PoseStack matrixStack, MultiBufferSource multiBufferSource, float cameraX, float cameraY, float cameraZ) {
        if (currentStructure != null && dimension == Minecraft.getInstance().player.level().dimensionType().logicalHeight() && currentConfiguration != null && PrefabBase.serverConfiguration.enableStructurePreview) {
            BlockPos originalPos = StructureRenderHandler.currentConfiguration.pos.above();
            float blockXOffset = originalPos.getX();
            float blockZOffset = originalPos.getZ();
            float blockStartYOffset = originalPos.getY();
            StructureRenderHandler.drawBox(matrixStack, multiBufferSource, blockXOffset, blockZOffset, blockStartYOffset, cameraX, cameraY, cameraZ, 1, 1, 1);
        }
    }

    public static void drawBox(PoseStack matrixStack, MultiBufferSource multiBufferSource, float blockXOffset, float blockZOffset, float blockStartYOffset, float cameraX, float cameraY, float cameraZ, int xLength, int zLength, int height) {
        Matrix4f matrix4f = matrixStack.last().pose();
        float translatedX = blockXOffset - cameraX;
        float translatedY = (float)((double)(blockStartYOffset - cameraY) + 0.02);
        float translatedYEnd = (float)((double)(translatedY + (float)height) - 0.02);
        float translatedZ = blockZOffset - cameraZ;
        VertexConsumer bufferBuilder = multiBufferSource.getBuffer(RenderType.debugLineStrip((double)2.0));
        bufferBuilder.addVertex(matrix4f, translatedX, translatedY, translatedZ).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, translatedX, translatedYEnd, translatedZ).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder = multiBufferSource.getBuffer(RenderType.debugLineStrip((double)2.0));
        bufferBuilder.addVertex(matrix4f, translatedX + (float)xLength, translatedY, translatedZ).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, translatedX + (float)xLength, translatedYEnd, translatedZ).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder = multiBufferSource.getBuffer(RenderType.debugLineStrip((double)2.0));
        bufferBuilder.addVertex(matrix4f, translatedX, translatedY, translatedZ + (float)zLength).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, translatedX, translatedYEnd, translatedZ + (float)zLength).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder = multiBufferSource.getBuffer(RenderType.debugLineStrip((double)2.0));
        bufferBuilder.addVertex(matrix4f, translatedX + (float)xLength, translatedY, translatedZ + (float)zLength).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, translatedX + (float)xLength, translatedYEnd, translatedZ + (float)zLength).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder = multiBufferSource.getBuffer(RenderType.debugLineStrip((double)2.0));
        bufferBuilder.addVertex(matrix4f, translatedX, translatedY, translatedZ).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, translatedX, translatedY, translatedZ + (float)zLength).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, translatedX + (float)xLength, translatedY, translatedZ + (float)zLength).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, translatedX + (float)xLength, translatedY, translatedZ).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, translatedX, translatedY, translatedZ).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, translatedX + (float)xLength, translatedY, translatedZ).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, translatedX + (float)xLength, translatedY, translatedZ + (float)zLength).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, translatedX, translatedY, translatedZ + (float)zLength).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder = multiBufferSource.getBuffer(RenderType.debugLineStrip((double)2.0));
        bufferBuilder.addVertex(matrix4f, translatedX, translatedYEnd, translatedZ).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, translatedX, translatedYEnd, translatedZ + (float)zLength).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, translatedX + (float)xLength, translatedYEnd, translatedZ + (float)zLength).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, translatedX + (float)xLength, translatedYEnd, translatedZ).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, translatedX, translatedYEnd, translatedZ).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, translatedX + (float)xLength, translatedYEnd, translatedZ).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, translatedX + (float)xLength, translatedYEnd, translatedZ + (float)zLength).setColor(1.0f, 1.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, translatedX, translatedYEnd, translatedZ + (float)zLength).setColor(1.0f, 1.0f, 0.0f, 1.0f);
    }

    public static void renderScanningBoxes(PoseStack matrixStack, MultiBufferSource multiBufferSource, float cameraX, float cameraY, float cameraZ) {
        for (int i = 0; i < ClientModRegistryBase.structureScanners.size(); ++i) {
            boolean removeConfig;
            StructureScannerConfig config = ClientModRegistryBase.structureScanners.get(i);
            BlockPos pos = config.blockPos;
            boolean bl = removeConfig = pos == null;
            if (pos != null) {
                boolean bl2 = removeConfig = !(Minecraft.getInstance().level.getBlockState(pos.relative(Direction.UP)).getBlock() instanceof BlockStructureScanner);
            }
            if (removeConfig) {
                ClientModRegistryBase.structureScanners.remove(i);
                --i;
                continue;
            }
            Direction leftDirection = config.direction.getCounterClockWise();
            BlockPos startingPosition = config.blockPos.relative(leftDirection, config.blocksToTheLeft).relative(Direction.DOWN, config.blocksDown).relative(config.direction, config.blocksParallel);
            int xLength = config.blocksWide;
            int zLength = config.blocksLong;
            switch (config.direction) {
                case NORTH: {
                    zLength = -zLength;
                    startingPosition = startingPosition.relative(config.direction.getOpposite());
                    break;
                }
                case EAST: {
                    int tempWidth = xLength;
                    xLength = zLength;
                    zLength = tempWidth;
                    break;
                }
                case SOUTH: {
                    xLength = -xLength;
                    startingPosition = startingPosition.relative(config.direction.getCounterClockWise());
                    break;
                }
                case WEST: {
                    int tempLength = zLength;
                    zLength = -xLength;
                    xLength = -tempLength;
                    startingPosition = startingPosition.relative(config.direction.getOpposite());
                    startingPosition = startingPosition.relative(config.direction.getCounterClockWise());
                    break;
                }
            }
            StructureRenderHandler.drawBox(matrixStack, multiBufferSource, startingPosition.getX(), startingPosition.getZ(), startingPosition.getY(), cameraX, cameraY, cameraZ, xLength, zLength, config.blocksTall);
        }
    }

    public static void basicBlockRenderExample(Player player, PoseStack poseStack, BufferBuilder buffer, double cameraX, double cameraY, double cameraZ) {
        if (currentStructure != null && dimension == player.level().dimensionType().logicalHeight() && currentConfiguration != null && PrefabBase.serverConfiguration.enableStructurePreview) {
            Level world = player.level();
            try {
                BlockState state = Blocks.REDSTONE_BLOCK.defaultBlockState();
                BlockPos blockPos = StructureRenderHandler.currentConfiguration.pos.relative(Direction.SOUTH, 2).above(2);
                BlockRenderDispatcher brd = mcInstance.getBlockRenderer();
                BakedModel blockModel = brd.getBlockModel(state);
                ModelBlockRenderer modelBlockRenderer = brd.getModelRenderer();
                int color = mcInstance.getBlockColors().getColor(state, null, null, 0);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                PoseStack.Pose originalPose = (PoseStack.Pose)poseStack.poseStack.peekLast();
                float scaleValue = (float)blockPos.getY() + 1.3f;
                PoseStack.Pose lastPose = new PoseStack.Pose(originalPose);
                lastPose.pose().translate((float)(-cameraX), (float)(-cameraY), (float)(-cameraZ));
                lastPose.pose().translate((float)blockPos.getX(), (float)blockPos.getY(), (float)blockPos.getZ());
                StructureRenderHandler.renderModel(lastPose, (VertexConsumer)buffer, state, blockModel, r, g, b, 0xF000F0, OverlayTexture.NO_OVERLAY, state.hashCode());
            }
            catch (Exception ex) {
                PrefabBase.logger.error((Object)ex);
            }
        }
    }

    public static void newRenderPlayerLook(Player player, PoseStack poseStack, VertexConsumer buffer, double cameraX, double cameraY, double cameraZ) {
        if (currentStructure != null && dimension == player.level().dimensionType().logicalHeight() && currentConfiguration != null && PrefabBase.serverConfiguration.enableStructurePreview) {
            Level world = player.level();
            Camera camera = StructureRenderHandler.mcInstance.getEntityRenderDispatcher().camera;
            double renderPosX = camera.getPosition().x();
            double renderPosY = camera.getPosition().y();
            double renderPosZ = camera.getPosition().z();
            BlockRenderDispatcher brd = mcInstance.getBlockRenderer();
            Vec3 cameraPosition = new Vec3(cameraX, cameraY, cameraZ);
            Direction playerViewDirection = player.getNearestViewDirection();
            Vec3 playerViewVector = player.getViewVector(1.0f);
            ArrayList<BuildBlock> buildBlocks = currentStructure.getBlocks();
            PoseStack.Pose originalPose = (PoseStack.Pose)poseStack.poseStack.peekLast();
            try {
                for (BuildBlock buildBlock : buildBlocks) {
                    StructureRenderHandler.processBuildBlockForRendering(buildBlock, world, player, cameraPosition, playerViewDirection, playerViewVector, originalPose, renderPosX, renderPosY, renderPosZ, brd, buffer);
                }
                if (!showedMessage) {
                    Minecraft mc = Minecraft.getInstance();
                    Narrator.getNarrator().clear();
                    MutableComponent message = Component.translatable((String)"prefab.gui.preview.notice");
                    message.setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN));
                    mc.gui.getChat().addMessage((Component)message);
                    message = Component.translatable((String)"prefab.gui.structure.block.clicked");
                    message.setStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW));
                    mc.gui.getChat().addMessage((Component)message);
                    showedMessage = true;
                }
            }
            catch (Exception ex) {
                PrefabBase.logger.error((Object)ex);
            }
        }
    }

    private static void processBuildBlockForRendering(BuildBlock buildBlock, Level world, Player player, Vec3 cameraPosition, Direction playerViewDirection, Vec3 playerViewVector, PoseStack.Pose originalPose, double renderPosX, double renderPosY, double renderPosZ, BlockRenderDispatcher brd, VertexConsumer buffer) {
        Block foundBlock;
        Block block = foundBlock = buildBlock.getBlockState() != null ? buildBlock.getBlockState().getBlock() : (Block)BuiltInRegistries.BLOCK.get(buildBlock.getResourceLocation());
        if (foundBlock != null) {
            double result;
            boolean boolCheck;
            BlockPos buildBlockPos;
            BlockState targetBlock;
            if (buildBlock.blockPos == null) {
                buildBlock.blockPos = buildBlock.getStartingPosition().getRelativePosition(StructureRenderHandler.currentConfiguration.pos, currentStructure.getClearSpace().getShape().getDirection(), StructureRenderHandler.currentConfiguration.houseFacing);
            }
            if ((targetBlock = world.getBlockState(buildBlockPos = buildBlock.blockPos)).getBlock() != Blocks.AIR && targetBlock.getBlock() != Blocks.WATER) {
                return;
            }
            if (buildBlock.centerOfBlock == null) {
                buildBlock.centerOfBlock = Vec3.atCenterOf((Vec3i)buildBlockPos);
            }
            Vec3 vectorBetweenPlayerAndBlock = new Vec3((double)buildBlockPos.getX() - player.getX(), (double)buildBlockPos.getY() - player.getEyeY(), (double)buildBlockPos.getZ() - player.getZ());
            vectorBetweenPlayerAndBlock.normalize();
            BlockHitResult hitResult = Shapes.block().clip(cameraPosition, buildBlock.centerOfBlock, buildBlockPos);
            if (hitResult == null || hitResult.getDirection() != Direction.UP && hitResult.getDirection() != Direction.DOWN && hitResult.getDirection() == playerViewDirection) {
                return;
            }
            double lineBetweenPlayerViewBlock = playerViewVector.normalize().dot(vectorBetweenPlayerAndBlock);
            boolean bl = boolCheck = lineBetweenPlayerViewBlock > (result = 1.0 - 0.025 / vectorBetweenPlayerAndBlock.length());
            if (!boolCheck) {
                return;
            }
            if (buildBlock.getBlockState() == null) {
                BlockState blockState = foundBlock.defaultBlockState();
                buildBlock = BuildBlock.SetBlockState(currentConfiguration, player.level(), StructureRenderHandler.currentConfiguration.pos, buildBlock, foundBlock, blockState, currentStructure);
            }
            StructureRenderHandler.renderBlockAt(originalPose, buffer, buildBlock.getBlockState(), buildBlockPos, buildBlock.hashCode(), renderPosX, renderPosY, renderPosZ, brd, world);
            if (buildBlock.getSubBlock() != null) {
                Block foundSubBlock;
                BuildBlock subBuildBlock = buildBlock.getSubBlock();
                Block block2 = foundSubBlock = subBuildBlock.getBlockState() != null ? subBuildBlock.getBlockState().getBlock() : (Block)BuiltInRegistries.BLOCK.get(subBuildBlock.getResourceLocation());
                if (subBuildBlock.getBlockState() == null) {
                    BlockState subBlockState = foundSubBlock.defaultBlockState();
                    subBuildBlock = BuildBlock.SetBlockState(currentConfiguration, player.level(), StructureRenderHandler.currentConfiguration.pos, buildBlock.getSubBlock(), foundSubBlock, subBlockState, currentStructure);
                }
                if (subBuildBlock.blockPos == null) {
                    subBuildBlock.blockPos = subBuildBlock.getStartingPosition().getRelativePosition(StructureRenderHandler.currentConfiguration.pos, currentStructure.getClearSpace().getShape().getDirection(), StructureRenderHandler.currentConfiguration.houseFacing);
                }
                StructureRenderHandler.renderBlockAt(originalPose, buffer, subBuildBlock.getBlockState(), subBuildBlock.blockPos, subBuildBlock.hashCode(), renderPosX, renderPosY, renderPosZ, brd, world);
            }
        }
    }

    private static void renderBlockAt(PoseStack.Pose originalPose, VertexConsumer buffer, BlockState state, BlockPos pos, int buildBlockHash, double renderPosX, double renderPosY, double renderPosZ, BlockRenderDispatcher brd, Level level) {
        if (state.getRenderShape() != RenderShape.INVISIBLE && state.getRenderShape() == RenderShape.MODEL) {
            PoseStack.Pose lastPose = new PoseStack.Pose(originalPose);
            lastPose.pose().translate((float)(-renderPosX), (float)(-renderPosY), (float)(-renderPosZ));
            lastPose.pose().translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            ModelBlockRenderer modelBlockRenderer = brd.getModelRenderer();
            BakedModel model = brd.getBlockModel(state);
            int blockStateHash = state.hashCode();
            int color = stateColor.computeIfAbsent(blockStateHash, x -> mcInstance.getBlockColors().getColor(state, null, null, 0));
            Triple colorRGB = StructureRenderHandler.colorRGB.computeIfAbsent(blockStateHash, x -> {
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                return new Triple<Float, Float, Float>(Float.valueOf(r), Float.valueOf(g), Float.valueOf(b));
            });
            try {
                StructureRenderHandler.renderModel(lastPose, buffer, state, model, ((Float)colorRGB.getFirst()).floatValue(), ((Float)colorRGB.getSecond()).floatValue(), ((Float)colorRGB.getThird()).floatValue(), 0xF000F0, OverlayTexture.NO_OVERLAY, blockStateHash);
            }
            catch (Exception ex) {
                System.out.println("System Exception: " + ex.getMessage());
            }
        }
    }

    public static void renderModel(PoseStack.Pose pose, VertexConsumer vertexConsumer, @Nullable BlockState blockState, BakedModel bakedModel, float f, float g, float h, int i, int j, int blockStateHash) {
        RandomSource randomSource = RandomSource.create();
        long l = 42L;
        if (!blockModelQuads.containsKey(blockStateHash)) {
            ArrayList<List> bakedQuads = new ArrayList<List>();
            for (Direction direction : DIRECTIONS) {
                randomSource.setSeed(42L);
                List quadList = bakedModel.getQuads(blockState, direction, randomSource);
                StructureRenderHandler.renderQuadList(pose, vertexConsumer, f, g, h, quadList, i, j);
                bakedQuads.add(quadList);
            }
            randomSource.setSeed(42L);
            List quadList = bakedModel.getQuads(blockState, null, randomSource);
            StructureRenderHandler.renderQuadList(pose, vertexConsumer, f, g, h, quadList, i, j);
            bakedQuads.add(quadList);
            blockModelQuads.put(blockStateHash, bakedQuads);
            return;
        }
        ArrayList<List<BakedQuad>> bakedQuads = blockModelQuads.get(blockStateHash);
        for (List<BakedQuad> quadList : bakedQuads) {
            StructureRenderHandler.renderQuadList(pose, vertexConsumer, f, g, h, quadList, i, j);
        }
    }

    private static void renderQuadList(PoseStack.Pose pose, VertexConsumer vertexConsumer, float f, float g, float h, List<BakedQuad> list, int i, int j) {
        for (BakedQuad quad : list) {
            float m;
            float l;
            float k;
            if (quad.isTinted()) {
                k = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
                l = Mth.clamp((float)g, (float)0.0f, (float)1.0f);
                m = Mth.clamp((float)h, (float)0.0f, (float)1.0f);
            } else {
                k = 1.0f;
                l = 1.0f;
                m = 1.0f;
            }
            StructureRenderHandler.putBulkData(vertexConsumer, pose, quad, k, l, m, i, j);
        }
    }

    private static void putBulkData(VertexConsumer vertexConsumer, PoseStack.Pose pose, BakedQuad bakedQuad, float k, float l, float m, int i, int j) {
        int[] js = bakedQuad.getVertices();
        Vec3i vec3i = bakedQuad.getDirection().getNormal();
        Matrix4f matrix4f = pose.pose();
        Vector3f vector3f = pose.transformNormal((float)vec3i.getX(), (float)vec3i.getY(), (float)vec3i.getZ(), new Vector3f());
        int trimmedLength = js.length / 8;
        int baseColor = 255;
        for (int counter = 0; counter < trimmedLength; ++counter) {
            float betterO = Float.intBitsToFloat(js[counter * 8]);
            float betterP = Float.intBitsToFloat(js[counter * 8 + 1]);
            float betterQ = Float.intBitsToFloat(js[counter * 8 + 2]);
            float u = 1.0f * k * 255.0f;
            float v = 1.0f * l * 255.0f;
            float w = 1.0f * m * 255.0f;
            float betterT = Float.intBitsToFloat(js[counter * 8 + 4]);
            float betterZ = Float.intBitsToFloat(js[counter * 8 + 5]);
            int x = FastColor.ARGB32.color((int)baseColor, (int)((int)u), (int)((int)v), (int)((int)w));
            Vector3f vector3f2 = matrix4f.transformPosition(betterO, betterP, betterQ, new Vector3f());
            vertexConsumer.addVertex(vector3f2.x(), vector3f2.y(), vector3f2.z(), x, betterT, betterZ, j, i, vector3f.x(), vector3f.y(), vector3f.z());
        }
    }

    static {
        showedMessage = false;
        DIRECTIONS = Direction.values();
    }
}

