/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.structures.predefined;

import com.prefab.PrefabBase;
import com.prefab.structures.base.BuildBlock;
import com.prefab.structures.base.BuildClear;
import com.prefab.structures.base.BuildingMethods;
import com.prefab.structures.base.Structure;
import com.prefab.structures.config.BulldozerConfiguration;
import com.prefab.structures.config.StructureConfiguration;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;

public class StructureBulldozer
extends Structure {
    protected static DiggerItem diamondPickaxe;
    protected static DiggerItem diamondShovel;
    protected static DiggerItem diamondAxe;
    protected static ItemStack diamondPickaxeStack;
    protected static ItemStack diamondShovelStack;
    protected static ItemStack diamondAxeStack;

    public StructureBulldozer() {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(15);
        clearedSpace.getShape().setLength(16);
        clearedSpace.getShape().setWidth(16);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(1);
        this.setClearSpace(clearedSpace);
        this.setBlocks(new ArrayList<BuildBlock>());
    }

    @Override
    protected Boolean BlockShouldBeClearedDuringConstruction(StructureConfiguration configuration, Level world, BlockPos originalPos, BlockPos blockPos) {
        BlockState state = world.getBlockState(blockPos);
        BulldozerConfiguration specificConfiguration = (BulldozerConfiguration)configuration;
        boolean pickAxeEffective = diamondPickaxe.isCorrectToolForDrops(diamondPickaxeStack, state);
        boolean axeEffective = diamondAxe.isCorrectToolForDrops(diamondAxeStack, state);
        boolean shovelEffective = diamondShovel.isCorrectToolForDrops(diamondShovelStack, state);
        if (!specificConfiguration.creativeMode && PrefabBase.serverConfiguration.allowBulldozerToCreateDrops && (state.requiresCorrectToolForDrops() && pickAxeEffective || axeEffective || shovelEffective || !state.requiresCorrectToolForDrops()) && state.getDestroySpeed((BlockGetter)world, blockPos) >= 0.0f) {
            Block.dropResources((BlockState)state, (Level)world, (BlockPos)blockPos);
        }
        if (specificConfiguration.creativeMode && state.getBlock() instanceof LiquidBlock) {
            BuildingMethods.ReplaceBlock(world, blockPos, Blocks.STONE);
        }
        return true;
    }

    @Override
    public void BeforeHangingEntityRemoved(HangingEntity hangingEntity) {
        if (PrefabBase.serverConfiguration.allowBulldozerToCreateDrops) {
            hangingEntity.dropItem(null);
        }
    }

    static {
        diamondAxe = (DiggerItem)Items.DIAMOND_AXE;
        diamondPickaxe = (DiggerItem)Items.DIAMOND_PICKAXE;
        diamondShovel = (DiggerItem)Items.DIAMOND_SHOVEL;
        diamondPickaxeStack = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
        diamondShovelStack = new ItemStack((ItemLike)Items.DIAMOND_SHOVEL);
        diamondAxeStack = new ItemStack((ItemLike)Items.DIAMOND_AXE);
    }
}

