/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.structures.predefined;

import com.prefab.PrefabBase;
import com.prefab.Tuple;
import com.prefab.blocks.FullDyeColor;
import com.prefab.structures.base.BuildBlock;
import com.prefab.structures.base.BuildingMethods;
import com.prefab.structures.base.Structure;
import com.prefab.structures.config.BasicStructureConfiguration;
import com.prefab.structures.config.StructureConfiguration;
import com.prefab.structures.config.enums.BaseOption;
import com.prefab.structures.config.enums.FarmAdvancedOptions;
import com.prefab.structures.config.enums.FarmImprovedOptions;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class StructureBasic
extends Structure {
    private final ArrayList<BlockPos> mobSpawnerPos = new ArrayList();
    private BlockPos customBlockPos = null;

    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, Level world, BlockPos originalPos, Block foundBlock, BlockState blockState, Player player) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        String structureName = config.basicStructureName.getName();
        BaseOption chosenOption = config.chosenOption;
        if (foundBlock instanceof HopperBlock && structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.FarmImproved.getName()) && chosenOption == FarmImprovedOptions.AutomatedChickenCoop) {
            this.customBlockPos = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof TrapDoorBlock && structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance.getName())) {
            this.customBlockPos = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else {
            if (foundBlock instanceof BedBlock && config.chosenOption.getHasBedColor()) {
                BlockPos bedHeadPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                BlockPos bedFootPosition = block.getSubBlock().getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                Tuple<BlockState, BlockState> blockStateTuple = BuildingMethods.getBedState(bedHeadPosition, bedFootPosition, config.bedColor);
                block.setBlockState(blockStateTuple.getFirst());
                block.getSubBlock().setBlockState(blockStateTuple.getSecond());
                this.priorityOneBlocks.add(block);
                return true;
            }
            if (foundBlock instanceof SpawnerBlock && structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.FarmAdvanced.getName()) && chosenOption == FarmAdvancedOptions.MonsterMasher && PrefabBase.serverConfiguration.includeSpawnersInMasher) {
                this.mobSpawnerPos.add(block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing));
            }
        }
        return false;
    }

    @Override
    protected Boolean BlockShouldBeClearedDuringConstruction(StructureConfiguration configuration, Level world, BlockPos originalPos, BlockPos blockPos) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        if (config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AquaBase.getName()) || config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AquaBaseImproved.getName())) {
            BlockState blockState = world.getBlockState(blockPos);
            return blockState.getBlock() != Blocks.WATER;
        }
        return true;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, ServerLevel world, BlockPos originalPos, Player player) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        String structureName = config.basicStructureName.getName();
        BaseOption chosenOption = config.chosenOption;
        if (this.customBlockPos != null) {
            if (structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.FarmImproved.getName()) && chosenOption == FarmImprovedOptions.AutomatedChickenCoop) {
                for (int i = 0; i < 4; ++i) {
                    Chicken entity = new Chicken(EntityType.CHICKEN, (Level)world);
                    entity.setPos((double)this.customBlockPos.getX(), (double)this.customBlockPos.above().getY(), (double)this.customBlockPos.getZ());
                    world.addFreshEntity((Entity)entity);
                }
            } else if (structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance.getName())) {
                BuildingMethods.PlaceMineShaft(world, this.customBlockPos.below(), configuration.houseFacing, true);
            }
            this.customBlockPos = null;
        }
        if (structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.FarmAdvanced.getName()) && chosenOption == FarmAdvancedOptions.MonsterMasher) {
            int monstersPlaced = 0;
            for (BlockPos spawnerPos : this.mobSpawnerPos) {
                BlockEntity tileEntity = world.getBlockEntity(spawnerPos);
                if (!(tileEntity instanceof SpawnerBlockEntity)) continue;
                SpawnerBlockEntity spawner = (SpawnerBlockEntity)tileEntity;
                switch (monstersPlaced) {
                    case 0: {
                        spawner.getSpawner().setEntityId(EntityType.ZOMBIE, (Level)world, world.random, spawnerPos);
                        break;
                    }
                    case 1: {
                        spawner.getSpawner().setEntityId(EntityType.SKELETON, (Level)world, world.random, spawnerPos);
                        break;
                    }
                    case 2: {
                        spawner.getSpawner().setEntityId(EntityType.WITCH, (Level)world, world.random, spawnerPos);
                        break;
                    }
                    default: {
                        spawner.getSpawner().setEntityId(EntityType.CREEPER, (Level)world, world.random, spawnerPos);
                    }
                }
                ++monstersPlaced;
            }
        }
        if (structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.AquaBase.getName()) || structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.AquaBaseImproved.getName())) {
            BlockPos airPos = originalPos.above(4).relative(configuration.houseFacing.getOpposite(), 1);
            world.removeBlock(airPos.relative(configuration.houseFacing.getClockWise()), false);
            world.removeBlock(airPos, false);
            world.removeBlock(airPos.relative(configuration.houseFacing.getCounterClockWise()), false);
            airPos = airPos.below();
            world.removeBlock(airPos.relative(configuration.houseFacing.getClockWise()), false);
            world.removeBlock(airPos, false);
            world.removeBlock(airPos.relative(configuration.houseFacing.getCounterClockWise()), false);
            airPos = airPos.below();
            world.removeBlock(airPos.relative(configuration.houseFacing.getClockWise()), false);
            world.removeBlock(airPos, false);
            world.removeBlock(airPos.relative(configuration.houseFacing.getCounterClockWise()), false);
            airPos = airPos.below();
            world.removeBlock(airPos.relative(configuration.houseFacing.getClockWise()), false);
            world.removeBlock(airPos, false);
            world.removeBlock(airPos.relative(configuration.houseFacing.getCounterClockWise()), false);
            airPos = airPos.relative(configuration.houseFacing.getOpposite()).above();
            world.removeBlock(airPos.relative(configuration.houseFacing.getClockWise()), false);
            world.removeBlock(airPos, false);
            world.removeBlock(airPos.relative(configuration.houseFacing.getCounterClockWise()), false);
            airPos = airPos.above();
            world.removeBlock(airPos.relative(configuration.houseFacing.getClockWise()), false);
            world.removeBlock(airPos, false);
            world.removeBlock(airPos.relative(configuration.houseFacing.getCounterClockWise()), false);
            airPos = airPos.above();
            world.removeBlock(airPos, false);
        }
    }

    @Override
    protected boolean hasGlassColor(StructureConfiguration configuration) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        BaseOption chosenOption = config.chosenOption;
        return chosenOption.getHasGlassColor();
    }

    @Override
    protected FullDyeColor getGlassColor(StructureConfiguration configuration) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        return config.glassColor;
    }
}

