/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.structures.messages;

import com.prefab.network.message.TagMessage;
import com.prefab.structures.config.BasicStructureConfiguration;
import com.prefab.structures.config.BulldozerConfiguration;
import com.prefab.structures.config.HouseAdvancedConfiguration;
import com.prefab.structures.config.HouseConfiguration;
import com.prefab.structures.config.HouseImprovedConfiguration;
import com.prefab.structures.config.InstantBridgeConfiguration;
import com.prefab.structures.config.StructureConfiguration;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class StructureTagMessage
extends TagMessage {
    private EnumStructureConfiguration structureConfig;

    public StructureTagMessage() {
    }

    public StructureTagMessage(CompoundTag tagMessage, EnumStructureConfiguration structureConfig) {
        super(tagMessage);
        this.structureConfig = structureConfig;
    }

    public StructureTagMessage(FriendlyByteBuf friendlyByteBuf) {
        StructureTagMessage.decode(this, friendlyByteBuf);
    }

    public static StructureTagMessage decode(StructureTagMessage messageToupdate, FriendlyByteBuf buf) {
        CompoundTag tag = buf.readNbt();
        messageToupdate.structureConfig = EnumStructureConfiguration.getFromIdentifier(tag.getInt("config"));
        messageToupdate.tagMessage = tag.getCompound("dataTag");
        return messageToupdate;
    }

    public static void encode(StructureTagMessage message, FriendlyByteBuf buf) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("config", message.structureConfig.identifier);
        tag.put("dataTag", (Tag)message.tagMessage);
        buf.writeNbt((Tag)tag);
    }

    public EnumStructureConfiguration getStructureConfig() {
        return this.structureConfig;
    }

    @Override
    public void write(FriendlyByteBuf friendlyByteBuf) {
        StructureTagMessage.encode(this, friendlyByteBuf);
    }

    public static enum EnumStructureConfiguration {
        Basic(0, new BasicStructureConfiguration()),
        StartHouse(1, new HouseConfiguration()),
        ModerateHouse(2, new HouseImprovedConfiguration()),
        Bulldozer(3, new BulldozerConfiguration()),
        InstantBridge(4, new InstantBridgeConfiguration()),
        AdvancedHouse(5, new HouseAdvancedConfiguration());

        public int identifier;
        public StructureConfiguration structureConfig;

        private <T extends StructureConfiguration> EnumStructureConfiguration(int identifier, T structureConfig) {
            this.identifier = identifier;
            this.structureConfig = structureConfig;
        }

        public static EnumStructureConfiguration getFromIdentifier(int identifier) {
            for (EnumStructureConfiguration config : EnumStructureConfiguration.values()) {
                if (config.identifier != identifier) continue;
                return config;
            }
            return Basic;
        }

        public static EnumStructureConfiguration getByConfigurationInstance(StructureConfiguration structureConfig) {
            for (EnumStructureConfiguration configuration : EnumStructureConfiguration.values()) {
                if (!configuration.structureConfig.getClass().equals(structureConfig.getClass())) continue;
                return configuration;
            }
            return null;
        }
    }
}

