/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.structures.items;

import com.prefab.ClientModRegistryBase;
import com.prefab.ModRegistryBase;
import com.prefab.structures.gui.GuiBulldozer;
import com.prefab.structures.items.StructureItem;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;

public class ItemBulldozer
extends StructureItem {
    private boolean creativePowered = false;

    public ItemBulldozer() {
        super(new Item.Properties().durability(4));
    }

    public ItemBulldozer(boolean creativePowered) {
        super(new Item.Properties());
        this.creativePowered = creativePowered;
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().isClientSide() && context.getClickedFace() == Direction.UP && this.getPoweredValue(context.getPlayer(), context.getHand())) {
            ClientModRegistryBase.openGuiForItem(context);
            return InteractionResult.PASS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    protected void Initialize() {
        ModRegistryBase.guiRegistrations.add(x -> this.RegisterGui(GuiBulldozer.class));
    }

    private boolean getPoweredValue(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        return this.getPoweredValue(stack);
    }

    protected boolean getPoweredValue(ItemStack stack) {
        if (this.creativePowered) {
            return true;
        }
        if (stack.getItem() == ModRegistryBase.Bulldozer) {
            if (stack.getComponents().isEmpty()) {
                CompoundTag baseTag = new CompoundTag();
                CompoundTag prefabTag = new CompoundTag();
                baseTag.put("prefab", (Tag)prefabTag);
                prefabTag.putBoolean("powered", false);
                CustomData customData = CustomData.of((CompoundTag)baseTag);
                stack.set(DataComponents.CUSTOM_DATA, (Object)customData);
            } else {
                CompoundTag prefabTag;
                CompoundTag tag;
                CustomData customData = (CustomData)stack.getComponents().get(DataComponents.CUSTOM_DATA);
                if (customData != null && (tag = customData.copyTag()).contains("prefab") && (prefabTag = tag.getCompound("prefab")).contains("powered")) {
                    return prefabTag.getBoolean("powered");
                }
            }
        }
        return false;
    }

    public void setPoweredValue(ItemStack stack, boolean value) {
        CompoundTag baseTag = new CompoundTag();
        CompoundTag prefabTag = new CompoundTag();
        prefabTag.putBoolean("powered", value);
        baseTag.put("prefab", (Tag)prefabTag);
        CustomData customData = CustomData.of((CompoundTag)baseTag);
        stack.set(DataComponents.CUSTOM_DATA, (Object)customData);
    }
}

