/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.structures.gui;

import com.prefab.ClientModRegistryBase;
import com.prefab.PrefabBase;
import com.prefab.Tuple;
import com.prefab.config.ModConfiguration;
import com.prefab.gui.GuiLangKeys;
import com.prefab.gui.GuiUtils;
import com.prefab.gui.controls.ExtendedButton;
import com.prefab.gui.controls.GuiCheckBox;
import com.prefab.structures.config.HouseAdvancedConfiguration;
import com.prefab.structures.gui.GuiStructure;
import com.prefab.structures.messages.StructureTagMessage;
import com.prefab.structures.predefined.StructureHouseAdvanced;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;

public class GuiHouseAdvanced
extends GuiStructure {
    protected HouseAdvancedConfiguration specificConfiguration;
    protected ModConfiguration serverConfiguration;
    private ExtendedButton btnHouseStyle;
    private GuiCheckBox btnAddMineShaft;
    private ExtendedButton btnBedColor;
    private ArrayList<HouseAdvancedConfiguration.HouseStyle> availableHouseStyles;

    public GuiHouseAdvanced() {
        super("Advanced House");
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.AdvancedHouse;
    }

    public Component getNarrationMessage() {
        return Component.translatable((String)GuiLangKeys.translateString("item.prefab.item_advanced_house"));
    }

    @Override
    protected void Initialize() {
        this.modifiedInitialXAxis = 215;
        this.modifiedInitialYAxis = 117;
        this.shownImageHeight = 150;
        this.shownImageWidth = 268;
        this.serverConfiguration = PrefabBase.serverConfiguration;
        this.specificConfiguration = ClientModRegistryBase.playerConfig.getClientConfig("Advanced Houses", HouseAdvancedConfiguration.class);
        this.configuration = this.specificConfiguration;
        this.configuration.pos = this.pos;
        this.availableHouseStyles = new ArrayList();
        HashMap<String, Boolean> houseConfigurationSettings = this.serverConfiguration.structureOptions.get("item.prefab.item_house_advanced");
        boolean selectedStyleInListOfAvailable = false;
        for (HouseAdvancedConfiguration.HouseStyle style : HouseAdvancedConfiguration.HouseStyle.values()) {
            if (!houseConfigurationSettings.containsKey(style.getTranslationString()) || !houseConfigurationSettings.get(style.getTranslationString()).booleanValue()) continue;
            this.availableHouseStyles.add(style);
            if (!this.specificConfiguration.houseStyle.getDisplayName().equals(style.getDisplayName())) continue;
            selectedStyleInListOfAvailable = true;
        }
        if (this.availableHouseStyles.size() == 0) {
            this.showNoOptionsScreen();
            return;
        }
        if (!selectedStyleInListOfAvailable) {
            this.specificConfiguration.houseStyle = this.availableHouseStyles.get(0);
        }
        this.selectedStructure = StructureHouseAdvanced.CreateInstance(this.specificConfiguration.houseStyle.getStructureLocation(), StructureHouseAdvanced.class);
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedXYValue.getFirst();
        int grayBoxY = adjustedXYValue.getSecond();
        int yOffset = 25;
        if (this.availableHouseStyles.size() > 1) {
            this.btnHouseStyle = this.createAndAddButton(grayBoxX + 8, grayBoxY + yOffset, 90, 20, this.specificConfiguration.houseStyle.getDisplayName(), false, GuiLangKeys.translateString("prefab.gui.house.style.label"));
            yOffset += 35;
        }
        this.btnBedColor = this.createAndAddDyeButton(grayBoxX + 8, grayBoxY + yOffset, 90, 20, this.specificConfiguration.bedColor, GuiLangKeys.translateString("prefab.gui.structure.bed_color"));
        this.btnAddMineShaft = this.createAndAddCheckBox(grayBoxX + 8, grayBoxY + (yOffset += 94), "prefab.gui.house.buildmineshaft", this.specificConfiguration.addMineshaft, this::buttonClicked);
        this.btnVisualize = this.createAndAddCustomButton(grayBoxX + 24, grayBoxY + 177, 90, 20, "prefab.gui.button.preview");
        this.btnBuild = this.createAndAddCustomButton(grayBoxX + 310, grayBoxY + 177, 90, 20, "prefab.gui.button.build");
        this.btnCancel = this.createAndAddButton(grayBoxX + 154, grayBoxY + 177, 90, 20, "prefab.gui.button.cancel");
    }

    @Override
    protected void preButtonRender(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int imagePanelUpperLeft = x + 136;
        int imagePanelWidth = 285;
        int imagePanelMiddle = imagePanelWidth / 2;
        this.renderBackground(guiGraphics, 0, 0, 0.0f);
        this.drawControlLeftPanel(guiGraphics, x + 2, y + 10, 135, 190);
        this.drawControlRightPanel(guiGraphics, imagePanelUpperLeft, y + 10, imagePanelWidth, 190);
        int middleOfImage = this.shownImageWidth / 2;
        int imageLocation = imagePanelUpperLeft + (imagePanelMiddle - middleOfImage);
        GuiUtils.bindAndDrawScaledTexture(this.specificConfiguration.houseStyle.getHousePicture(), guiGraphics, imageLocation, y + 15, this.shownImageWidth, this.shownImageHeight, this.shownImageWidth, this.shownImageHeight, this.shownImageWidth, this.shownImageHeight);
        this.btnAddMineShaft.visible = this.serverConfiguration.starterHouseOptions.addMineshaft;
    }

    @Override
    protected void postButtonRender(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int yOffSet = 15;
        if (this.availableHouseStyles.size() > 1) {
            this.drawString(guiGraphics, GuiLangKeys.translateString("prefab.gui.house.style.label"), x + 8, y + yOffSet, this.textColor);
            yOffSet += 35;
        }
        this.drawString(guiGraphics, GuiLangKeys.translateString("prefab.gui.structure.bed_color"), x + 8, y + yOffSet, this.textColor);
        if (this.serverConfiguration.strictModeOptions.enabled && !this.getMinecraft().player.isCreative()) {
            this.drawString(guiGraphics, GuiLangKeys.translateString("gui.prefab.strict_building_mode_enabled"), x + 145, y + 167, Color.RED.getRGB());
        }
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        this.specificConfiguration.addMineshaft = this.btnAddMineShaft.visible && this.btnAddMineShaft.isChecked();
        this.configuration.houseFacing = this.getMinecraft().player.getDirection().getOpposite();
        this.performCancelOrBuildOrHouseFacing(button);
        if (button == this.btnHouseStyle) {
            for (int i = 0; i < this.availableHouseStyles.size(); ++i) {
                HouseAdvancedConfiguration.HouseStyle option = this.availableHouseStyles.get(i);
                HouseAdvancedConfiguration.HouseStyle chosenOption = null;
                if (this.specificConfiguration.houseStyle.getDisplayName().equals(option.getDisplayName())) {
                    chosenOption = i == this.availableHouseStyles.size() - 1 ? this.availableHouseStyles.get(0) : this.availableHouseStyles.get(i + 1);
                }
                if (chosenOption == null) continue;
                this.specificConfiguration.houseStyle = chosenOption;
                this.selectedStructure = StructureHouseAdvanced.CreateInstance(this.specificConfiguration.houseStyle.getStructureLocation(), StructureHouseAdvanced.class);
                GuiUtils.setButtonText(this.btnHouseStyle, this.specificConfiguration.houseStyle.getDisplayName());
                break;
            }
        } else if (button == this.btnVisualize) {
            this.performPreview();
        } else if (button == this.btnBedColor) {
            this.specificConfiguration.bedColor = DyeColor.byId((int)(this.specificConfiguration.bedColor.getId() + 1));
            GuiUtils.setButtonText(this.btnBedColor, GuiLangKeys.translateDye(this.specificConfiguration.bedColor));
        }
    }
}

