/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.structures.gui;

import com.prefab.ClientModRegistryBase;
import com.prefab.PrefabBase;
import com.prefab.Tuple;
import com.prefab.blocks.FullDyeColor;
import com.prefab.config.ModConfiguration;
import com.prefab.gui.GuiLangKeys;
import com.prefab.gui.GuiUtils;
import com.prefab.gui.controls.ExtendedButton;
import com.prefab.gui.controls.GuiCheckBox;
import com.prefab.structures.config.HouseConfiguration;
import com.prefab.structures.gui.GuiStructure;
import com.prefab.structures.messages.StructureTagMessage;
import com.prefab.structures.predefined.StructureHouse;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;

public class GuiHouse
extends GuiStructure {
    protected ModConfiguration serverConfiguration;
    private ExtendedButton btnHouseStyle;
    private ExtendedButton btnGlassColor;
    private ExtendedButton btnBedColor;
    private GuiCheckBox btnAddChest;
    private GuiCheckBox btnAddChestContents;
    private GuiCheckBox btnAddMineShaft;
    private boolean allowItemsInChestAndFurnace = true;
    private HouseConfiguration specificConfiguration;
    private ArrayList<HouseConfiguration.HouseStyle> availableHouseStyles;

    public GuiHouse() {
        super("Starter House");
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.StartHouse;
    }

    public Component getNarrationMessage() {
        return Component.translatable((String)GuiLangKeys.translateString("item.prefab.item_start_house"));
    }

    @Override
    protected void Initialize() {
        super.Initialize();
        this.modifiedInitialXAxis = 215;
        this.modifiedInitialYAxis = 117;
        this.shownImageHeight = 150;
        this.shownImageWidth = 268;
        this.allowItemsInChestAndFurnace = !this.getMinecraft().player.isCreative() ? !ClientModRegistryBase.playerConfig.builtStarterHouse : true;
        this.serverConfiguration = PrefabBase.serverConfiguration;
        this.specificConfiguration = ClientModRegistryBase.playerConfig.getClientConfig("Starter House", HouseConfiguration.class);
        this.configuration = this.specificConfiguration;
        this.configuration.pos = this.pos;
        this.availableHouseStyles = new ArrayList();
        HashMap<String, Boolean> houseConfigurationSettings = this.serverConfiguration.structureOptions.get("item.prefab.item_house");
        boolean selectedStyleInListOfAvailable = false;
        for (HouseConfiguration.HouseStyle style : HouseConfiguration.HouseStyle.values()) {
            if (!houseConfigurationSettings.containsKey(style.getTranslationString()) || !houseConfigurationSettings.get(style.getTranslationString()).booleanValue()) continue;
            this.availableHouseStyles.add(style);
            if (!this.specificConfiguration.houseStyle.getDisplayName().equals(style.getDisplayName())) continue;
            selectedStyleInListOfAvailable = true;
        }
        if (this.availableHouseStyles.size() == 0) {
            this.showNoOptionsScreen();
            return;
        }
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedXYValue.getFirst();
        int grayBoxY = adjustedXYValue.getSecond();
        if (!selectedStyleInListOfAvailable) {
            this.specificConfiguration.houseStyle = this.availableHouseStyles.get(0);
        }
        this.selectedStructure = StructureHouse.CreateInstance(this.specificConfiguration.houseStyle.getStructureLocation(), StructureHouse.class);
        int yOffset = 25;
        if (this.availableHouseStyles.size() > 1) {
            this.btnHouseStyle = this.createAndAddButton(grayBoxX + 8, grayBoxY + yOffset, 90, 20, this.specificConfiguration.houseStyle.getDisplayName(), false, GuiLangKeys.translateString("prefab.gui.house.style.label"));
            yOffset += 35;
        }
        this.btnBedColor = this.createAndAddDyeButton(grayBoxX + 8, grayBoxY + yOffset, 90, 20, this.specificConfiguration.bedColor, GuiLangKeys.translateString("prefab.gui.structure.bed_color"));
        this.btnGlassColor = this.createAndAddFullDyeButton(grayBoxX + 8, grayBoxY + (yOffset += 35), 90, 20, this.specificConfiguration.glassColor, GuiLangKeys.translateString("prefab.gui.structure.glass"));
        this.btnAddChest = this.createAndAddCheckBox(grayBoxX + 8, grayBoxY + (yOffset += 35), "prefab.gui.house.addchest", this.specificConfiguration.addChest, this::buttonClicked);
        this.btnAddMineShaft = this.createAndAddCheckBox(grayBoxX + 8, grayBoxY + (yOffset += 17), "prefab.gui.house.buildmineshaft", this.specificConfiguration.addChestContents, this::buttonClicked);
        this.btnAddChestContents = this.createAndAddCheckBox(grayBoxX + 8, grayBoxY + (yOffset += 17), "prefab.gui.house.addchestcontents", this.specificConfiguration.addMineShaft, this::buttonClicked);
        this.btnVisualize = this.createAndAddCustomButton(grayBoxX + 26, grayBoxY + 177, 90, 20, "prefab.gui.button.preview");
        this.btnBuild = this.createAndAddCustomButton(grayBoxX + 313, grayBoxY + 177, 90, 20, "prefab.gui.button.build");
        this.btnCancel = this.createAndAddButton(grayBoxX + 165, grayBoxY + 177, 90, 20, "prefab.gui.button.cancel");
    }

    @Override
    protected void preButtonRender(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int imagePanelUpperLeft = x + 142;
        int imagePanelWidth = 285;
        int imagePanelMiddle = imagePanelWidth / 2;
        this.renderBackground(guiGraphics, 0, 0, 0.0f);
        this.drawControlLeftPanel(guiGraphics, x + 2, y + 10, 141, 190);
        this.drawControlRightPanel(guiGraphics, imagePanelUpperLeft, y + 10, imagePanelWidth, 190);
        int middleOfImage = this.shownImageWidth / 2;
        int imageLocation = imagePanelUpperLeft + (imagePanelMiddle - middleOfImage);
        GuiUtils.bindAndDrawScaledTexture(this.specificConfiguration.houseStyle.getHousePicture(), guiGraphics, imageLocation, y + 15, this.shownImageWidth, this.shownImageHeight, this.shownImageWidth, this.shownImageHeight, this.shownImageWidth, this.shownImageHeight);
        this.btnAddChest.visible = this.serverConfiguration.starterHouseOptions.addChests;
        this.btnAddChestContents.visible = this.allowItemsInChestAndFurnace && this.serverConfiguration.starterHouseOptions.addChestContents;
        this.btnAddMineShaft.visible = this.serverConfiguration.starterHouseOptions.addMineshaft;
    }

    @Override
    protected void postButtonRender(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int yOffSet = 15;
        if (this.availableHouseStyles.size() > 1) {
            this.drawString(guiGraphics, GuiLangKeys.translateString("prefab.gui.house.style.label"), x + 8, y + yOffSet, this.textColor);
            yOffSet += 35;
        }
        this.drawString(guiGraphics, GuiLangKeys.translateString("prefab.gui.structure.bed_color"), x + 8, y + yOffSet, this.textColor);
        this.drawString(guiGraphics, GuiLangKeys.translateString("prefab.gui.structure.glass"), x + 8, y + (yOffSet += 35), this.textColor);
        if (this.serverConfiguration.strictModeOptions.enabled && !this.getMinecraft().player.isCreative()) {
            this.drawString(guiGraphics, GuiLangKeys.translateString("gui.prefab.strict_building_mode_enabled"), x + 145, y + 167, Color.RED.getRGB());
        }
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        this.specificConfiguration.addBed = this.serverConfiguration.starterHouseOptions.addBed;
        this.specificConfiguration.addChest = this.serverConfiguration.starterHouseOptions.addChests && this.btnAddChest.isChecked();
        this.specificConfiguration.addChestContents = this.allowItemsInChestAndFurnace && this.serverConfiguration.starterHouseOptions.addChestContents && this.btnAddChestContents.isChecked();
        this.specificConfiguration.addCraftingTable = this.serverConfiguration.starterHouseOptions.addCraftingTable;
        this.specificConfiguration.addFurnace = this.serverConfiguration.starterHouseOptions.addFurnace;
        this.specificConfiguration.addMineShaft = this.serverConfiguration.starterHouseOptions.addMineshaft && this.btnAddMineShaft.isChecked();
        this.specificConfiguration.addTorches = this.serverConfiguration.chestOptions.addTorches;
        this.configuration.houseFacing = this.getMinecraft().player.getDirection().getOpposite();
        this.performCancelOrBuildOrHouseFacing(button);
        if (button == this.btnHouseStyle) {
            for (int i = 0; i < this.availableHouseStyles.size(); ++i) {
                HouseConfiguration.HouseStyle option = this.availableHouseStyles.get(i);
                HouseConfiguration.HouseStyle chosenOption = null;
                if (this.specificConfiguration.houseStyle.getDisplayName().equals(option.getDisplayName())) {
                    chosenOption = i == this.availableHouseStyles.size() - 1 ? this.availableHouseStyles.get(0) : this.availableHouseStyles.get(i + 1);
                }
                if (chosenOption == null) continue;
                this.specificConfiguration.houseStyle = chosenOption;
                this.selectedStructure = StructureHouse.CreateInstance(this.specificConfiguration.houseStyle.getStructureLocation(), StructureHouse.class);
                GuiUtils.setButtonText(this.btnHouseStyle, this.specificConfiguration.houseStyle.getDisplayName());
                break;
            }
        } else if (button == this.btnGlassColor) {
            this.specificConfiguration.glassColor = FullDyeColor.byId(this.specificConfiguration.glassColor.getId() + 1);
            GuiUtils.setButtonText(this.btnGlassColor, GuiLangKeys.translateFullDye(this.specificConfiguration.glassColor));
        } else if (button == this.btnBedColor) {
            this.specificConfiguration.bedColor = DyeColor.byId((int)(this.specificConfiguration.bedColor.getId() + 1));
            GuiUtils.setButtonText(this.btnBedColor, GuiLangKeys.translateDye(this.specificConfiguration.bedColor));
        } else if (button == this.btnVisualize) {
            this.performPreview();
        }
    }
}

