/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.structures.gui;

import com.prefab.ClientModRegistryBase;
import com.prefab.PrefabBase;
import com.prefab.Tuple;
import com.prefab.config.ModConfiguration;
import com.prefab.gui.GuiLangKeys;
import com.prefab.structures.config.BulldozerConfiguration;
import com.prefab.structures.gui.GuiStructure;
import com.prefab.structures.messages.StructureTagMessage;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.network.chat.Component;

public class GuiBulldozer
extends GuiStructure {
    protected BulldozerConfiguration specificConfiguration;
    protected ModConfiguration serverConfiguration;

    public GuiBulldozer() {
        super("Bulldozer");
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.Bulldozer;
    }

    public Component getNarrationMessage() {
        return Component.translatable((String)GuiLangKeys.translateString("item.prefab.item_bulldozer"));
    }

    @Override
    protected void Initialize() {
        this.modifiedInitialXAxis = 125;
        this.modifiedInitialYAxis = 83;
        this.imagePanelWidth = 256;
        this.imagePanelHeight = 256;
        this.serverConfiguration = PrefabBase.serverConfiguration;
        this.specificConfiguration = ClientModRegistryBase.playerConfig.getClientConfig("Bulldozer", BulldozerConfiguration.class);
        this.configuration = this.specificConfiguration;
        this.specificConfiguration.pos = this.pos;
        Tuple<Integer, Integer> adjustedCorner = this.getAdjustedXYValue();
        int grayBoxX = adjustedCorner.getFirst();
        int grayBoxY = adjustedCorner.getSecond();
        this.btnBuild = this.createAndAddButton(grayBoxX + 10, grayBoxY + 136, 90, 20, "prefab.gui.button.build");
        this.btnCancel = this.createAndAddButton(grayBoxX + 147, grayBoxY + 136, 90, 20, "prefab.gui.button.cancel");
    }

    @Override
    protected void postButtonRender(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        String strToDraw = GuiLangKeys.translateString("prefab.gui.bulldozer_desc") + "\n \n" + GuiLangKeys.translateString("prefab.gui.cleared_area");
        this.drawSplitString(guiGraphics, strToDraw, x + 10, y + 10, 230, this.textColor);
        if (this.serverConfiguration.strictModeOptions.enabled && !this.getMinecraft().player.isCreative()) {
            this.drawSplitString(guiGraphics, GuiLangKeys.translateString("gui.prefab.strict_building_mode_enabled"), x + 10, y + 110, 230, Color.RED.getRGB());
        }
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        this.configuration.houseFacing = this.getMinecraft().player.getDirection().getOpposite();
        this.performCancelOrBuildOrHouseFacing(button);
    }
}

