/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.structures.config.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;

public class BaseOption {
    private static final HashMap<String, ArrayList<BaseOption>> classOptions = new HashMap();
    private final String translationString;
    private final String assetLocation;
    private final ResourceLocation pictureLocation;
    private final boolean hasBedColor;
    private final boolean hasGlassColor;

    protected BaseOption(String translationString, String assetLocation, String pictureLocation, boolean hasBedColor, boolean hasGlassColor) {
        this.translationString = translationString;
        this.assetLocation = assetLocation;
        this.pictureLocation = ResourceLocation.tryBuild((String)"prefab", (String)pictureLocation);
        this.hasBedColor = hasBedColor;
        this.hasGlassColor = hasGlassColor;
        BaseOption.addOption(this);
    }

    public static BaseOption getOptionByHash(int hashCode) {
        for (Map.Entry<String, ArrayList<BaseOption>> mapping : classOptions.entrySet()) {
            for (BaseOption storedOption : mapping.getValue()) {
                if (storedOption.hashCode() != hashCode) continue;
                return storedOption;
            }
        }
        return null;
    }

    public static void addOption(BaseOption option) {
        ArrayList<Object> options;
        String className = option.getClass().getName();
        if (!classOptions.containsKey(className)) {
            options = new ArrayList();
            classOptions.put(className, options);
        } else {
            options = classOptions.get(className);
        }
        options.add(option);
    }

    public String getTranslationString() {
        return this.translationString;
    }

    public String getAssetLocation() {
        return this.assetLocation;
    }

    public ResourceLocation getPictureLocation() {
        return this.pictureLocation;
    }

    public boolean getHasBedColor() {
        return this.hasBedColor;
    }

    public boolean getHasGlassColor() {
        return this.hasGlassColor;
    }

    public ArrayList<BaseOption> getSpecificOptions() {
        String className = this.getClass().getName();
        for (Map.Entry<String, ArrayList<BaseOption>> mapping : classOptions.entrySet()) {
            if (!mapping.getKey().equals(className)) continue;
            return mapping.getValue();
        }
        return null;
    }

    public ArrayList<BaseOption> filterOptions(ArrayList<BaseOption> originalOptions) {
        return originalOptions;
    }

    public int hashCode() {
        return Objects.hash(this.translationString, this.assetLocation);
    }
}

