/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.structures.config;

import com.prefab.structures.items.StructureItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class StructureConfiguration {
    public static String houseFacingName = "House Facing";
    private static String hitXTag = "hitX";
    private static String hitYTag = "hitY";
    private static String hitZTag = "hitZ";
    private static String houseFacingTag = "wareHouseFacing";
    public Direction houseFacing;
    public BlockPos pos;

    public StructureConfiguration() {
        this.Initialize();
    }

    public void Initialize() {
        this.houseFacing = Direction.NORTH;
    }

    public CompoundTag WriteToCompoundTag() {
        CompoundTag tag = new CompoundTag();
        if (this.pos != null) {
            tag.putInt(hitXTag, this.pos.getX());
            tag.putInt(hitYTag, this.pos.getY());
            tag.putInt(hitZTag, this.pos.getZ());
        }
        tag.putString(houseFacingTag, this.houseFacing.getSerializedName());
        tag = this.CustomWriteToCompoundTag(tag);
        return tag;
    }

    public StructureConfiguration ReadFromCompoundTag(CompoundTag messageTag) {
        return null;
    }

    public StructureConfiguration ReadFromCompoundTag(CompoundTag messageTag, StructureConfiguration config) {
        if (messageTag != null) {
            if (messageTag.contains(hitXTag)) {
                config.pos = new BlockPos(messageTag.getInt(hitXTag), messageTag.getInt(hitYTag), messageTag.getInt(hitZTag));
            }
            if (messageTag.contains(houseFacingTag)) {
                config.houseFacing = Direction.byName((String)messageTag.getString(houseFacingTag));
            }
            this.CustomReadFromNBTTag(messageTag, config);
        }
        return config;
    }

    public void BuildStructure(Player player, ServerLevel world) {
        BlockPos hitBlockPos = this.pos;
        this.ConfigurationSpecificBuildStructure(player, world, hitBlockPos);
    }

    protected void ConfigurationSpecificBuildStructure(Player player, ServerLevel world, BlockPos hitBlockPos) {
    }

    protected CompoundTag CustomWriteToCompoundTag(CompoundTag tag) {
        return tag;
    }

    protected void CustomReadFromNBTTag(CompoundTag messageTag, StructureConfiguration config) {
    }

    protected void RemoveStructureItemFromPlayer(Player player, StructureItem item) {
        ItemStack stack = player.getMainHandItem();
        EquipmentSlot slot = EquipmentSlot.MAINHAND;
        if (stack.getItem() != item) {
            stack = player.getOffhandItem();
            slot = EquipmentSlot.OFFHAND;
        }
        stack.shrink(1);
        if (stack.isEmpty()) {
            player.setItemSlot(slot, ItemStack.EMPTY);
        }
        player.containerMenu.broadcastChanges();
    }

    protected void DamageHeldItem(Player player, Item item) {
        ItemStack stack = player.getMainHandItem().getItem() == item ? player.getMainHandItem() : player.getOffhandItem();
        InteractionHand hand = player.getMainHandItem().getItem() == item ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        ItemStack copy = stack.copy();
        stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        if (stack.isEmpty()) {
            EquipmentSlot slotType = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            player.setItemSlot(slotType, ItemStack.EMPTY);
        }
        player.containerMenu.broadcastChanges();
    }

    private boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.getItem() == stack2.getItem() && ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2);
    }

    public int getSlotFor(Inventory playerInventory, ItemStack stack) {
        for (int i = 0; i < playerInventory.items.size(); ++i) {
            if (((ItemStack)playerInventory.items.get(i)).isEmpty() || !this.stackEqualExact(stack, (ItemStack)playerInventory.items.get(i))) continue;
            return i;
        }
        return -1;
    }
}

