/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.structures.config;

import com.prefab.ModRegistryBase;
import com.prefab.structures.base.EnumStructureMaterial;
import com.prefab.structures.config.StructureConfiguration;
import com.prefab.structures.predefined.StructureInstantBridge;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;

public class InstantBridgeConfiguration
extends StructureConfiguration {
    public int bridgeLength;
    public EnumStructureMaterial bridgeMaterial;
    public boolean includeRoof;
    public int interiorHeight;

    @Override
    public void Initialize() {
        super.Initialize();
        this.bridgeLength = 25;
        this.bridgeMaterial = EnumStructureMaterial.Cobblestone;
        this.interiorHeight = 3;
        this.includeRoof = true;
    }

    @Override
    public InstantBridgeConfiguration ReadFromCompoundTag(CompoundTag messageTag) {
        InstantBridgeConfiguration config = new InstantBridgeConfiguration();
        return (InstantBridgeConfiguration)super.ReadFromCompoundTag(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(Player player, ServerLevel world, BlockPos hitBlockPos) {
        StructureInstantBridge structure = StructureInstantBridge.CreateInstance();
        if (structure.BuildStructure(this, world, hitBlockPos, player)) {
            this.DamageHeldItem(player, ModRegistryBase.InstantBridge);
        }
    }

    @Override
    protected CompoundTag CustomWriteToCompoundTag(CompoundTag tag) {
        tag.putInt("bridgeLength", this.bridgeLength);
        tag.putInt("bridgeMaterial", this.bridgeMaterial.getNumber());
        tag.putBoolean("includeRoof", this.includeRoof);
        tag.putInt("interiorHeight", this.interiorHeight);
        return tag;
    }

    @Override
    protected void CustomReadFromNBTTag(CompoundTag messageTag, StructureConfiguration config) {
        if (messageTag.contains("bridgeLength")) {
            ((InstantBridgeConfiguration)config).bridgeLength = messageTag.getInt("bridgeLength");
        }
        if (messageTag.contains("bridgeMaterial")) {
            ((InstantBridgeConfiguration)config).bridgeMaterial = EnumStructureMaterial.getMaterialByNumber(messageTag.getInt("bridgeMaterial"));
        }
        if (messageTag.contains("includeRoof")) {
            ((InstantBridgeConfiguration)config).includeRoof = messageTag.getBoolean("includeRoof");
        }
        if (messageTag.contains("interiorHeight")) {
            ((InstantBridgeConfiguration)config).interiorHeight = messageTag.getInt("interiorHeight");
        }
    }
}

