/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.structures.config;

import com.prefab.ModRegistryBase;
import com.prefab.gui.GuiLangKeys;
import com.prefab.structures.config.StructureConfiguration;
import com.prefab.structures.predefined.StructureHouseImproved;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;

public class HouseImprovedConfiguration
extends StructureConfiguration {
    public static String tagKey = "houseConfig";
    private static String houseStyleTag = "houseStyle";
    private static String addChestTag = "addChests";
    private static String addChestContentsTag = "addChestContents";
    private static String addMineshaftTag = "addMineshaft";
    private static String bedColorTag = "bedColor";
    public HouseStyle houseStyle = HouseStyle.SPRUCE_HOME;
    public boolean addChests = true;
    public boolean addChestContents = true;
    public boolean addMineshaft = true;
    public DyeColor bedColor = DyeColor.RED;

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseStyle = HouseStyle.SPRUCE_HOME;
        this.bedColor = DyeColor.RED;
    }

    @Override
    protected CompoundTag CustomWriteToCompoundTag(CompoundTag tag) {
        tag.putInt(houseStyleTag, this.houseStyle.value);
        tag.putBoolean(addChestTag, this.addChests);
        tag.putBoolean(addChestContentsTag, this.addChestContents);
        tag.putBoolean(addMineshaftTag, this.addMineshaft);
        tag.putInt(bedColorTag, this.bedColor.getId());
        return tag;
    }

    @Override
    protected void CustomReadFromNBTTag(CompoundTag messageTag, StructureConfiguration config) {
        HouseImprovedConfiguration houseConfiguration = (HouseImprovedConfiguration)config;
        if (messageTag.contains(houseStyleTag)) {
            houseConfiguration.houseStyle = HouseStyle.ValueOf(messageTag.getInt(houseStyleTag));
        }
        if (messageTag.contains(addChestTag)) {
            houseConfiguration.addChests = messageTag.getBoolean(addChestTag);
        }
        if (messageTag.contains(addChestContentsTag)) {
            houseConfiguration.addChestContents = messageTag.getBoolean(addChestContentsTag);
        }
        if (messageTag.contains(addMineshaftTag)) {
            houseConfiguration.addMineshaft = messageTag.getBoolean(addMineshaftTag);
        }
        if (messageTag.contains(bedColorTag)) {
            houseConfiguration.bedColor = DyeColor.byId((int)messageTag.getInt(bedColorTag));
        }
    }

    @Override
    public HouseImprovedConfiguration ReadFromCompoundTag(CompoundTag messageTag) {
        HouseImprovedConfiguration config = new HouseImprovedConfiguration();
        return (HouseImprovedConfiguration)super.ReadFromCompoundTag(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(Player player, ServerLevel world, BlockPos hitBlockPos) {
        StructureHouseImproved structure = (StructureHouseImproved)StructureHouseImproved.CreateInstance(this.houseStyle.getStructureLocation(), StructureHouseImproved.class);
        if (structure.BuildStructure(this, world, hitBlockPos, player)) {
            this.RemoveStructureItemFromPlayer(player, ModRegistryBase.HouseImproved);
        }
    }

    public static enum HouseStyle {
        SPRUCE_HOME(0, "prefab.gui.house.improved.spruce", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_improved_spruce.png"), "assets/prefab/structures/house_improved_spruce.gz"),
        ACACIA_HOME(1, "prefab.gui.house.improved.acacia", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_improved_acacia.png"), "assets/prefab/structures/house_improved_acacia.gz"),
        EARTHEN_HOME(2, "prefab.gui.house.improved.earthen", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_improved_earthen.png"), "assets/prefab/structures/house_improved_earthen.gz"),
        JUNGLE_TREE_HOME(3, "prefab.gui.house.improved.jungle", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_improved_jungle.png"), "assets/prefab/structures/house_improved_jungle.gz"),
        NETHER_HOME(4, "prefab.gui.house.improved.nether", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_improved_nether.png"), "assets/prefab/structures/house_improved_nether.gz"),
        MOUNTAIN_HOME(5, "prefab.gui.house.improved.mountain", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_improved_mountain.png"), "assets/prefab/structures/house_improved_mountain.gz"),
        ACACIA_HOME2(6, "prefab.gui.house.improved.acacia_2", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_improved_acacia_2.png"), "assets/prefab/structures/house_improved_acacia_2.gz"),
        MODERN_HOME(7, "prefab.gui.item_modern_house", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_improved_modern.png"), "assets/prefab/structures/house_improved_modern.gz"),
        CRIMSON_HOME(8, "prefab.gui.house.improved.crimson_house", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_improved_crimson.png"), "assets/prefab/structures/house_improved_crimson.gz"),
        TOWER_HOME(9, "prefab.gui.house.improved.tower_house", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_improved_tower.png"), "assets/prefab/structures/house_improved_tower.gz"),
        HOBBIT_HOME(10, "prefab.gui.house.improved.hobbit_house", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_improved_hobbit.png"), "assets/prefab/structures/house_improved_hobbit.gz"),
        COTTAGE_HOME(11, "prefab.gui.house.improved.cottage_house", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_improved_cottage.png"), "assets/prefab/structures/house_improved_cottage.gz");

        private final int value;
        private final String displayName;
        private final ResourceLocation housePicture;
        private final String structureLocation;

        private HouseStyle(int newValue, String displayName, ResourceLocation housePicture, String structureLocation) {
            this.value = newValue;
            this.displayName = displayName;
            this.housePicture = housePicture;
            this.structureLocation = structureLocation;
        }

        public static HouseStyle ValueOf(int value) {
            for (HouseStyle currentValue : HouseStyle.values()) {
                if (currentValue.value != value) continue;
                return currentValue;
            }
            return SPRUCE_HOME;
        }

        public int getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return GuiLangKeys.translateString(this.displayName);
        }

        public String getTranslationString() {
            return this.displayName;
        }

        public ResourceLocation getHousePicture() {
            return this.housePicture;
        }

        public String getStructureLocation() {
            return this.structureLocation;
        }
    }
}

