/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.structures.config;

import com.prefab.ModRegistryBase;
import com.prefab.PrefabBase;
import com.prefab.blocks.FullDyeColor;
import com.prefab.config.EntityPlayerConfiguration;
import com.prefab.gui.GuiLangKeys;
import com.prefab.network.ServerToClientTypes;
import com.prefab.network.message.TagMessage;
import com.prefab.structures.base.BuildBlock;
import com.prefab.structures.config.StructureConfiguration;
import com.prefab.structures.predefined.StructureHouse;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;

public class HouseConfiguration
extends StructureConfiguration {
    private static final String addTorchesTag = "addTorches";
    private static final String addBedTag = "addBed";
    private static final String addCraftingTableTag = "addCraftingTable";
    private static final String addFurnaceTag = "addFurnace";
    private static final String addChestTag = "addChest";
    private static final String addChestContentsTag = "addChestContents";
    private static final String addMineShaftTag = "addMineShaft";
    private static final String hitXTag = "hitX";
    private static final String hitYTag = "hitY";
    private static final String hitZTag = "hitZ";
    private static final String houseFacingTag = "houseFacing";
    private static final String houseStyleTag = "houseStyle";
    private static final String glassColorTag = "glassColor";
    private static final String bedColorTag = "bedColor";
    public boolean addTorches;
    public boolean addBed;
    public boolean addCraftingTable;
    public boolean addFurnace;
    public boolean addChest;
    public boolean addChestContents;
    public boolean addMineShaft;
    public HouseStyle houseStyle;
    public FullDyeColor glassColor;
    public DyeColor bedColor;

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseStyle = HouseStyle.BASIC;
        this.glassColor = FullDyeColor.LIGHT_GRAY;
        this.bedColor = DyeColor.RED;
        this.addTorches = true;
        this.addBed = true;
        this.addCraftingTable = true;
        this.addFurnace = true;
        this.addChest = true;
        this.addChestContents = true;
        this.addMineShaft = true;
    }

    @Override
    public CompoundTag WriteToCompoundTag() {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean(addTorchesTag, this.addTorches);
        tag.putBoolean(addBedTag, this.addBed);
        tag.putBoolean(addCraftingTableTag, this.addCraftingTable);
        tag.putBoolean(addFurnaceTag, this.addFurnace);
        tag.putBoolean(addChestTag, this.addChest);
        tag.putBoolean(addChestContentsTag, this.addChestContents);
        tag.putBoolean(addMineShaftTag, this.addMineShaft);
        tag.putInt(hitXTag, this.pos.getX());
        tag.putInt(hitYTag, this.pos.getY());
        tag.putInt(hitZTag, this.pos.getZ());
        tag.putString(houseFacingTag, this.houseFacing.getSerializedName());
        tag.putInt(houseStyleTag, this.houseStyle.value);
        tag.putInt(glassColorTag, this.glassColor.getId());
        tag.putInt(bedColorTag, this.bedColor.getId());
        return tag;
    }

    @Override
    public HouseConfiguration ReadFromCompoundTag(CompoundTag tag) {
        HouseConfiguration config = null;
        if (tag != null) {
            config = new HouseConfiguration();
            if (tag.contains(addTorchesTag)) {
                config.addTorches = tag.getBoolean(addTorchesTag);
            }
            if (tag.contains(addBedTag)) {
                config.addBed = tag.getBoolean(addBedTag);
            }
            if (tag.contains(addCraftingTableTag)) {
                config.addCraftingTable = tag.getBoolean(addCraftingTableTag);
            }
            if (tag.contains(addFurnaceTag)) {
                config.addFurnace = tag.getBoolean(addFurnaceTag);
            }
            if (tag.contains(addChestTag)) {
                config.addChest = tag.getBoolean(addChestTag);
            }
            if (tag.contains(addChestContentsTag)) {
                config.addChestContents = tag.getBoolean(addChestContentsTag);
            }
            if (tag.contains(addMineShaftTag)) {
                config.addMineShaft = tag.getBoolean(addMineShaftTag);
            }
            if (tag.contains(hitXTag)) {
                config.pos = new BlockPos(tag.getInt(hitXTag), tag.getInt(hitYTag), tag.getInt(hitZTag));
            }
            if (tag.contains(houseFacingTag)) {
                config.houseFacing = BuildBlock.getDirectionByName(tag.getString(houseFacingTag));
            }
            if (tag.contains(houseStyleTag)) {
                config.houseStyle = HouseStyle.ValueOf(tag.getInt(houseStyleTag));
            }
            if (tag.contains(glassColorTag)) {
                config.glassColor = FullDyeColor.byId(tag.getInt(glassColorTag));
            }
            if (tag.contains(bedColorTag)) {
                config.bedColor = DyeColor.byId((int)tag.getInt(bedColorTag));
            }
        }
        return config;
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(Player player, ServerLevel world, BlockPos hitBlockPos) {
        StructureHouse structure = (StructureHouse)StructureHouse.CreateInstance(this.houseStyle.getStructureLocation(), StructureHouse.class);
        boolean houseBuilt = structure.BuildStructure(this, world, hitBlockPos, player);
        if (houseBuilt) {
            EntityPlayerConfiguration playerConfig = EntityPlayerConfiguration.loadFromEntity(player);
            playerConfig.builtStarterHouse = true;
            this.RemoveStructureItemFromPlayer(player, ModRegistryBase.House);
            TagMessage tagMessage = new TagMessage();
            tagMessage.setMessageTag(playerConfig.createPlayerTag());
            PrefabBase.networkWrapper.sendToClient(ServerToClientTypes.PLAYER_CONFIG_SYNC, (ServerPlayer)player, tagMessage);
        }
    }

    public static enum HouseStyle {
        BASIC(0, "prefab.gui.house.basic.display", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_basic.png"), "assets/prefab/structures/house_basic.gz"),
        RANCH(1, "prefab.gui.house.ranch.display", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_ranch.png"), "assets/prefab/structures/house_ranch.gz"),
        LOFT(2, "prefab.gui.house.loft.display", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_loft.png"), "assets/prefab/structures/house_loft.gz"),
        HOBBIT(3, "prefab.gui.house.hobbit.display", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_hobbit.png"), "assets/prefab/structures/house_hobbit.gz"),
        DESERT(4, "prefab.gui.house.desert.display", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_desert.png"), "assets/prefab/structures/house_desert.gz"),
        SNOWY(5, "prefab.gui.house.snowy.display", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_snowy.png"), "assets/prefab/structures/house_snow.gz"),
        DESERT2(6, "prefab.gui.house.desert.display2", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_desert_2.png"), "assets/prefab/structures/house_desert_2.gz"),
        SUBAQUATIC(7, "prefab.gui.house.subaquatic.display", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_subaquatic.png"), "assets/prefab/structures/house_sub_aqua.gz"),
        MODERN(8, "prefab.gui.house.modern.display", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_modern.png"), "assets/prefab/structures/house_modern.gz"),
        CAMPSITE(9, "prefab.gui.house.camping.display", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_campsite.png"), "assets/prefab/structures/house_campsite.gz"),
        IZBA(10, "prefab.gui.house.izba.display", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_izba.png"), "assets/prefab/structures/house_izba.gz"),
        TOWER(11, "prefab.gui.house.tower.display", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_tower.png"), "assets/prefab/structures/house_tower.gz"),
        CABIN(12, "prefab.gui.house.cabin.display", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_cabin.png"), "assets/prefab/structures/house_cabin.gz"),
        TREE(13, "prefab.gui.house.tree.display", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_tree.png"), "assets/prefab/structures/house_tree.gz"),
        MUSHROOM(14, "prefab.gui.house.mushroom.display", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_mushroom.png"), "assets/prefab/structures/house_mushroom.gz");

        private final int value;
        private final String displayName;
        private final ResourceLocation housePicture;
        private final String structureLocation;

        private HouseStyle(int newValue, String displayName, ResourceLocation housePicture, String structureLocation) {
            this.value = newValue;
            this.displayName = displayName;
            this.housePicture = housePicture;
            this.structureLocation = structureLocation;
        }

        public static HouseStyle ValueOf(int value) {
            HouseStyle returnValue = BASIC;
            for (HouseStyle current : HouseStyle.values()) {
                if (current.value != value) continue;
                returnValue = current;
                break;
            }
            return returnValue;
        }

        public int getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return GuiLangKeys.translateString(this.displayName);
        }

        public String getTranslationString() {
            return this.displayName;
        }

        public ResourceLocation getHousePicture() {
            return this.housePicture;
        }

        public String getStructureLocation() {
            return this.structureLocation;
        }
    }
}

