/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.structures.config;

import com.prefab.ModRegistryBase;
import com.prefab.gui.GuiLangKeys;
import com.prefab.structures.config.StructureConfiguration;
import com.prefab.structures.predefined.StructureHouseAdvanced;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;

public class HouseAdvancedConfiguration
extends StructureConfiguration {
    private static final String houseStyleTag = "houseStyle";
    private static final String addMineshaftTag = "addMineshaft";
    private static final String bedColorTag = "bedColor";
    public HouseStyle houseStyle = HouseStyle.MANOR;
    public boolean addMineshaft = true;
    public DyeColor bedColor = DyeColor.RED;

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseStyle = HouseStyle.MANOR;
        this.bedColor = DyeColor.RED;
    }

    @Override
    protected CompoundTag CustomWriteToCompoundTag(CompoundTag tag) {
        tag.putInt(houseStyleTag, this.houseStyle.value);
        tag.putBoolean(addMineshaftTag, this.addMineshaft);
        tag.putInt(bedColorTag, this.bedColor.getId());
        return tag;
    }

    @Override
    protected void CustomReadFromNBTTag(CompoundTag messageTag, StructureConfiguration config) {
        HouseAdvancedConfiguration houseConfiguration = (HouseAdvancedConfiguration)config;
        if (messageTag.contains(houseStyleTag)) {
            houseConfiguration.houseStyle = HouseStyle.ValueOf(messageTag.getInt(houseStyleTag));
        }
        if (messageTag.contains(addMineshaftTag)) {
            houseConfiguration.addMineshaft = messageTag.getBoolean(addMineshaftTag);
        }
        if (messageTag.contains(bedColorTag)) {
            houseConfiguration.bedColor = DyeColor.byId((int)messageTag.getInt(bedColorTag));
        }
    }

    @Override
    public HouseAdvancedConfiguration ReadFromCompoundTag(CompoundTag messageTag) {
        HouseAdvancedConfiguration config = new HouseAdvancedConfiguration();
        return (HouseAdvancedConfiguration)super.ReadFromCompoundTag(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(Player player, ServerLevel world, BlockPos hitBlockPos) {
        StructureHouseAdvanced structure = (StructureHouseAdvanced)StructureHouseAdvanced.CreateInstance(this.houseStyle.getStructureLocation(), StructureHouseAdvanced.class);
        if (structure.BuildStructure(this, world, hitBlockPos, player)) {
            this.RemoveStructureItemFromPlayer(player, ModRegistryBase.HouseAdvanced);
        }
    }

    public static enum HouseStyle {
        MANOR(0, "prefab.gui.house.advanced.manor", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_advanced_manor.png"), "assets/prefab/structures/house_advanced_manor.gz"),
        WORKSHOP(1, "prefab.gui.house.advanced.workshop", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_advanced_workshop.png"), "assets/prefab/structures/house_advanced_workshop.gz"),
        ESTATE(2, "prefab.gui.house.advanced.estate", ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/house_advanced_estate.png"), "assets/prefab/structures/house_advanced_estate.gz");

        private final int value;
        private final String displayName;
        private final ResourceLocation housePicture;
        private final String structureLocation;

        private HouseStyle(int newValue, String displayName, ResourceLocation housePicture, String structureLocation) {
            this.value = newValue;
            this.displayName = displayName;
            this.housePicture = housePicture;
            this.structureLocation = structureLocation;
        }

        public static HouseStyle ValueOf(int value) {
            for (HouseStyle currentValue : HouseStyle.values()) {
                if (currentValue.value != value) continue;
                return currentValue;
            }
            return MANOR;
        }

        public int getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return GuiLangKeys.translateString(this.displayName);
        }

        public String getTranslationString() {
            return this.displayName;
        }

        public ResourceLocation getHousePicture() {
            return this.housePicture;
        }

        public String getStructureLocation() {
            return this.structureLocation;
        }
    }
}

