/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.structures.config;

import com.prefab.ModRegistryBase;
import com.prefab.structures.config.StructureConfiguration;
import com.prefab.structures.predefined.StructureBulldozer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class BulldozerConfiguration
extends StructureConfiguration {
    public boolean creativeMode = false;

    @Override
    public BulldozerConfiguration ReadFromCompoundTag(CompoundTag messageTag) {
        BulldozerConfiguration config = new BulldozerConfiguration();
        return (BulldozerConfiguration)super.ReadFromCompoundTag(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(Player player, ServerLevel world, BlockPos hitBlockPos) {
        StructureBulldozer structure = new StructureBulldozer();
        if (player.isCreative()) {
            this.creativeMode = true;
        }
        if (structure.BuildStructure(this, world, hitBlockPos, player)) {
            ItemStack stack = player.getItemInHand(InteractionHand.OFF_HAND);
            InteractionHand hand = InteractionHand.OFF_HAND;
            if (stack.getItem() == ModRegistryBase.CreativeBulldozer) {
                this.creativeMode = true;
            }
            if (stack.getItem() != ModRegistryBase.Bulldozer) {
                stack = player.getItemInHand(InteractionHand.MAIN_HAND);
                hand = InteractionHand.MAIN_HAND;
            }
            if (stack.getItem() == ModRegistryBase.Bulldozer) {
                stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                player.containerMenu.broadcastChanges();
            }
        }
    }
}

