/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.structures.base;

import com.prefab.PrefabBase;
import com.prefab.Tuple;
import com.prefab.structures.base.BuildBlock;
import com.prefab.structures.base.BuildEntity;
import com.prefab.structures.base.BuildingMethods;
import com.prefab.structures.base.Structure;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;

public class StructureGenerator {
    public static ArrayList<Tuple<Structure, BuildEntity>> entitiesToGenerate = new ArrayList();
    public static int ticksSinceLastEntitiesGenerated = 0;

    public static void CheckForStructureToBuildAndBuildIt() {
        ArrayList<Player> playersToRemove = new ArrayList<Player>();
        ++ticksSinceLastEntitiesGenerated;
        if (!entitiesToGenerate.isEmpty() && ++ticksSinceLastEntitiesGenerated > 40) {
            StructureGenerator.processStructureEntities();
            ticksSinceLastEntitiesGenerated = 0;
        }
        if (!PrefabBase.structuresToBuild.isEmpty()) {
            for (Map.Entry entry : PrefabBase.structuresToBuild.entrySet()) {
                ArrayList<Structure> structuresToRemove = new ArrayList<Structure>();
                for (Structure structure : (ArrayList)entry.getValue()) {
                    if (!structure.entitiesRemoved) {
                        for (BlockPos clearedPos : structure.clearedBlockPos) {
                            AABB axisPos = Shapes.block().bounds().move(clearedPos);
                            List list = structure.world.getEntities(null, axisPos);
                            if (list.isEmpty()) continue;
                            for (Entity entity : list) {
                                if (entity instanceof LivingEntity) continue;
                                if (entity instanceof HangingEntity) {
                                    structure.BeforeHangingEntityRemoved((HangingEntity)entity);
                                }
                                entity.remove(Entity.RemovalReason.DISCARDED);
                            }
                        }
                        structure.entitiesRemoved = true;
                    }
                    if (!structure.airBlocks.isEmpty()) {
                        structure.hasAirBlocks = true;
                    }
                    for (int i = 0; i < 100; ++i) {
                        i = StructureGenerator.setBlock(i, structure, structuresToRemove);
                    }
                    StructureGenerator.removeWaterLogging(structure);
                }
                StructureGenerator.removeStructuresFromList(structuresToRemove, entry);
                if (!((ArrayList)entry.getValue()).isEmpty()) continue;
                playersToRemove.add((Player)entry.getKey());
            }
        }
        for (Player player : playersToRemove) {
            PrefabBase.structuresToBuild.remove(player);
        }
    }

    private static int setBlock(int i, Structure structure, ArrayList<Structure> structuresToRemove) {
        if (!structure.clearedBlockPos.isEmpty() && !structure.hasAirBlocks) {
            BlockPos currentPos = structure.clearedBlockPos.getFirst();
            structure.clearedBlockPos.removeFirst();
            BlockState clearBlockState = structure.world.getBlockState(currentPos);
            if (clearBlockState.getBlock() != Blocks.AIR) {
                structure.BeforeClearSpaceBlockReplaced(currentPos);
                block0: for (Direction adjacentBlock : Direction.values()) {
                    BlockPos tempPos = currentPos.relative(adjacentBlock);
                    BlockState foundState = structure.world.getBlockState(tempPos);
                    Block foundBlock = foundState.getBlock();
                    if (!(foundBlock instanceof TorchBlock) && !(foundBlock instanceof SignBlock) && !(foundBlock instanceof LeverBlock) && !(foundBlock instanceof ButtonBlock) && !(foundBlock instanceof BedBlock) && !(foundBlock instanceof CarpetBlock) && !(foundBlock instanceof FlowerPotBlock) && !(foundBlock instanceof SugarCaneBlock) && !(foundBlock instanceof BasePressurePlateBlock) && !(foundBlock instanceof DoorBlock) && !(foundBlock instanceof LadderBlock) && !(foundBlock instanceof VineBlock) && !(foundBlock instanceof RedStoneWireBlock) && !(foundBlock instanceof DiodeBlock) && !(foundBlock instanceof AbstractBannerBlock) && !(foundBlock instanceof LanternBlock) && !(foundBlock instanceof BaseRailBlock)) continue;
                    structure.BeforeClearSpaceBlockReplaced(currentPos);
                    if (foundBlock instanceof DoorBlock) {
                        DoubleBlockHalf currentHalf = (DoubleBlockHalf)foundState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF);
                        BlockPos otherHalfPos = currentHalf == DoubleBlockHalf.LOWER ? tempPos.above() : tempPos.below();
                        structure.world.setBlock(tempPos, Blocks.AIR.defaultBlockState(), 35);
                        structure.world.setBlock(otherHalfPos, Blocks.AIR.defaultBlockState(), 35);
                        continue;
                    }
                    if (!(foundBlock instanceof BedBlock)) {
                        structure.world.removeBlock(tempPos, false);
                        continue;
                    }
                    for (Direction currentDirection : Direction.values()) {
                        BlockPos bedPos = tempPos.relative(currentDirection);
                        BlockState bedState = structure.world.getBlockState(bedPos);
                        if (!(bedState.getBlock() instanceof BedBlock)) continue;
                        structure.world.setBlock(tempPos, Blocks.AIR.defaultBlockState(), 35);
                        structure.world.setBlock(bedPos, Blocks.AIR.defaultBlockState(), 35);
                        continue block0;
                    }
                }
                structure.world.removeBlock(currentPos, false);
            } else {
                --i;
            }
            return i;
        }
        BuildBlock currentBlock = null;
        if (structure.priorityOneBlocks.isEmpty()) {
            structuresToRemove.add(structure);
            return 999;
        }
        currentBlock = structure.priorityOneBlocks.getFirst();
        structure.priorityOneBlocks.removeFirst();
        BlockState state = currentBlock.getBlockState();
        BlockPos setBlockPos = currentBlock.getStartingPosition().getRelativePosition(structure.originalPos, structure.getClearSpace().getShape().getDirection(), structure.configuration.houseFacing);
        BuildingMethods.ReplaceBlock((Level)structure.world, setBlockPos, state, 2);
        if (currentBlock.getSubBlock() != null) {
            BuildBlock subBlock = currentBlock.getSubBlock();
            BuildingMethods.ReplaceBlock((Level)structure.world, subBlock.getStartingPosition().getRelativePosition(structure.originalPos, structure.getClearSpace().getShape().getDirection(), structure.configuration.houseFacing), subBlock.getBlockState());
        }
        return i;
    }

    private static void removeStructuresFromList(ArrayList<Structure> structuresToRemove, Map.Entry<Player, ArrayList<Structure>> entry) {
        for (Structure structure : structuresToRemove) {
            StructureGenerator.removeWaterLogging(structure);
            for (BuildEntity buildEntity : structure.entities) {
                Optional entityType = EntityType.byString((String)buildEntity.getEntityResourceString());
                if (!entityType.isPresent()) continue;
                entitiesToGenerate.add(new Tuple<Structure, BuildEntity>(structure, buildEntity));
            }
            entry.getValue().remove(structure);
        }
    }

    private static void processStructureEntities() {
        for (Tuple<Structure, BuildEntity> entityRecords : entitiesToGenerate) {
            Entity entity;
            Entity entity2;
            BuildEntity buildEntity = (BuildEntity)entityRecords.second;
            Structure structure = (Structure)entityRecords.first;
            Optional entityType = EntityType.byString((String)buildEntity.getEntityResourceString());
            if (!entityType.isPresent() || (entity2 = ((EntityType)entityType.get()).create((Level)structure.world)) == null) continue;
            CompoundTag tagCompound = buildEntity.getEntityDataTag();
            BlockPos entityPos = buildEntity.getStartingPosition().getRelativePosition(structure.originalPos, structure.getClearSpace().getShape().getDirection(), structure.configuration.houseFacing);
            if (tagCompound != null) {
                if (tagCompound.hasUUID("UUID")) {
                    tagCompound.putUUID("UUID", UUID.randomUUID());
                }
                tagCompound = StructureGenerator.updateTagDueToVersionUpdate(entity2, tagCompound);
                ListTag nbttaglist = new ListTag();
                nbttaglist.add((Object)DoubleTag.valueOf((double)entityPos.getX()));
                nbttaglist.add((Object)DoubleTag.valueOf((double)entityPos.getY()));
                nbttaglist.add((Object)DoubleTag.valueOf((double)entityPos.getZ()));
                tagCompound.put("Pos", (Tag)nbttaglist);
                entity2.load(tagCompound);
            }
            Objects.requireNonNull(entity2);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemFrame.class, Painting.class, AbstractMinecart.class}, (Object)entity, n)) {
                case 0: {
                    ItemFrame itemFrame = (ItemFrame)entity;
                    entity2 = StructureGenerator.setItemFrameFacingAndRotation(itemFrame, buildEntity, entityPos, structure);
                    break;
                }
                case 1: {
                    Painting painting = (Painting)entity;
                    entity2 = StructureGenerator.setPaintingFacingAndRotation(painting, buildEntity, entityPos, structure);
                    break;
                }
                case 2: {
                    AbstractMinecart abstractMinecart = (AbstractMinecart)entity;
                    buildEntity.entityYAxisOffset += 0.2;
                    entity2 = StructureGenerator.setEntityFacingAndRotation(entity2, buildEntity, entityPos, structure);
                    break;
                }
                default: {
                    entity2 = StructureGenerator.setEntityFacingAndRotation(entity2, buildEntity, entityPos, structure);
                }
            }
            structure.world.addFreshEntity(entity2);
        }
        entitiesToGenerate.clear();
    }

    private static void removeWaterLogging(Structure structure) {
        if (structure.hasAirBlocks) {
            for (BlockPos currentPos : structure.allBlockPositions) {
                BlockState currentState = structure.world.getBlockState(currentPos);
                if (currentState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                    currentState = (BlockState)currentState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
                    structure.world.setBlock(currentPos, currentState, 3);
                    continue;
                }
                if (currentState.getBlock() != Blocks.WATER) continue;
                structure.world.setBlock(currentPos, Blocks.AIR.defaultBlockState(), 3);
            }
        }
    }

    private static Entity setPaintingFacingAndRotation(Painting entity, BuildEntity buildEntity, BlockPos entityPos, Structure structure) {
        float yaw = entity.getYRot();
        Rotation rotation = Rotation.NONE;
        double x_axis_offset = 0.0;
        double z_axis_offset = 0.0;
        Direction facing = entity.getDirection();
        double y_axis_offset = buildEntity.entityYAxisOffset * -1.0;
        Direction structureDirection = structure.getClearSpace().getShape().getDirection();
        Direction configurationDirection = structure.configuration.houseFacing.getOpposite();
        if (configurationDirection == structureDirection.getOpposite()) {
            rotation = Rotation.CLOCKWISE_180;
            facing = facing.getOpposite();
        } else if (configurationDirection == structureDirection.getClockWise()) {
            rotation = Rotation.CLOCKWISE_90;
            facing = facing.getClockWise();
        } else if (configurationDirection == structureDirection.getCounterClockWise()) {
            rotation = Rotation.COUNTERCLOCKWISE_90;
            facing = facing.getCounterClockWise();
        }
        PaintingVariant paintingVariant = (PaintingVariant)entity.getVariant().value();
        int paintingBlockWidth = paintingVariant.width();
        int paintingBlockHeight = paintingVariant.height();
        if (!(paintingBlockHeight <= paintingBlockWidth && paintingBlockHeight <= 1 || paintingBlockWidth == 4 && paintingBlockHeight == 3)) {
            y_axis_offset -= 1.0;
        }
        yaw = entity.rotate(rotation);
        CompoundTag compound = new CompoundTag();
        entity.addAdditionalSaveData(compound);
        compound.putByte("facing", (byte)facing.get2DDataValue());
        entity.readAdditionalSaveData(compound);
        StructureGenerator.updateEntityHangingBoundingBox((HangingEntity)entity);
        entity.moveTo((double)entityPos.getX() + x_axis_offset, (double)entityPos.getY() + y_axis_offset, (double)entityPos.getZ() + z_axis_offset, yaw, entity.getXRot());
        StructureGenerator.updateEntityHangingBoundingBox((HangingEntity)entity);
        LevelChunk chunk = structure.world.getChunkAt(entityPos);
        chunk.setUnsaved(true);
        return entity;
    }

    private static Entity setItemFrameFacingAndRotation(ItemFrame frame, BuildEntity buildEntity, BlockPos entityPos, Structure structure) {
        float yaw = frame.getYRot();
        Rotation rotation = Rotation.NONE;
        double x_axis_offset = buildEntity.entityXAxisOffset;
        double z_axis_offset = buildEntity.entityZAxisOffset;
        Direction facing = frame.getDirection();
        double y_axis_offset = buildEntity.entityYAxisOffset;
        x_axis_offset *= -1.0;
        z_axis_offset *= -1.0;
        Direction structureDirection = structure.getClearSpace().getShape().getDirection();
        Direction configurationDirection = structure.configuration.houseFacing.getOpposite();
        if (facing != Direction.UP && facing != Direction.DOWN) {
            if (configurationDirection == structureDirection.getOpposite()) {
                rotation = Rotation.CLOCKWISE_180;
                facing = facing.getOpposite();
            } else if (configurationDirection == structureDirection.getClockWise()) {
                rotation = Rotation.CLOCKWISE_90;
                facing = facing.getClockWise();
            } else if (configurationDirection == structureDirection.getCounterClockWise()) {
                rotation = Rotation.COUNTERCLOCKWISE_90;
                facing = facing.getCounterClockWise();
            } else {
                x_axis_offset = 0.0;
                z_axis_offset = 0.0;
            }
        }
        yaw = frame.rotate(rotation);
        CompoundTag compound = new CompoundTag();
        frame.addAdditionalSaveData(compound);
        compound.putByte("Facing", (byte)facing.get3DDataValue());
        frame.readAdditionalSaveData(compound);
        StructureGenerator.updateEntityHangingBoundingBox((HangingEntity)frame);
        frame.moveTo((double)entityPos.getX() + x_axis_offset, (double)entityPos.getY() + y_axis_offset, (double)entityPos.getZ() + z_axis_offset, yaw, frame.getXRot());
        StructureGenerator.updateEntityHangingBoundingBox((HangingEntity)frame);
        LevelChunk chunk = structure.world.getChunkAt(entityPos);
        chunk.setUnsaved(true);
        return frame;
    }

    private static Entity setEntityFacingAndRotation(Entity entity, BuildEntity buildEntity, BlockPos entityPos, Structure structure) {
        float yaw = entity.getYRot();
        Rotation rotation = Rotation.NONE;
        double x_axis_offset = buildEntity.entityXAxisOffset;
        double z_axis_offset = buildEntity.entityZAxisOffset;
        Direction facing = structure.getClearSpace().getShape().getDirection();
        double y_axis_offset = buildEntity.entityYAxisOffset;
        Direction configurationDirection = structure.configuration.houseFacing.getOpposite();
        if (configurationDirection == facing.getOpposite()) {
            rotation = Rotation.CLOCKWISE_180;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
        } else if (configurationDirection == facing.getClockWise()) {
            rotation = Rotation.CLOCKWISE_90;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
        } else if (configurationDirection == facing.getCounterClockWise()) {
            rotation = Rotation.COUNTERCLOCKWISE_90;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
        } else {
            x_axis_offset = 0.0;
            z_axis_offset = 0.0;
        }
        yaw = entity.rotate(rotation);
        entity.moveTo((double)entityPos.getX() + x_axis_offset, (double)entityPos.getY() + y_axis_offset, (double)entityPos.getZ() + z_axis_offset, yaw, entity.getXRot());
        return entity;
    }

    private static void updateEntityHangingBoundingBox(HangingEntity entity) {
        double d0 = (double)entity.getPos().getX() + 0.5;
        double d1 = (double)entity.getPos().getY() + 0.5;
        double d2 = (double)entity.getPos().getZ() + 0.5;
        double d3 = 0.46875;
        double d4 = entity.getBbWidth() % 32.0f == 0.0f ? 0.5 : 0.0;
        double d5 = entity.getBbHeight() % 32.0f == 0.0f ? 0.5 : 0.0;
        Direction horizontal = entity.getDirection();
        d0 -= (double)horizontal.getStepX() * 0.46875;
        d2 -= (double)horizontal.getStepZ() * 0.46875;
        Direction direction = horizontal == Direction.DOWN || horizontal == Direction.UP ? horizontal.getOpposite() : horizontal.getCounterClockWise();
        entity.setPosRaw(d0 += d4 * (double)direction.getStepX(), d1 += d5, d2 += d4 * (double)direction.getStepZ());
        double d6 = entity.getBbWidth();
        double d7 = entity.getBbHeight();
        double d8 = entity.getBbWidth();
        if (horizontal.getAxis() == Direction.Axis.Z) {
            d8 = 1.0;
        } else {
            d6 = 1.0;
        }
        entity.setBoundingBox(new AABB(d0 - (d6 /= 32.0), d1 - (d7 /= 32.0), d2 - (d8 /= 32.0), d0 + d6, d1 + d7, d2 + d8));
    }

    private static CompoundTag updateTagDueToVersionUpdate(Entity entity, CompoundTag compoundTag) {
        if (entity instanceof Painting) {
            if (compoundTag.contains("Facing")) {
                byte facingByte = compoundTag.getByte("Facing");
                compoundTag.putByte("facing", facingByte);
            }
            if (compoundTag.contains("Motive")) {
                String motiveData = compoundTag.getString("Motive");
                compoundTag.putString("variant", motiveData);
            }
        }
        return compoundTag;
    }
}

