/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.structures.base;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.prefab.ModRegistryBase;
import com.prefab.PrefabBase;
import com.prefab.Tuple;
import com.prefab.ZipUtil;
import com.prefab.blocks.FullDyeColor;
import com.prefab.structures.base.AllowedBlockReplacementResult;
import com.prefab.structures.base.BuildBlock;
import com.prefab.structures.base.BuildClear;
import com.prefab.structures.base.BuildEntity;
import com.prefab.structures.base.BuildProperty;
import com.prefab.structures.base.BuildTileEntity;
import com.prefab.structures.base.BuildingMethods;
import com.prefab.structures.base.PositionOffset;
import com.prefab.structures.base.ReplacementResultType;
import com.prefab.structures.config.StructureConfiguration;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Structure {
    public ArrayList<BlockPos> allBlockPositions = new ArrayList();
    public ArrayList<BlockPos> clearedBlockPos = new ArrayList();
    public ArrayList<BuildBlock> priorityOneBlocks = new ArrayList();
    public ArrayList<BuildBlock> airBlocks = new ArrayList();
    public StructureConfiguration configuration;
    public ServerLevel world;
    public BlockPos originalPos;
    public boolean hasAirBlocks = false;
    public boolean entitiesRemoved = false;
    @Expose
    public ArrayList<BuildTileEntity> tileEntities = new ArrayList();
    @Expose
    public ArrayList<BuildEntity> entities = new ArrayList();
    @Expose
    private String name;
    @Expose
    private BuildClear clearSpace;
    @Expose
    private ArrayList<BuildBlock> blocks;

    public Structure() {
        this.Initialize();
    }

    public static <T extends Structure> T CreateInstance(String resourceLocation, Class<? extends Structure> child) {
        Gson file = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        Structure structure = (Structure)file.fromJson(ZipUtil.decompressResource(resourceLocation), child);
        return (T)structure;
    }

    public static void CreateStructureFile(Structure structure, String fileLocation) {
        try {
            Gson converter = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
            StringWriter stringWriter = new StringWriter();
            converter.toJson((Object)structure, (Appendable)stringWriter);
            ZipUtil.zipStringToFile(stringWriter.toString(), fileLocation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void ScanStructure(Level world, BlockPos originalPos, BlockPos cornerPos1, BlockPos cornerPos2, String fileLocation, BuildClear clearedSpace, Direction playerFacing, boolean includeAir, boolean excludeWater) {
        Structure scannedStructure = new Structure();
        scannedStructure.setClearSpace(clearedSpace);
        for (BlockPos currentPos : BlockPos.betweenClosed((BlockPos)cornerPos1, (BlockPos)cornerPos2)) {
            if (world.isEmptyBlock(currentPos) && !includeAir) continue;
            BlockState currentState = world.getBlockState(currentPos);
            Block currentBlock = currentState.getBlock();
            if (currentState.getBlock() == Blocks.WATER && excludeWater) continue;
            BuildBlock buildBlock = Structure.createBuildBlockFromBlockState(currentState, currentBlock, currentPos, originalPos);
            if (currentBlock instanceof DoorBlock) {
                DoubleBlockHalf blockHalf = (DoubleBlockHalf)currentState.getValue((Property)DoorBlock.HALF);
                if (blockHalf != DoubleBlockHalf.LOWER) continue;
                BlockState upperHalfState = world.getBlockState(currentPos.above());
                if (upperHalfState.getBlock() instanceof DoorBlock) {
                    Block upperBlock = upperHalfState.getBlock();
                    BuildBlock upperHalf = Structure.createBuildBlockFromBlockState(upperHalfState, upperBlock, currentPos.above(), originalPos);
                    buildBlock.setSubBlock(upperHalf);
                }
            } else if (currentBlock instanceof BedBlock) {
                BedPart bedPart = (BedPart)currentState.getValue((Property)BedBlock.PART);
                if (bedPart != BedPart.HEAD) continue;
                BlockState bedFoot = null;
                boolean foundFoot = false;
                Direction facing = Direction.NORTH;
                while (!foundFoot) {
                    bedFoot = world.getBlockState(currentPos.relative(facing));
                    if (bedFoot.getBlock() instanceof BedBlock && bedFoot.getValue((Property)BedBlock.PART) == BedPart.FOOT) {
                        foundFoot = true;
                        break;
                    }
                    if ((facing = facing.getClockWise()) != Direction.NORTH) continue;
                }
                if (foundFoot) {
                    Block footBedBlock = bedFoot.getBlock();
                    BuildBlock bed = Structure.createBuildBlockFromBlockState(bedFoot, footBedBlock, currentPos.relative(facing), originalPos);
                    buildBlock.setSubBlock(bed);
                }
            }
            scannedStructure.getBlocks().add(buildBlock);
            BlockEntity tileEntity = world.getBlockEntity(currentPos);
            if (tileEntity == null || tileEntity instanceof ChestBlockEntity && ((ChestBlockEntity)tileEntity).isEmpty() || tileEntity instanceof FurnaceBlockEntity && ((FurnaceBlockEntity)tileEntity).isEmpty()) continue;
            ResourceLocation resourceLocation = BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)tileEntity.getType());
            CompoundTag tagCompound = tileEntity.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
            BuildTileEntity buildTileEntity = new BuildTileEntity();
            assert (resourceLocation != null);
            buildTileEntity.setEntityDomain(resourceLocation.getNamespace());
            buildTileEntity.setEntityName(resourceLocation.getPath());
            buildTileEntity.setStartingPosition(Structure.getStartingPositionFromOriginalAndCurrentPosition(currentPos, originalPos));
            buildTileEntity.setEntityNBTData(tagCompound);
            scannedStructure.tileEntities.add(buildTileEntity);
        }
        int x_radiusRangeBegin = Math.min(cornerPos1.getX(), cornerPos2.getX());
        int x_radiusRangeEnd = Math.max(cornerPos1.getX(), cornerPos2.getX());
        int y_radiusRangeBegin = Math.min(cornerPos1.getY(), cornerPos2.getY());
        int y_radiusRangeEnd = Math.max(cornerPos1.getY(), cornerPos2.getY());
        int z_radiusRangeBegin = Math.min(cornerPos1.getZ(), cornerPos2.getZ());
        int z_radiusRangeEnd = Math.max(cornerPos1.getZ(), cornerPos2.getZ());
        Vec3 pos1 = new Vec3((double)cornerPos1.getX(), (double)cornerPos1.getY(), (double)cornerPos1.getZ());
        Vec3 pos2 = new Vec3((double)cornerPos2.getX(), (double)cornerPos2.getY(), (double)cornerPos2.getZ());
        AABB axis = new AABB(pos1, pos2);
        for (Entity entity : world.getEntities(null, axis)) {
            BlockPos entityPos = entity.blockPosition();
            if (entity instanceof HangingEntity) {
                entityPos = ((HangingEntity)entity).getPos();
            }
            if (entityPos.getX() < x_radiusRangeBegin || entityPos.getX() > x_radiusRangeEnd || entityPos.getZ() < z_radiusRangeBegin || entityPos.getZ() > z_radiusRangeEnd || entityPos.getY() < y_radiusRangeBegin || entityPos.getY() > y_radiusRangeEnd) continue;
            BuildEntity buildEntity = new BuildEntity();
            buildEntity.setEntityResourceString(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()));
            buildEntity.setStartingPosition(Structure.getStartingPositionFromOriginalAndCurrentPosition(entityPos, originalPos));
            buildEntity.entityXAxisOffset = (double)entityPos.getX() - entity.getX();
            buildEntity.entityYAxisOffset = (double)entityPos.getY() - entity.getY();
            buildEntity.entityZAxisOffset = (double)entityPos.getZ() - entity.getZ();
            if (entity instanceof ItemFrame) {
                buildEntity.entityYAxisOffset *= -1.0;
            }
            if (entity instanceof HangingEntity) {
                buildEntity.entityFacing = entity.getDirection();
            }
            CompoundTag entityTagCompound = new CompoundTag();
            entity.saveAsPassenger(entityTagCompound);
            buildEntity.setEntityNBTData(entityTagCompound);
            scannedStructure.entities.add(buildEntity);
        }
        Structure.CreateStructureFile(scannedStructure, fileLocation);
    }

    public static BuildBlock createBuildBlockFromBlockState(BlockState currentState, Block currentBlock, BlockPos currentPos, BlockPos originalPos) {
        BuildBlock buildBlock = new BuildBlock();
        ResourceLocation blockIdentifier = BuiltInRegistries.BLOCK.getKey((Object)currentBlock);
        buildBlock.setBlockDomain(blockIdentifier.getNamespace());
        buildBlock.setBlockName(blockIdentifier.getPath());
        buildBlock.setStartingPosition(Structure.getStartingPositionFromOriginalAndCurrentPosition(currentPos, originalPos));
        buildBlock.blockPos = currentPos;
        Collection properties = currentState.getProperties();
        for (Property entry : properties) {
            BuildProperty property = new BuildProperty();
            property.setName(entry.getName());
            Comparable value = currentState.getValue(entry);
            try {
                if (currentBlock instanceof RotatedPillarBlock && property.getName().equals("axis")) {
                    property.setValue(((Direction.Axis)value).getSerializedName());
                } else if (currentBlock instanceof CarpetBlock && property.getName().equals("color")) {
                    DyeColor dyeColor = (DyeColor)value;
                    property.setValue(dyeColor.getSerializedName());
                } else if (value instanceof StringRepresentable) {
                    StringRepresentable stringSerializable = (StringRepresentable)value;
                    property.setValue(stringSerializable.getSerializedName());
                } else {
                    property.setValue(value.toString());
                }
            }
            catch (Exception ex) {
                PrefabBase.logger.error("Unable to set property [" + property.getName() + "] to value [" + String.valueOf(value) + "] for Block [" + buildBlock.getBlockDomain() + ":" + buildBlock.getBlockName() + "].");
                throw ex;
            }
            buildBlock.getProperties().add(property);
        }
        return buildBlock;
    }

    public static PositionOffset getStartingPositionFromOriginalAndCurrentPosition(BlockPos currentPos, BlockPos originalPos) {
        PositionOffset positionOffSet = new PositionOffset();
        if (currentPos.getX() > originalPos.getX()) {
            positionOffSet.setEastOffset(currentPos.getX() - originalPos.getX());
        } else {
            positionOffSet.setWestOffset(originalPos.getX() - currentPos.getX());
        }
        if (currentPos.getZ() > originalPos.getZ()) {
            positionOffSet.setSouthOffset(currentPos.getZ() - originalPos.getZ());
        } else {
            positionOffSet.setNorthOffset(originalPos.getZ() - currentPos.getZ());
        }
        positionOffSet.setHeightOffset(currentPos.getY() - originalPos.getY());
        return positionOffSet;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public BuildClear getClearSpace() {
        return this.clearSpace;
    }

    public void setClearSpace(BuildClear value) {
        this.clearSpace = value;
    }

    public ArrayList<BuildBlock> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(ArrayList<BuildBlock> value) {
        this.blocks = value;
    }

    public void Initialize() {
        this.name = "";
        this.clearSpace = new BuildClear();
        this.blocks = new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    public boolean BuildStructure(StructureConfiguration configuration, ServerLevel world, BlockPos originalPos, Player player) {
        BlockPos startBlockPos = this.clearSpace.getStartingPosition().getRelativePosition(originalPos, this.clearSpace.getShape().getDirection(), configuration.houseFacing);
        BlockPos endBlockPos = startBlockPos.relative(configuration.houseFacing.getCounterClockWise(), this.clearSpace.getShape().getWidth() - 1).relative(configuration.houseFacing.getOpposite(), this.clearSpace.getShape().getLength() - 1).relative(Direction.UP, this.clearSpace.getShape().getHeight());
        AllowedBlockReplacementResult checkResult = BuildingMethods.CheckBuildSpaceForAllowedBlockReplacement(world, startBlockPos, endBlockPos, player);
        if (checkResult.allowedToReplace != ReplacementResultType.ALLOWED) {
            String langKey;
            switch (checkResult.allowedToReplace) {
                default: {
                    throw new MatchException(null, null);
                }
                case ALLOWED: {
                    String string = null;
                    break;
                }
                case NOT_ALLOWED_SPAWN_PROTECTION: {
                    String string = "prefab.gui.structure.nobuild_spawn_protection";
                    break;
                }
                case NOT_ALLOWED_MOD_PROTECTED: {
                    String string = "prefab.gui.structure.nobuild_mod_protection";
                    break;
                }
                case NOT_ALLOWED_UNBREAKABLE_BLOCK: {
                    String string = "prefab.gui.structure.nobuild_unbreakable";
                    break;
                }
                case NOT_ALLOWED_STRICT_BUILDING_MODE: {
                    String string = langKey = "prefab.gui.structure.nobuild_strict_building_mode";
                }
            }
            if (langKey != null) {
                MutableComponent message = Structure.createCannotBuildMessage(checkResult, langKey);
                player.sendSystemMessage((Component)message);
                return false;
            }
        }
        if (PrefabBase.serverConfiguration.playBuildingSound) {
            world.playSound(null, originalPos, ModRegistryBase.BuildingBlueprint, SoundSource.NEUTRAL, 0.8f, 0.8f);
        }
        if (!this.BeforeBuilding(configuration, (Level)world, originalPos, player)) {
            try {
                this.ClearSpace(configuration, (Level)world, startBlockPos, endBlockPos);
                ArrayList<Tuple<BlockState, BlockPos>> laterBlocks = new ArrayList<Tuple<BlockState, BlockPos>>();
                boolean blockPlacedWithCobbleStoneInstead = false;
                for (BuildBlock buildBlock : this.getBlocks()) {
                    Block foundBlock = (Block)BuiltInRegistries.BLOCK.get(buildBlock.getResourceLocation());
                    if (foundBlock != null) {
                        void var11_17;
                        BlockState blockState = foundBlock.defaultBlockState();
                        BuildBlock subBlock = null;
                        if (this.WaterReplacedWithCobbleStone(configuration, buildBlock, (Level)world, originalPos, foundBlock, blockState, player).booleanValue() || this.CustomBlockProcessingHandled(configuration, buildBlock, (Level)world, originalPos, foundBlock, blockState, player).booleanValue()) continue;
                        if (!this.processedGlassBlock(configuration, buildBlock, (Level)world, originalPos, foundBlock)) {
                            BuildBlock buildBlock2 = BuildBlock.SetBlockState(configuration, (Level)world, originalPos, buildBlock, foundBlock, blockState, this);
                        }
                        if (var11_17.getSubBlock() != null) {
                            foundBlock = (Block)BuiltInRegistries.BLOCK.get(var11_17.getSubBlock().getResourceLocation());
                            blockState = foundBlock.defaultBlockState();
                            subBlock = BuildBlock.SetBlockState(configuration, (Level)world, originalPos, var11_17.getSubBlock(), foundBlock, blockState, this);
                        }
                        BlockPos setBlockPos = var11_17.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                        Block blockToPlace = var11_17.getBlockState().getBlock();
                        if (!blockToPlace.hasCollision && !(blockToPlace instanceof LiquidBlock) || blockToPlace instanceof CarpetBlock) {
                            laterBlocks.add(new Tuple<BlockState, BlockPos>(var11_17.getBlockState(), setBlockPos));
                        } else {
                            world.setBlock(setBlockPos, var11_17.getBlockState(), 3);
                        }
                        if (subBlock == null) continue;
                        BlockPos subBlockPos = subBlock.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                        world.setBlock(subBlockPos, subBlock.getBlockState(), 3);
                        continue;
                    }
                    String blockTypeNotFound = buildBlock.getResourceLocation().toString();
                    BuildBlock buildBlock3 = BuildBlock.SetBlockState(configuration, (Level)world, originalPos, buildBlock, Blocks.COBBLESTONE, Blocks.COBBLESTONE.defaultBlockState(), this);
                    this.priorityOneBlocks.add(buildBlock3);
                    if (blockPlacedWithCobbleStoneInstead) continue;
                    blockPlacedWithCobbleStoneInstead = true;
                    PrefabBase.logger.warn("A Block was in the structure, but it is not registered. This block was replaced with vanilla cobblestone instead. Block type not found: [" + blockTypeNotFound + "]");
                }
                for (Tuple tuple : laterBlocks) {
                    world.setBlock((BlockPos)tuple.getSecond(), (BlockState)tuple.getFirst(), 3);
                }
                this.configuration = configuration;
                this.world = world;
                this.originalPos = originalPos;
                this.setBlockEntities();
                this.AfterBuilding(this.configuration, this.world, this.originalPos, player);
            }
            catch (Exception ex) {
                PrefabBase.logger.error((Object)ex);
            }
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)startBlockPos, (BlockPos)endBlockPos)) {
                Block block = world.getBlockState(pos).getBlock();
                world.blockUpdated(pos, block);
            }
            if (PrefabBase.structuresToBuild.containsKey(player)) {
                PrefabBase.structuresToBuild.get(player).add(this);
            } else {
                ArrayList<Structure> structures = new ArrayList<Structure>();
                structures.add(this);
                PrefabBase.structuresToBuild.put(player, structures);
            }
        }
        return true;
    }

    @NotNull
    private static MutableComponent createCannotBuildMessage(AllowedBlockReplacementResult checkResult, String langKey) {
        MutableComponent blockName = Component.translatable((String)checkResult.protectedBlock.getBlock().getDescriptionId());
        MutableComponent message = Component.translatable((String)langKey, (Object[])new Object[]{blockName, checkResult.protectedBlockPos.getX(), checkResult.protectedBlockPos.getY(), checkResult.protectedBlockPos.getZ()});
        message.setStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW));
        return message;
    }

    public void BeforeClearSpaceBlockReplaced(BlockPos pos) {
    }

    public void BeforeHangingEntityRemoved(HangingEntity hangingEntity) {
    }

    protected boolean BeforeBuilding(StructureConfiguration configuration, Level world, BlockPos originalPos, Player player) {
        return false;
    }

    public void AfterBuilding(StructureConfiguration configuration, ServerLevel world, BlockPos originalPos, Player player) {
    }

    protected void ClearSpace(StructureConfiguration configuration, Level world, BlockPos startBlockPos, BlockPos endBlockPos) {
        if (this.clearSpace.getShape().getWidth() > 0 && this.clearSpace.getShape().getLength() > 0) {
            this.clearedBlockPos = new ArrayList();
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)startBlockPos, (BlockPos)endBlockPos)) {
                if (!this.BlockShouldBeClearedDuringConstruction(configuration, world, this.originalPos, pos).booleanValue()) continue;
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
            }
        } else {
            this.clearedBlockPos = new ArrayList();
        }
    }

    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, Level world, BlockPos originalPos, Block foundBlock, BlockState blockState, Player player) {
        return false;
    }

    protected Boolean BlockShouldBeClearedDuringConstruction(StructureConfiguration configuration, Level world, BlockPos originalPos, BlockPos blockPos) {
        return true;
    }

    protected Boolean WaterReplacedWithCobbleStone(StructureConfiguration configuration, BuildBlock block, Level world, BlockPos originalPos, Block foundBlock, BlockState blockState, Player player) {
        boolean isOverworld = Level.OVERWORLD.location().toString().equals(world.dimension().location().toString());
        if (world.dimensionType().ultraWarm() || !isOverworld && PrefabBase.serverConfiguration.allowWaterInNonOverworldDimensions) {
            boolean foundWaterLikeBlock;
            boolean bl = foundWaterLikeBlock = foundBlock instanceof LiquidBlock && blockState.getBlock() == Blocks.WATER || foundBlock instanceof SeagrassBlock;
            if (!foundWaterLikeBlock) {
                for (BuildProperty property : block.getProperties()) {
                    if (!property.getName().equalsIgnoreCase(BlockStateProperties.WATERLOGGED.getName()) || !property.getValue().equalsIgnoreCase(BlockStateProperties.WATERLOGGED.getName(Boolean.valueOf(true)))) continue;
                    foundWaterLikeBlock = true;
                    break;
                }
            }
            if (foundWaterLikeBlock) {
                ResourceLocation cobbleIdentifier = BuiltInRegistries.BLOCK.getKey((Object)Blocks.COBBLESTONE);
                block.setBlockDomain(cobbleIdentifier.getNamespace());
                block.setBlockName(cobbleIdentifier.getPath());
                block.setBlockState(Blocks.COBBLESTONE.defaultBlockState());
                BlockPos setBlockPos = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                world.setBlock(setBlockPos, block.getBlockState(), 3);
                return true;
            }
        }
        return false;
    }

    protected boolean processedGlassBlock(StructureConfiguration configuration, BuildBlock block, Level world, BlockPos originalPos, Block foundBlock) {
        if (!this.hasGlassColor(configuration)) {
            return false;
        }
        ResourceLocation blockIdentifier = BuiltInRegistries.BLOCK.getKey((Object)foundBlock);
        ResourceLocation glassIdentifier = BuiltInRegistries.BLOCK.getKey((Object)Blocks.WHITE_STAINED_GLASS);
        ResourceLocation glassPaneIdentifier = BuiltInRegistries.BLOCK.getKey((Object)Blocks.WHITE_STAINED_GLASS_PANE);
        if (blockIdentifier.getNamespace().equals(glassIdentifier.getNamespace()) && blockIdentifier.getPath().endsWith("glass")) {
            BlockState blockState = BuildingMethods.getStainedGlassBlock(this.getGlassColor(configuration));
            block.setBlockState(blockState);
            return true;
        }
        if (blockIdentifier.getNamespace().equals(glassPaneIdentifier.getNamespace()) && blockIdentifier.getPath().endsWith("glass_pane")) {
            BlockState blockState = BuildingMethods.getStainedGlassPaneBlock(this.getGlassColor(configuration));
            BuildBlock.SetBlockState(configuration, world, originalPos, block, foundBlock, blockState, this);
            return true;
        }
        return false;
    }

    protected boolean hasGlassColor(StructureConfiguration configuration) {
        return false;
    }

    protected FullDyeColor getGlassColor(StructureConfiguration configuration) {
        return FullDyeColor.CLEAR;
    }

    protected void setBlockEntities() {
        for (BuildTileEntity buildTileEntity : this.tileEntities) {
            try {
                if (buildTileEntity.getEntityName().equals("bed")) continue;
                BlockPos tileEntityPos = buildTileEntity.getStartingPosition().getRelativePosition(this.originalPos, this.getClearSpace().getShape().getDirection(), this.configuration.houseFacing);
                BlockEntity tileEntity = this.world.getBlockEntity(tileEntityPos);
                BlockState tileBlock = this.world.getBlockState(tileEntityPos);
                if (tileEntity != null) {
                    this.world.removeBlockEntity(tileEntityPos);
                }
                if ((tileEntity = BlockEntity.loadStatic((BlockPos)tileEntityPos, (BlockState)tileBlock, (CompoundTag)buildTileEntity.getEntityDataTag(), (HolderLookup.Provider)this.world.registryAccess())) == null) continue;
                this.world.setBlockEntity(tileEntity);
                this.world.getChunk(tileEntityPos).setUnsaved(true);
                tileEntity.setChanged();
                Packet packet = tileEntity.getUpdatePacket();
                if (packet == null) continue;
                this.world.getServer().getPlayerList().broadcastAll(packet);
            }
            catch (Exception ex) {
                PrefabBase.logger.error((Object)ex);
            }
        }
    }
}

