/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.structures.base;

import com.prefab.gui.GuiLangKeys;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public enum EnumStairsMaterial {
    Brick("prefab.gui.material.brick", Blocks.BRICK_STAIRS.defaultBlockState()),
    Cobblestone("prefab.gui.material.cobble_stone", Blocks.COBBLESTONE_STAIRS.defaultBlockState()),
    StoneBrick("prefab.gui.material.stone_brick", Blocks.STONE_BRICK_STAIRS.defaultBlockState()),
    Granite("prefab.gui.material.granite", Blocks.POLISHED_GRANITE_STAIRS.defaultBlockState()),
    Andesite("prefab.gui.material.andesite", Blocks.POLISHED_ANDESITE_STAIRS.defaultBlockState()),
    Diorite("prefab.gui.material.diorite", Blocks.POLISHED_DIORITE_STAIRS.defaultBlockState()),
    Oak("prefab.wall.block.type.oak", Blocks.OAK_STAIRS.defaultBlockState()),
    Spruce("prefab.wall.block.type.spruce", Blocks.SPRUCE_STAIRS.defaultBlockState()),
    Birch("prefab.wall.block.type.birch", Blocks.BIRCH_STAIRS.defaultBlockState()),
    Jungle("prefab.wall.block.type.jungle", Blocks.JUNGLE_STAIRS.defaultBlockState()),
    Acacia("prefab.wall.block.type.acacia", Blocks.ACACIA_STAIRS.defaultBlockState()),
    DarkOak("prefab.wall.block.type.darkoak", Blocks.DARK_OAK_STAIRS.defaultBlockState()),
    SandStone("prefab.ceiling.block.type.sand", Blocks.SANDSTONE_STAIRS.defaultBlockState()),
    RedSandStone("prefab.gui.material.red_sandstone", Blocks.RED_SANDSTONE_STAIRS.defaultBlockState());

    public final BlockState stairsState;
    private String name;

    private EnumStairsMaterial(String name, BlockState stairsState) {
        this.name = name;
        this.stairsState = stairsState;
    }

    public static EnumStairsMaterial getByOrdinal(int ordinal) {
        for (EnumStairsMaterial value : EnumStairsMaterial.values()) {
            if (value.ordinal() != ordinal) continue;
            return value;
        }
        return Cobblestone;
    }

    public String getTranslatedName() {
        return GuiLangKeys.translateString(this.name);
    }

    public BlockState getFullBlock() {
        switch (this.ordinal()) {
            case 10: {
                return Blocks.ACACIA_SLAB.defaultBlockState();
            }
            case 4: {
                return Blocks.POLISHED_ANDESITE_SLAB.defaultBlockState();
            }
            case 8: {
                return Blocks.BIRCH_SLAB.defaultBlockState();
            }
            case 1: {
                return Blocks.COBBLESTONE_SLAB.defaultBlockState();
            }
            case 11: {
                return Blocks.DARK_OAK_SLAB.defaultBlockState();
            }
            case 5: {
                return Blocks.POLISHED_DIORITE_SLAB.defaultBlockState();
            }
            case 3: {
                return Blocks.POLISHED_GRANITE_SLAB.defaultBlockState();
            }
            case 9: {
                return Blocks.JUNGLE_SLAB.defaultBlockState();
            }
            case 6: {
                return Blocks.OAK_SLAB.defaultBlockState();
            }
            case 7: {
                return Blocks.SPRUCE_SLAB.defaultBlockState();
            }
            case 2: {
                return Blocks.STONE_BRICK_SLAB.defaultBlockState();
            }
            case 0: {
                return Blocks.BRICK_SLAB.defaultBlockState();
            }
            case 12: {
                return Blocks.SANDSTONE_SLAB.defaultBlockState();
            }
            case 13: {
                return Blocks.RED_SANDSTONE_SLAB.defaultBlockState();
            }
        }
        return Blocks.STONE_SLAB.defaultBlockState();
    }
}

