/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.structures.base;

import com.prefab.ModRegistryBase;
import com.prefab.PrefabBase;
import com.prefab.Tuple;
import com.prefab.blocks.FullDyeColor;
import com.prefab.config.ModConfiguration;
import com.prefab.registries.StrictBuildingRegistry;
import com.prefab.structures.base.AllowedBlockReplacementResult;
import com.prefab.structures.base.ReplacementResultType;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;

public class BuildingMethods {
    public static ArrayList<ItemStack> ConsolidateDrops(ServerLevel world, BlockPos pos, BlockState state, ArrayList<ItemStack> originalStacks, ArrayList<Item> itemsToNotAdd) {
        for (ItemStack stack : Block.getDrops((BlockState)state, (ServerLevel)world, (BlockPos)pos, null)) {
            if (itemsToNotAdd != null && itemsToNotAdd.contains(stack.getItem())) continue;
            boolean foundStack = false;
            for (ItemStack existingStack : originalStacks) {
                if (!ItemStack.isSameItem((ItemStack)existingStack, (ItemStack)stack) || existingStack.getCount() + stack.getCount() > stack.getMaxStackSize()) continue;
                existingStack.setCount(existingStack.getCount() + stack.getCount());
                foundStack = true;
                break;
            }
            if (foundStack) continue;
            originalStacks.add(stack);
        }
        return originalStacks;
    }

    public static ArrayList<ItemStack> CreateWall(ServerLevel world, int height, int length, Direction direction, BlockPos startingPosition, Block replacementBlock, ArrayList<Item> itemsToNotAdd) {
        ArrayList<ItemStack> itemsDropped = new ArrayList<ItemStack>();
        BlockPos wallPos = null;
        for (int i = 0; i < height; ++i) {
            wallPos = startingPosition.above(i);
            for (int j = 0; j < length; ++j) {
                BlockState currentBlockPosState = world.getBlockState(wallPos);
                for (ItemStack stack : Block.getDrops((BlockState)currentBlockPosState, (ServerLevel)world, (BlockPos)wallPos, null)) {
                    if (itemsToNotAdd != null && itemsToNotAdd.contains(stack.getItem())) continue;
                    itemsDropped.add(stack);
                }
                BuildingMethods.ReplaceBlock((Level)world, wallPos, replacementBlock);
                wallPos = wallPos.relative(direction);
            }
        }
        return itemsDropped;
    }

    public static ArrayList<ItemStack> SetFloor(ServerLevel world, BlockPos pos, Block block, int width, int depth, ArrayList<ItemStack> originalStack, Direction facing, ArrayList<Item> itemsToNotAdd) {
        for (int i = 0; i < width; ++i) {
            originalStack.addAll(BuildingMethods.CreateWall(world, 1, depth, facing, pos, block, itemsToNotAdd));
            pos = pos.relative(facing.getClockWise());
        }
        return originalStack;
    }

    public static void ReplaceBlock(Level world, BlockPos pos, Block replacementBlock) {
        BuildingMethods.ReplaceBlock(world, pos, replacementBlock.defaultBlockState(), 3);
    }

    public static void ReplaceBlockNoAir(Level world, BlockPos pos, Block replacementBlock) {
        BuildingMethods.ReplaceBlockNoAir(world, pos, replacementBlock.defaultBlockState(), 3);
    }

    public static void ReplaceBlock(Level world, BlockPos pos, BlockState replacementBlockState) {
        BuildingMethods.ReplaceBlock(world, pos, replacementBlockState, 3);
    }

    public static void ReplaceBlock(Level world, BlockPos pos, BlockState replacementBlockState, int flags) {
        world.removeBlock(pos, false);
        world.setBlock(pos, replacementBlockState, flags);
    }

    public static void ReplaceBlockNoAir(Level world, BlockPos pos, BlockState replacementBlockState, int flags) {
        world.setBlock(pos, replacementBlockState, flags);
    }

    public static AllowedBlockReplacementResult CheckBuildSpaceForAllowedBlockReplacement(ServerLevel world, BlockPos startBlockPos, BlockPos endBlockPos, Player player) {
        if (!world.isClientSide) {
            StrictBuildingRegistry strictBuildingRegistry = ModRegistryBase.serverModRegistries.getStrictBuildingRegistry();
            for (BlockPos currentPos : BlockPos.betweenClosed((BlockPos)startBlockPos, (BlockPos)endBlockPos)) {
                BlockState blockState = world.getBlockState(currentPos);
                Block block = blockState.getBlock();
                String resourceLocation = BuiltInRegistries.BLOCK.getKey((Object)block).getPath().toLowerCase();
                if (world.getServer().isUnderSpawnProtection(world, currentPos, player)) {
                    return new AllowedBlockReplacementResult(ReplacementResultType.NOT_ALLOWED_SPAWN_PROTECTION, blockState, currentPos);
                }
                if (player.isCreative()) continue;
                if (!world.isEmptyBlock(currentPos) && !PrefabBase.eventCaller.canBreakBlock(world, player, world.getBlockState(currentPos), currentPos)) {
                    return new AllowedBlockReplacementResult(ReplacementResultType.NOT_ALLOWED_MOD_PROTECTED, blockState, currentPos);
                }
                if (blockState.getDestroySpeed((BlockGetter)world, currentPos) < 0.0f) {
                    return new AllowedBlockReplacementResult(ReplacementResultType.NOT_ALLOWED_UNBREAKABLE_BLOCK, blockState, currentPos);
                }
                if (!PrefabBase.serverConfiguration.strictModeOptions.enabled || player.hasPermissions(2) && PrefabBase.serverConfiguration.strictModeOptions.operatorsBypassRestrictions || !strictBuildingRegistry.getOverwritableBlockResourceLocations().stream().noneMatch(x -> x.getPath().equalsIgnoreCase(resourceLocation))) continue;
                return new AllowedBlockReplacementResult(ReplacementResultType.NOT_ALLOWED_STRICT_BUILDING_MODE, blockState, currentPos);
            }
        }
        return new AllowedBlockReplacementResult(ReplacementResultType.ALLOWED, null, null);
    }

    public static void PlaceColoredBed(Level world, BlockPos bedHeadPos, BlockPos bedFootPos, DyeColor bedColor) {
        Tuple<BlockState, BlockState> bedStates = BuildingMethods.getBedState(bedHeadPos, bedFootPos, bedColor);
        BuildingMethods.ReplaceBlock(world, bedHeadPos, bedStates.getFirst());
        BuildingMethods.ReplaceBlock(world, bedFootPos, bedStates.getSecond());
    }

    public static Tuple<BlockState, BlockState> getBedState(BlockPos bedHeadPos, BlockPos bedFootPos, DyeColor bedColor) {
        BlockState bedHead = null;
        BlockState bedFoot = null;
        switch (bedColor) {
            case BLACK: {
                bedHead = (BlockState)Blocks.BLACK_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD);
                bedFoot = (BlockState)Blocks.BLACK_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT);
                break;
            }
            case BLUE: {
                bedHead = (BlockState)Blocks.BLUE_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD);
                bedFoot = (BlockState)Blocks.BLUE_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT);
                break;
            }
            case BROWN: {
                bedHead = (BlockState)Blocks.BROWN_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD);
                bedFoot = (BlockState)Blocks.BROWN_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT);
                break;
            }
            case CYAN: {
                bedHead = (BlockState)Blocks.CYAN_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD);
                bedFoot = (BlockState)Blocks.CYAN_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT);
                break;
            }
            case GRAY: {
                bedHead = (BlockState)Blocks.GRAY_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD);
                bedFoot = (BlockState)Blocks.GRAY_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT);
                break;
            }
            case GREEN: {
                bedHead = (BlockState)Blocks.GREEN_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD);
                bedFoot = (BlockState)Blocks.GREEN_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT);
                break;
            }
            case LIGHT_BLUE: {
                bedHead = (BlockState)Blocks.LIGHT_BLUE_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD);
                bedFoot = (BlockState)Blocks.LIGHT_BLUE_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT);
                break;
            }
            case LIGHT_GRAY: {
                bedHead = (BlockState)Blocks.LIGHT_GRAY_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD);
                bedFoot = (BlockState)Blocks.LIGHT_GRAY_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT);
                break;
            }
            case LIME: {
                bedHead = (BlockState)Blocks.LIME_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD);
                bedFoot = (BlockState)Blocks.LIME_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT);
                break;
            }
            case MAGENTA: {
                bedHead = (BlockState)Blocks.MAGENTA_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD);
                bedFoot = (BlockState)Blocks.MAGENTA_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT);
                break;
            }
            case ORANGE: {
                bedHead = (BlockState)Blocks.ORANGE_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD);
                bedFoot = (BlockState)Blocks.ORANGE_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT);
                break;
            }
            case PINK: {
                bedHead = (BlockState)Blocks.PINK_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD);
                bedFoot = (BlockState)Blocks.PINK_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT);
                break;
            }
            case PURPLE: {
                bedHead = (BlockState)Blocks.PURPLE_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD);
                bedFoot = (BlockState)Blocks.PURPLE_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT);
                break;
            }
            case RED: {
                bedHead = (BlockState)Blocks.RED_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD);
                bedFoot = (BlockState)Blocks.RED_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT);
                break;
            }
            case WHITE: {
                bedHead = (BlockState)Blocks.WHITE_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD);
                bedFoot = (BlockState)Blocks.WHITE_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT);
                break;
            }
            case YELLOW: {
                bedHead = (BlockState)Blocks.YELLOW_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD);
                bedFoot = (BlockState)Blocks.YELLOW_BED.defaultBlockState().setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT);
            }
        }
        Direction direction = Direction.NORTH;
        BlockPos tempPos = bedHeadPos.relative(Direction.NORTH);
        while (tempPos.getX() != bedFootPos.getX() || tempPos.getZ() != bedFootPos.getZ()) {
            direction = direction.getClockWise();
            tempPos = bedHeadPos.relative(direction);
        }
        bedHead = (BlockState)bedHead.setValue((Property)BedBlock.FACING, (Comparable)direction.getOpposite());
        bedFoot = (BlockState)bedFoot.setValue((Property)BedBlock.FACING, (Comparable)direction.getOpposite());
        return new Tuple<BlockState, BlockState>(bedHead, bedFoot);
    }

    public static void FillChest(Level world, BlockPos itemPosition) {
        BlockEntity tileEntity = world.getBlockEntity(itemPosition);
        if (tileEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity chestTile = (RandomizableContainerBlockEntity)tileEntity;
            int itemSlot = 0;
            if (PrefabBase.serverConfiguration.chestOptions.addAxe) {
                chestTile.setItem(itemSlot++, new ItemStack((ItemLike)Items.STONE_AXE));
            }
            if (PrefabBase.serverConfiguration.chestOptions.addHoe) {
                chestTile.setItem(itemSlot++, new ItemStack((ItemLike)Items.STONE_HOE));
            }
            if (PrefabBase.serverConfiguration.chestOptions.addPickAxe) {
                chestTile.setItem(itemSlot++, new ItemStack((ItemLike)Items.STONE_PICKAXE));
            }
            if (PrefabBase.serverConfiguration.chestOptions.addShovel) {
                chestTile.setItem(itemSlot++, new ItemStack((ItemLike)Items.STONE_SHOVEL));
            }
            if (PrefabBase.serverConfiguration.chestOptions.addSword) {
                Item sword = ModRegistryBase.SwiftBladeStone;
                if (!PrefabBase.serverConfiguration.recipes.get(ModConfiguration.ConfigKeyNames.swiftBladeKey).booleanValue()) {
                    sword = Items.STONE_SWORD;
                }
                chestTile.setItem(itemSlot++, new ItemStack((ItemLike)sword));
            }
            if (PrefabBase.serverConfiguration.chestOptions.addArmor) {
                chestTile.setItem(itemSlot++, new ItemStack((ItemLike)Items.LEATHER_BOOTS));
                chestTile.setItem(itemSlot++, new ItemStack((ItemLike)Items.LEATHER_CHESTPLATE));
                chestTile.setItem(itemSlot++, new ItemStack((ItemLike)Items.LEATHER_HELMET));
                chestTile.setItem(itemSlot++, new ItemStack((ItemLike)Items.LEATHER_LEGGINGS));
            }
            if (PrefabBase.serverConfiguration.chestOptions.addFood) {
                chestTile.setItem(itemSlot++, new ItemStack((ItemLike)Items.BREAD, 20));
            }
            if (PrefabBase.serverConfiguration.chestOptions.addCrops) {
                chestTile.setItem(itemSlot++, new ItemStack((ItemLike)Items.POTATO, 3));
                chestTile.setItem(itemSlot++, new ItemStack((ItemLike)Items.CARROT, 3));
                chestTile.setItem(itemSlot++, new ItemStack((ItemLike)Items.WHEAT_SEEDS, 3));
            }
            if (PrefabBase.serverConfiguration.chestOptions.addCobble) {
                chestTile.setItem(itemSlot++, new ItemStack((ItemLike)Item.byBlock((Block)Blocks.COBBLESTONE), 64));
            }
            if (PrefabBase.serverConfiguration.chestOptions.addDirt) {
                chestTile.setItem(itemSlot++, new ItemStack((ItemLike)Item.byBlock((Block)Blocks.DIRT), 64));
            }
            if (PrefabBase.serverConfiguration.chestOptions.addSaplings) {
                chestTile.setItem(itemSlot++, new ItemStack((ItemLike)Item.byBlock((Block)Blocks.OAK_SAPLING), 3));
            }
            if (PrefabBase.serverConfiguration.chestOptions.addTorches) {
                chestTile.setItem(itemSlot++, new ItemStack((ItemLike)Item.byBlock((Block)Blocks.TORCH), 20));
            }
        }
    }

    public static void FillFurnaces(Level world, ArrayList<BlockPos> furnacePositions) {
        if (furnacePositions != null && furnacePositions.size() > 0) {
            for (BlockPos furnacePos : furnacePositions) {
                BlockEntity tileEntity = world.getBlockEntity(furnacePos);
                if (!(tileEntity instanceof FurnaceBlockEntity)) continue;
                FurnaceBlockEntity furnaceTile = (FurnaceBlockEntity)tileEntity;
                furnaceTile.setItem(1, new ItemStack((ItemLike)Items.COAL, 20));
            }
        }
    }

    public static void PlaceMineShaft(ServerLevel world, BlockPos pos, Direction facing, boolean onlyGatherOres) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ArrayList<Item> blocksToNotAdd = new ArrayList<Item>();
        if (onlyGatherOres) {
            blocksToNotAdd.add(Item.byBlock((Block)Blocks.SAND));
            blocksToNotAdd.add(Item.byBlock((Block)Blocks.SANDSTONE));
            blocksToNotAdd.add(Item.byBlock((Block)Blocks.COBBLESTONE));
            blocksToNotAdd.add(Item.byBlock((Block)Blocks.STONE));
            blocksToNotAdd.add(Item.byBlock((Block)Blocks.DIRT));
            blocksToNotAdd.add(Item.byBlock((Block)Blocks.GRANITE));
            blocksToNotAdd.add(Item.byBlock((Block)Blocks.ANDESITE));
            blocksToNotAdd.add(Item.byBlock((Block)Blocks.DIORITE));
            blocksToNotAdd.add(Item.byBlock((Block)Blocks.RED_SAND));
            blocksToNotAdd.add(Item.byBlock((Block)Blocks.RED_SANDSTONE));
            blocksToNotAdd.add(Item.byBlock((Block)Blocks.MOSSY_COBBLESTONE));
            blocksToNotAdd.add(Item.byBlock((Block)Blocks.MOSSY_STONE_BRICKS));
        }
        int minimumHeightForMineshaft = world.getMinBuildHeight() + 21;
        Tuple<ArrayList<ItemStack>, ArrayList<BlockPos>> ladderShaftResults = BuildingMethods.CreateLadderShaft(world, pos, stacks, facing, blocksToNotAdd, minimumHeightForMineshaft);
        stacks = ladderShaftResults.getFirst();
        ArrayList<BlockPos> torchPositions = ladderShaftResults.getSecond();
        pos = pos.below(pos.getY() - minimumHeightForMineshaft);
        ArrayList<ItemStack> tempStacks = new ArrayList<ItemStack>();
        BlockPos ceilingLevel = pos.above(4);
        tempStacks = BuildingMethods.SetFloor(world, ceilingLevel.relative(facing, 2).relative(facing.getClockWise(), 2).relative(facing.getOpposite()), Blocks.STONE, 4, 4, tempStacks, facing.getOpposite(), blocksToNotAdd);
        BuildingMethods.ReplaceBlock((Level)world, ceilingLevel, (BlockState)Blocks.LADDER.defaultBlockState().setValue((Property)LadderBlock.FACING, (Comparable)facing));
        BlockState torchState = Blocks.TORCH.defaultBlockState();
        for (BlockPos torchPos : torchPositions) {
            BlockState surroundingState = world.getBlockState(torchPos);
            Block surroundingBlock = surroundingState.getBlock();
            tempStacks = BuildingMethods.ConsolidateDrops(world, torchPos, surroundingState, tempStacks, blocksToNotAdd);
            BuildingMethods.ReplaceBlock((Level)world, torchPos, torchState);
        }
        tempStacks.addAll(BuildingMethods.SetFloor(world, pos.relative(facing).relative(facing.getClockWise()), Blocks.STONE, 3, 4, tempStacks, facing.getOpposite(), blocksToNotAdd));
        for (int i = 0; i < tempStacks.size(); ++i) {
            ItemStack stack = tempStacks.get(i);
            if (stack.getItem() != Item.byBlock((Block)Blocks.LADDER)) continue;
            tempStacks.remove(i);
            --i;
        }
        pos = pos.above();
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 3, facing.getClockWise(), pos.relative(facing.getOpposite(), 2).relative(facing.getCounterClockWise()), Blocks.AIR, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 3, facing.getClockWise(), pos.relative(facing.getOpposite(), 3).relative(facing.getCounterClockWise()), Blocks.STONE, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 4, facing, pos.relative(facing.getOpposite(), 2).relative(facing.getClockWise()), Blocks.AIR, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 4, facing, pos.relative(facing.getOpposite(), 2).relative(facing.getClockWise(), 2), Blocks.STONE, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 3, facing.getCounterClockWise(), pos.relative(facing).relative(facing.getClockWise()), Blocks.AIR, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 3, facing.getCounterClockWise(), pos.relative(facing, 2).relative(facing.getClockWise()), Blocks.STONE, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 4, facing.getOpposite(), pos.relative(facing).relative(facing.getCounterClockWise()), Blocks.AIR, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 4, facing.getOpposite(), pos.relative(facing, 1).relative(facing.getCounterClockWise(), 2), Blocks.STONE, blocksToNotAdd));
        for (ItemStack tempStack : tempStacks) {
            boolean foundStack = false;
            for (ItemStack existingStack : stacks) {
                if (!ItemStack.isSameItem((ItemStack)existingStack, (ItemStack)tempStack) || existingStack.getCount() + tempStack.getCount() > tempStack.getMaxStackSize()) continue;
                existingStack.setCount(existingStack.getCount() + tempStack.getCount());
                foundStack = true;
                break;
            }
            if (foundStack) continue;
            stacks.add(tempStack);
        }
        BlockState blockState = Blocks.TORCH.defaultBlockState();
        BuildingMethods.ReplaceBlock((Level)world, pos.relative(facing.getCounterClockWise()), blockState);
        if (PrefabBase.serverConfiguration.includeMineshaftChest) {
            BlockState chestState = (BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)facing);
            BuildingMethods.ReplaceBlock((Level)world, pos.relative(facing.getClockWise()), chestState);
            if (stacks.size() > 27) {
                BuildingMethods.ReplaceBlock((Level)world, pos.relative(facing.getClockWise()).relative(facing.getOpposite()), chestState);
            }
            BlockEntity tileEntity = world.getBlockEntity(pos.relative(facing.getClockWise()));
            BlockEntity tileEntity2 = world.getBlockEntity(pos.relative(facing.getClockWise()).relative(facing.getOpposite()));
            if (tileEntity instanceof ChestBlockEntity) {
                ChestBlockEntity chestTile = (ChestBlockEntity)tileEntity;
                ChestBlockEntity chestTile2 = (ChestBlockEntity)tileEntity2;
                int i = 0;
                boolean fillSecond = false;
                for (ItemStack stack : stacks) {
                    if (i == 27 && !fillSecond) {
                        fillSecond = true;
                        i = 0;
                        chestTile = chestTile2;
                    }
                    if (i >= 27 && fillSecond) break;
                    chestTile.setItem(i, stack);
                    ++i;
                }
            }
        }
    }

    private static Tuple<ArrayList<ItemStack>, ArrayList<BlockPos>> CreateLadderShaft(ServerLevel world, BlockPos pos, ArrayList<ItemStack> originalStacks, Direction houseFacing, ArrayList<Item> blocksToNotAdd, int minimumHeightForMineshaft) {
        int torchCounter = 0;
        Direction westWall = houseFacing.getCounterClockWise();
        BlockState ladderState = (BlockState)Blocks.LADDER.defaultBlockState().setValue((Property)LadderBlock.FACING, (Comparable)houseFacing);
        BuildingMethods.ReplaceBlock((Level)world, pos, Blocks.AIR);
        ArrayList<BlockPos> torchPositions = new ArrayList<BlockPos>();
        int lastHeightForTorch = minimumHeightForMineshaft + 6;
        while (pos.getY() > minimumHeightForMineshaft) {
            BlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            ++torchCounter;
            for (int i = 0; i < 4; ++i) {
                Direction facing = houseFacing;
                switch (i) {
                    case 1: {
                        facing = houseFacing.getClockWise();
                        break;
                    }
                    case 2: {
                        facing = houseFacing.getOpposite();
                        break;
                    }
                    case 3: {
                        facing = houseFacing.getCounterClockWise();
                    }
                }
                if (facing == westWall && torchCounter == 6 && pos.getY() > lastHeightForTorch) {
                    for (int j = 0; j <= 2; ++j) {
                        BlockPos tempPos = null;
                        BlockState surroundingState = null;
                        Block surroundingBlock = null;
                        if (j == 0) {
                            tempPos = pos.relative(facing, 2);
                            surroundingState = world.getBlockState(tempPos);
                            surroundingBlock = surroundingState.getBlock();
                        } else if (j == 1) {
                            tempPos = pos.relative(facing).relative(facing.getClockWise());
                            surroundingState = world.getBlockState(tempPos);
                            surroundingBlock = surroundingState.getBlock();
                        } else {
                            tempPos = pos.relative(facing).relative(facing.getCounterClockWise());
                            surroundingState = world.getBlockState(tempPos);
                            surroundingBlock = surroundingState.getBlock();
                        }
                        if (surroundingBlock == Blocks.STONE || surroundingBlock == Blocks.ANDESITE || surroundingBlock == Blocks.DIORITE || surroundingBlock == Blocks.GRANITE) continue;
                        originalStacks = BuildingMethods.ConsolidateDrops(world, tempPos, surroundingState, originalStacks, blocksToNotAdd);
                        BuildingMethods.ReplaceBlock((Level)world, tempPos, Blocks.STONE);
                    }
                    torchPositions.add(pos.relative(facing));
                    torchCounter = 0;
                    continue;
                }
                BlockPos tempPos = pos.relative(facing);
                BlockState surroundingState = world.getBlockState(tempPos);
                Block surroundingBlock = surroundingState.getBlock();
                if (surroundingState.isRedstoneConductor((BlockGetter)world, tempPos) && !(surroundingBlock instanceof LiquidBlock)) continue;
                originalStacks = BuildingMethods.ConsolidateDrops(world, tempPos, surroundingState, originalStacks, blocksToNotAdd);
                BuildingMethods.ReplaceBlock((Level)world, tempPos, Blocks.STONE);
            }
            originalStacks = BuildingMethods.ConsolidateDrops(world, pos, state, originalStacks, blocksToNotAdd);
            if (pos.getY() >= minimumHeightForMineshaft) {
                BuildingMethods.ReplaceBlock((Level)world, pos, ladderState);
            }
            pos = pos.below();
        }
        return new Tuple<ArrayList<ItemStack>, ArrayList<BlockPos>>(originalStacks, torchPositions);
    }

    public static BlockState getStainedGlassBlock(FullDyeColor color) {
        switch (color) {
            case BLACK: {
                return Blocks.BLACK_STAINED_GLASS.defaultBlockState();
            }
            case BLUE: {
                return Blocks.BLUE_STAINED_GLASS.defaultBlockState();
            }
            case BROWN: {
                return Blocks.BROWN_STAINED_GLASS.defaultBlockState();
            }
            case GRAY: {
                return Blocks.GRAY_STAINED_GLASS.defaultBlockState();
            }
            case GREEN: {
                return Blocks.GREEN_STAINED_GLASS.defaultBlockState();
            }
            case LIGHT_BLUE: {
                return Blocks.LIGHT_BLUE_STAINED_GLASS.defaultBlockState();
            }
            case LIGHT_GRAY: {
                return Blocks.LIGHT_GRAY_STAINED_GLASS.defaultBlockState();
            }
            case LIME: {
                return Blocks.LIME_STAINED_GLASS.defaultBlockState();
            }
            case MAGENTA: {
                return Blocks.MAGENTA_STAINED_GLASS.defaultBlockState();
            }
            case ORANGE: {
                return Blocks.ORANGE_STAINED_GLASS.defaultBlockState();
            }
            case PINK: {
                return Blocks.PINK_STAINED_GLASS.defaultBlockState();
            }
            case PURPLE: {
                return Blocks.PURPLE_STAINED_GLASS.defaultBlockState();
            }
            case RED: {
                return Blocks.RED_STAINED_GLASS.defaultBlockState();
            }
            case WHITE: {
                return Blocks.WHITE_STAINED_GLASS.defaultBlockState();
            }
            case YELLOW: {
                return Blocks.YELLOW_STAINED_GLASS.defaultBlockState();
            }
            case CLEAR: {
                return Blocks.GLASS.defaultBlockState();
            }
        }
        return Blocks.CYAN_STAINED_GLASS.defaultBlockState();
    }

    public static BlockState getStainedGlassPaneBlock(FullDyeColor color) {
        switch (color) {
            case BLACK: {
                return Blocks.BLACK_STAINED_GLASS_PANE.defaultBlockState();
            }
            case BLUE: {
                return Blocks.BLUE_STAINED_GLASS_PANE.defaultBlockState();
            }
            case BROWN: {
                return Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState();
            }
            case GRAY: {
                return Blocks.GRAY_STAINED_GLASS_PANE.defaultBlockState();
            }
            case GREEN: {
                return Blocks.GREEN_STAINED_GLASS_PANE.defaultBlockState();
            }
            case LIGHT_BLUE: {
                return Blocks.LIGHT_BLUE_STAINED_GLASS_PANE.defaultBlockState();
            }
            case LIGHT_GRAY: {
                return Blocks.LIGHT_GRAY_STAINED_GLASS_PANE.defaultBlockState();
            }
            case LIME: {
                return Blocks.LIME_STAINED_GLASS_PANE.defaultBlockState();
            }
            case MAGENTA: {
                return Blocks.MAGENTA_STAINED_GLASS_PANE.defaultBlockState();
            }
            case ORANGE: {
                return Blocks.ORANGE_STAINED_GLASS_PANE.defaultBlockState();
            }
            case PINK: {
                return Blocks.PINK_STAINED_GLASS_PANE.defaultBlockState();
            }
            case PURPLE: {
                return Blocks.PURPLE_STAINED_GLASS_PANE.defaultBlockState();
            }
            case RED: {
                return Blocks.RED_STAINED_GLASS_PANE.defaultBlockState();
            }
            case WHITE: {
                return Blocks.WHITE_STAINED_GLASS_PANE.defaultBlockState();
            }
            case YELLOW: {
                return Blocks.YELLOW_STAINED_GLASS_PANE.defaultBlockState();
            }
            case CLEAR: {
                return Blocks.GLASS_PANE.defaultBlockState();
            }
        }
        return Blocks.CYAN_STAINED_GLASS_PANE.defaultBlockState();
    }
}

