/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.structures.base;

import com.google.gson.annotations.Expose;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.prefab.PrefabBase;
import com.prefab.Utils;
import com.prefab.structures.base.BuildProperty;
import com.prefab.structures.base.PositionOffset;
import com.prefab.structures.base.Structure;
import com.prefab.structures.config.StructureConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class BuildBlock {
    public BlockPos blockPos;
    public Vec3 centerOfBlock;
    @Expose
    private String blockDomain;
    @Expose
    private String blockName;
    @Expose
    private PositionOffset startingPosition;
    @Expose
    private ArrayList<BuildProperty> properties;
    @Expose
    private BuildBlock subBlock;
    @Expose
    private boolean hasFacing;
    @Expose
    private BlockState state;
    @Expose
    private String blockStateData;

    public BuildBlock() {
        this.Initialize();
    }

    public static BuildBlock SetBlockState(StructureConfiguration configuration, Level world, BlockPos originalPos, BuildBlock block, Block foundBlock, BlockState blockState, Structure structure) {
        try {
            if (!block.blockStateData.equals("")) {
                return BuildBlock.SetBlockStateFromTagData(configuration, world, originalPos, block, foundBlock, blockState, structure);
            }
            Direction vineFacing = BuildBlock.getVineFacing(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            Direction.Axis logFacing = BuildBlock.getBoneFacing(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            Direction.Axis boneFacing = BuildBlock.getBoneFacing(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            Direction leverOrientation = BuildBlock.getLeverOrientation(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            Map<Direction, Boolean> fourWayFacings = BuildBlock.getFourWayBlockFacings(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            Map<Direction, WallSide> wallShapes = BuildBlock.getWallFacings(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            if (block.getProperties().size() > 0) {
                Collection properties = blockState.getProperties();
                for (Property property : properties) {
                    BuildProperty buildProperty = block.getProperty(property.getName());
                    if (buildProperty == null) continue;
                    try {
                        Optional propertyValue = property.getValue(buildProperty.getValue());
                        if (!propertyValue.isPresent() || propertyValue.getClass().getName().equals("com.google.common.base.Absent")) {
                            PrefabBase.logger.warn("Property value for property name [" + property.getName() + "] for block [" + block.getBlockName() + "] is considered Absent, figure out why.");
                            continue;
                        }
                        Comparable comparable = (Comparable)property.getValueClass().cast(propertyValue.get());
                        if ((comparable = BuildBlock.setComparable(comparable, foundBlock, property, configuration, block, propertyValue, vineFacing, logFacing, boneFacing, leverOrientation, structure, fourWayFacings, wallShapes)) == null) continue;
                        try {
                            if (blockState.getValue(property) == comparable) continue;
                            blockState = BuildBlock.setProperty(blockState, property, comparable);
                        }
                        catch (Exception ex) {
                            System.out.println("Error setting properly value for property name [" + property.getName() + "] property value [" + buildProperty.getValue() + "] for block [" + block.getBlockName() + "] The default value will be used.");
                        }
                    }
                    catch (Exception ex) {
                        System.out.println("Error getting properly value for property name [" + property.getName() + "] property value [" + buildProperty.getValue() + "] for block [" + block.getBlockName() + "]");
                        throw ex;
                    }
                }
            }
            block.setBlockState(blockState);
            return block;
        }
        catch (Exception ex) {
            System.out.println("Error setting block state for block [" + block.getBlockName() + "] for structure configuration class [" + configuration.getClass().getName() + "]");
            throw ex;
        }
    }

    private static boolean neighborHaveWater(BlockPos originalPos, Level world) {
        boolean returnValue = false;
        for (Direction direction : Direction.values()) {
            FluidState fluidState;
            if (direction == Direction.DOWN || !(fluidState = world.getFluidState(originalPos.relative(direction))).is(FluidTags.WATER) || fluidState.getAmount() != 8) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    public static Direction getHorizontalFacing(Direction currentFacing, Direction configurationFacing, Direction structureDirection) {
        if (currentFacing != null && currentFacing != Direction.UP && currentFacing != Direction.DOWN) {
            if (configurationFacing.getOpposite() == structureDirection.getClockWise()) {
                currentFacing = currentFacing.getClockWise();
            } else if (configurationFacing.getOpposite() == structureDirection.getOpposite()) {
                currentFacing = currentFacing.getOpposite();
            } else if (configurationFacing.getOpposite() == structureDirection.getCounterClockWise()) {
                currentFacing = currentFacing.getCounterClockWise();
            }
        }
        return currentFacing;
    }

    private static Comparable setComparable(Comparable<?> comparable, Block foundBlock, Property<?> property, StructureConfiguration configuration, BuildBlock block, Optional<?> propertyValue, Direction vineFacing, Direction.Axis logFacing, Direction.Axis boneFacing, Direction leverOrientation, Structure structure, Map<Direction, Boolean> fourWayFacings, Map<Direction, WallSide> wallShapes) {
        if (property.getName().equals("facing") && foundBlock instanceof FaceAttachedHorizontalDirectionalBlock) {
            comparable = leverOrientation;
            block.setHasFacing(true);
        } else if (property.getName().equals("facing")) {
            Direction facing = BuildBlock.getDirectionByName(propertyValue.get().toString());
            comparable = facing = BuildBlock.getHorizontalFacing(facing, configuration.houseFacing, structure.getClearSpace().getShape().getDirection());
            block.setHasFacing(true);
        } else if (property.getName().equals("rotation")) {
            Direction facing;
            int rotation = (Integer)propertyValue.get();
            Direction direction = rotation == 0 ? Direction.SOUTH : (rotation == 4 ? Direction.WEST : (facing = rotation == 8 ? Direction.NORTH : Direction.EAST));
            if (configuration.houseFacing.getOpposite() == structure.getClearSpace().getShape().getDirection().getClockWise()) {
                facing = facing.getClockWise();
            } else if (configuration.houseFacing.getOpposite() == structure.getClearSpace().getShape().getDirection().getOpposite()) {
                facing = facing.getOpposite();
            } else if (configuration.houseFacing.getOpposite() == structure.getClearSpace().getShape().getDirection().getCounterClockWise()) {
                facing = facing.getCounterClockWise();
            }
            rotation = facing == Direction.SOUTH ? 0 : (facing == Direction.WEST ? 4 : (facing == Direction.NORTH ? 8 : 12));
            comparable = rotation;
            block.setHasFacing(true);
        } else if (foundBlock instanceof VineBlock) {
            if (property.getName().equals(vineFacing.getName())) {
                comparable = true;
                block.setHasFacing(true);
            } else {
                comparable = false;
            }
        } else if (foundBlock instanceof CrossCollisionBlock && !property.getName().equals("waterlogged")) {
            for (Map.Entry<Direction, Boolean> entry : fourWayFacings.entrySet()) {
                if (!property.getName().equals(entry.getKey().getName())) continue;
                comparable = entry.getValue();
            }
        } else if (foundBlock instanceof WallBlock && !property.getName().equals("waterlogged")) {
            for (Map.Entry<Direction, WallSide> entry : wallShapes.entrySet()) {
                if (!property.getName().equals(entry.getKey().getName())) continue;
                comparable = (Comparable)entry.getValue();
            }
        } else if (foundBlock instanceof RotatedPillarBlock && property.getName().equals("axis")) {
            comparable = boneFacing;
        }
        return comparable;
    }

    private static Direction getVineFacing(StructureConfiguration configuration, Block foundBlock, BuildBlock block, Direction assumedNorth) {
        Direction vineFacing = Direction.UP;
        if (foundBlock instanceof VineBlock || foundBlock instanceof WallBlock) {
            if (block.getProperty("east").getValue().equals("true")) {
                vineFacing = Direction.EAST;
            } else if (block.getProperty("west").getValue().equals("true")) {
                vineFacing = Direction.WEST;
            } else if (block.getProperty("south").getValue().equals("true")) {
                vineFacing = Direction.SOUTH;
            } else if (block.getProperty("north").getValue().equals("true")) {
                vineFacing = Direction.NORTH;
            }
            if (vineFacing != Direction.UP) {
                if (configuration.houseFacing.getClockWise() == assumedNorth) {
                    vineFacing = vineFacing.getClockWise();
                } else if (configuration.houseFacing.getOpposite() != assumedNorth) {
                    vineFacing = configuration.houseFacing.getCounterClockWise() == assumedNorth ? vineFacing.getCounterClockWise() : vineFacing.getOpposite();
                }
            }
        }
        return vineFacing;
    }

    private static Map<Direction, WallSide> getWallFacings(StructureConfiguration configuration, Block foundBlock, BuildBlock block, Direction assumedNorth) {
        HashMap<Direction, WallSide> facings = new HashMap<Direction, WallSide>();
        if (foundBlock instanceof WallBlock) {
            WallSide northValue = BuildBlock.getShapeByName(block.getProperty("north").getValue());
            WallSide eastValue = BuildBlock.getShapeByName(block.getProperty("east").getValue());
            WallSide westValue = BuildBlock.getShapeByName(block.getProperty("west").getValue());
            WallSide southValue = BuildBlock.getShapeByName(block.getProperty("south").getValue());
            WallSide originalNorth = northValue;
            WallSide originalEast = eastValue;
            WallSide originalWest = westValue;
            WallSide originalSouth = southValue;
            if (configuration.houseFacing.getClockWise() == assumedNorth) {
                northValue = originalWest;
                eastValue = originalNorth;
                southValue = originalEast;
                westValue = originalSouth;
            } else if (configuration.houseFacing == assumedNorth) {
                northValue = originalSouth;
                eastValue = originalWest;
                southValue = originalNorth;
                westValue = originalEast;
            } else if (configuration.houseFacing.getCounterClockWise() == assumedNorth) {
                northValue = originalEast;
                eastValue = originalSouth;
                southValue = originalWest;
                westValue = originalNorth;
            }
            facings.put(Direction.NORTH, northValue);
            facings.put(Direction.EAST, eastValue);
            facings.put(Direction.WEST, westValue);
            facings.put(Direction.SOUTH, southValue);
        }
        return facings;
    }

    private static Map<Direction, Boolean> getFourWayBlockFacings(StructureConfiguration configuration, Block foundBlock, BuildBlock block, Direction assumedNorth) {
        HashMap<Direction, Boolean> facings = new HashMap<Direction, Boolean>();
        if (foundBlock instanceof CrossCollisionBlock) {
            boolean northValue = Boolean.parseBoolean(block.getProperty("north").getValue());
            boolean eastValue = Boolean.parseBoolean(block.getProperty("east").getValue());
            boolean westValue = Boolean.parseBoolean(block.getProperty("west").getValue());
            boolean southValue = Boolean.parseBoolean(block.getProperty("south").getValue());
            boolean originalNorth = northValue;
            boolean originalEast = eastValue;
            boolean originalWest = westValue;
            boolean originalSouth = southValue;
            if (configuration.houseFacing.getClockWise() == assumedNorth) {
                northValue = originalWest;
                eastValue = originalNorth;
                southValue = originalEast;
                westValue = originalSouth;
            } else if (configuration.houseFacing == assumedNorth) {
                northValue = originalSouth;
                eastValue = originalWest;
                southValue = originalNorth;
                westValue = originalEast;
            } else if (configuration.houseFacing.getCounterClockWise() == assumedNorth) {
                northValue = originalEast;
                eastValue = originalSouth;
                southValue = originalWest;
                westValue = originalNorth;
            }
            facings.put(Direction.NORTH, northValue);
            facings.put(Direction.EAST, eastValue);
            facings.put(Direction.WEST, westValue);
            facings.put(Direction.SOUTH, southValue);
        }
        return facings;
    }

    private static Direction.Axis getBoneFacing(StructureConfiguration configuration, Block foundBlock, BuildBlock block, Direction assumedNorth) {
        BuildProperty property;
        Direction.Axis boneFacing = Direction.Axis.X;
        if (foundBlock instanceof RotatedPillarBlock && (property = block.getProperty("axis")) != null) {
            if (!property.getValue().equals("x")) {
                boneFacing = property.getValue().equals("y") ? Direction.Axis.Y : Direction.Axis.Z;
            }
            if (boneFacing != Direction.Axis.Y) {
                boneFacing = configuration.houseFacing == assumedNorth || configuration.houseFacing == assumedNorth.getOpposite() ? boneFacing : (boneFacing == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X);
            }
        }
        return boneFacing;
    }

    private static Direction getLeverOrientation(StructureConfiguration configuration, Block foundBlock, BuildBlock block, Direction assumedNorth) {
        Direction leverOrientation = Direction.NORTH;
        AttachFace attachedTo = AttachFace.FLOOR;
        if (foundBlock instanceof FaceAttachedHorizontalDirectionalBlock) {
            leverOrientation = (Direction)LeverBlock.FACING.getValue(block.getProperty("facing").getValue()).get();
            attachedTo = (AttachFace)LeverBlock.FACE.getValue(block.getProperty("face").getValue()).get();
            if (attachedTo == AttachFace.FLOOR || attachedTo == AttachFace.CEILING) {
                leverOrientation = attachedTo == AttachFace.FLOOR ? (configuration.houseFacing == assumedNorth || configuration.houseFacing == assumedNorth.getOpposite() ? leverOrientation : (leverOrientation == Direction.NORTH ? Direction.EAST : Direction.NORTH)) : (configuration.houseFacing == assumedNorth || configuration.houseFacing == assumedNorth.getOpposite() ? leverOrientation : (leverOrientation == Direction.NORTH ? Direction.EAST : Direction.NORTH));
            } else {
                Direction facing = leverOrientation;
                if (configuration.houseFacing.getClockWise() == assumedNorth) {
                    facing = facing.getClockWise();
                } else if (configuration.houseFacing.getOpposite() != assumedNorth) {
                    facing = configuration.houseFacing.getCounterClockWise() == assumedNorth ? facing.getCounterClockWise() : facing.getOpposite();
                }
                for (Direction tempOrientation : Direction.values()) {
                    if (tempOrientation != facing) continue;
                    leverOrientation = tempOrientation;
                    break;
                }
            }
        }
        return leverOrientation;
    }

    private static BlockState setProperty(BlockState state, Property property, Comparable comparable) {
        return (BlockState)state.setValue(property, comparable);
    }

    private static BuildBlock SetBlockStateFromTagData(StructureConfiguration configuration, Level world, BlockPos originalPos, BuildBlock block, Block foundBlock, BlockState blockState, Structure structure) {
        BlockState tagState = block.getBlockStateFromDataTag();
        if (tagState == null) {
            block.setBlockStateData("");
            return BuildBlock.SetBlockState(configuration, world, originalPos, block, foundBlock, blockState, structure);
        }
        block.setBlockState(block.getBlockStateFromDataTag());
        return block;
    }

    public static Direction getDirectionByName(String name) {
        for (Direction direction : Direction.values()) {
            if (!direction.getName().equalsIgnoreCase(name)) continue;
            return direction;
        }
        return Direction.NORTH;
    }

    public static WallSide getShapeByName(String name) {
        for (WallSide shape : WallSide.values()) {
            if (!shape.toString().equalsIgnoreCase(name)) continue;
            return shape;
        }
        return WallSide.NONE;
    }

    public String getBlockDomain() {
        return this.blockDomain;
    }

    public void setBlockDomain(String value) {
        this.blockDomain = value;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public void setBlockName(String value) {
        this.blockName = value;
    }

    public ResourceLocation getResourceLocation() {
        return ResourceLocation.tryBuild((String)this.blockDomain, (String)this.blockName);
    }

    public PositionOffset getStartingPosition() {
        return this.startingPosition;
    }

    public void setStartingPosition(PositionOffset value) {
        this.startingPosition = value;
    }

    public ArrayList<BuildProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(ArrayList<BuildProperty> value) {
        this.properties = value;
    }

    public BuildProperty getProperty(String name) {
        for (BuildProperty property : this.getProperties()) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public BuildBlock getSubBlock() {
        return this.subBlock;
    }

    public void setSubBlock(BuildBlock value) {
        this.subBlock = value;
    }

    public boolean getHasFacing() {
        return this.hasFacing;
    }

    public void setHasFacing(boolean value) {
        this.hasFacing = value;
    }

    public BlockState getBlockState() {
        return this.state;
    }

    public void setBlockState(BlockState value) {
        this.state = value;
    }

    public String getBlockStateData() {
        return this.blockStateData;
    }

    public void setBlockStateData(String value) {
        this.blockStateData = value;
    }

    public void setBlockStateData(CompoundTag tagCompound) {
        this.blockStateData = tagCompound.toString();
    }

    public CompoundTag getBlockStateDataTag() {
        CompoundTag tag = null;
        if (!this.blockStateData.equals("")) {
            try {
                tag = TagParser.parseTag((String)this.blockStateData);
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        return tag;
    }

    public BlockState getBlockStateFromDataTag() {
        CompoundTag tag;
        BlockState state = null;
        if (!this.blockStateData.equals("") && (tag = this.getBlockStateDataTag()) != null) {
            state = Utils.readBlockState(tag.getCompound("tag"));
        }
        return state;
    }

    public void Initialize() {
        this.blockDomain = "";
        this.blockName = "";
        this.properties = new ArrayList();
        this.hasFacing = false;
        this.state = null;
        this.subBlock = null;
        this.startingPosition = new PositionOffset();
        this.blockStateData = "";
    }
}

