/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.registries;

import com.prefab.PrefabBase;
import com.prefab.Utils;
import com.prefab.config.ModConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Collector;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class StrictBuildingRegistry {
    private final ArrayList<ResourceLocation> overwritableBlockResourceLocations = new ArrayList();
    private final ArrayList<Block> overwritableBlocks = new ArrayList();

    public ArrayList<ResourceLocation> getOverwritableBlockResourceLocations() {
        return this.overwritableBlockResourceLocations;
    }

    public ArrayList<Block> getOverwritableBlocks() {
        return this.overwritableBlocks;
    }

    public void processModConfiguration(ModConfiguration modConfiguration) {
        if (modConfiguration.strictModeOptions.enabled) {
            this.addStandardBlocks();
            this.processBlocks(modConfiguration);
            this.processTags(modConfiguration);
        }
    }

    private void addStandardBlocks() {
        this.overwritableBlocks.add(Blocks.AIR);
        this.overwritableBlockResourceLocations.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.AIR));
        this.overwritableBlocks.add(Blocks.WATER);
        this.overwritableBlockResourceLocations.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.WATER));
        this.overwritableBlocks.add(Blocks.LAVA);
        this.overwritableBlockResourceLocations.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.LAVA));
    }

    private void processBlocks(ModConfiguration modConfiguration) {
        ArrayList<ResourceLocation> resourceLocations = this.processStringCollection(modConfiguration.strictModeOptions.overwritableBlocks);
        HashMap<String, ResourceLocation> validBlockKeys = new HashMap<String, ResourceLocation>();
        HashMap<String, Block> validBlocks = new HashMap<String, Block>();
        for (ResourceLocation resourceLocation : resourceLocations) {
            if (validBlockKeys.containsKey(resourceLocation.getPath())) continue;
            Optional foundBlock = BuiltInRegistries.BLOCK.getOptional(resourceLocation);
            if (foundBlock.isPresent()) {
                validBlockKeys.put(resourceLocation.getPath(), resourceLocation);
                validBlocks.put(resourceLocation.getPath(), (Block)foundBlock.get());
                continue;
            }
            PrefabBase.logger.warn("Strict Building Mode Processing: The resource location: \"{}\" is not a valid block.\r\nPlease check your spelling or if you have a missing mod.\r\nResource locations are case-insensitive.", (Object)resourceLocation.getPath().toLowerCase());
        }
        this.overwritableBlockResourceLocations.addAll(validBlockKeys.values());
        this.overwritableBlocks.addAll(validBlocks.values());
    }

    private void processTags(ModConfiguration modConfiguration) {
        ArrayList<ResourceLocation> tags = this.processStringCollection(modConfiguration.strictModeOptions.overwritableTags);
        if (!tags.isEmpty()) {
            HashMap registeredTags = BuiltInRegistries.BLOCK.getTagNames().collect(Collector.of(HashMap::new, (map, tag) -> {
                if (!map.containsKey(tag.location().getPath().toLowerCase())) {
                    map.put(tag.location().getPath().toLowerCase(), tag);
                }
            }, (map1, map2) -> {
                map1.putAll(map2);
                return map1;
            }, Collector.Characteristics.IDENTITY_FINISH));
            ArrayList<Block> allValidTagBlocks = new ArrayList<Block>();
            for (ResourceLocation tag2 : tags) {
                TagKey registeredTag = (TagKey)registeredTags.get(tag2.getPath().toLowerCase());
                if (registeredTag == null) {
                    PrefabBase.logger.warn("Strict Building Mode Processing: Unable to find tag with resource location: {}.\r\nPlease check your spelling or if you have a missing mod.\r\nResource locations are case-insensitive.\r\nBuilt-in tags should have a root of \"minecraft\". Example: minecraft:leaves", (Object)tag2.getPath().toLowerCase());
                    continue;
                }
                ArrayList<Block> blocks = Utils.getBlocksWithTagKey((TagKey<Block>)registeredTag);
                if (blocks.isEmpty()) {
                    PrefabBase.logger.info("Strict Building Mod Processing: There are no blocks registered with tag's resource location: {}\r\nIf this is unexpected, you may be missing a mod which adds blocks to this tag.\r\nResource locations are case-insensitive.", (Object)tag2.getPath().toLowerCase());
                    continue;
                }
                allValidTagBlocks.addAll(blocks);
            }
            ArrayList<ResourceLocation> blockKeys = new ArrayList<ResourceLocation>();
            for (int i = 0; i < allValidTagBlocks.size(); ++i) {
                Block block = (Block)allValidTagBlocks.get(i);
                ResourceLocation blockKey = BuiltInRegistries.BLOCK.getKey((Object)block);
                Optional<ResourceLocation> matchingResourceLocations = this.getOverwritableBlockResourceLocations().stream().filter(x -> x.getPath().equalsIgnoreCase(blockKey.getPath())).findFirst();
                if (matchingResourceLocations.isEmpty()) {
                    blockKeys.add(blockKey);
                    continue;
                }
                allValidTagBlocks.remove(i);
                --i;
            }
            this.overwritableBlockResourceLocations.addAll(blockKeys);
            this.overwritableBlocks.addAll(allValidTagBlocks);
        }
    }

    private ArrayList<ResourceLocation> processStringCollection(@NotNull ArrayList<String> collection) {
        ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>();
        for (String value : collection) {
            ResourceLocation resourceLocation;
            if (StringUtils.isBlank((CharSequence)value) || (resourceLocation = ResourceLocation.tryParse((String)value)) == null) continue;
            resourceLocations.add(resourceLocation);
        }
        return resourceLocations;
    }
}

