/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.registries;

import com.prefab.ModRegistryBase;
import com.prefab.Tuple;
import com.prefab.blocks.BlockDarkLamp;
import com.prefab.blocks.BlockLightSwitch;
import com.prefab.registries.ILevelBasedRegistry;
import java.util.Vector;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LightSwitchRegistry
extends ILevelBasedRegistry<BlockPos> {
    private static final int SearchBlockRadius = 24;

    @Override
    protected void onElementRemoved(Level level, BlockPos element) {
        this.setNearbyLights(element, level, false);
    }

    @Override
    protected void onElementRegistered(Level level, BlockPos element) {
    }

    public void flipSwitch(Level level, BlockPos incomingBlockPos, boolean turnOn) {
        Vector blockPositions;
        if (!level.isClientSide && this.internalRegistry.containsKey(level) && (blockPositions = (Vector)this.internalRegistry.get(level)) != null) {
            for (BlockPos blockPos : blockPositions) {
                if (blockPos.hashCode() != incomingBlockPos.hashCode()) continue;
                this.setNearbyLights(blockPos, level, turnOn);
                break;
            }
        }
    }

    public boolean checkForNearbyOnSwitch(Level level, BlockPos blockPos) {
        Tuple<BlockPos, BlockPos> searchPositions = this.getSearchStartAndEnd(blockPos);
        for (BlockPos worldPos : BlockPos.betweenClosed((BlockPos)searchPositions.getFirst(), (BlockPos)searchPositions.getSecond())) {
            BlockState blockState = level.getBlockState(worldPos);
            if (blockState.getBlock() != ModRegistryBase.LightSwitch) continue;
            return (Boolean)blockState.getValue((Property)BlockLightSwitch.POWERED);
        }
        return false;
    }

    private void setNearbyLights(BlockPos blockPos, Level level, boolean turnOn) {
        Tuple<BlockPos, BlockPos> searchPositions = this.getSearchStartAndEnd(blockPos);
        for (BlockPos worldPos : BlockPos.betweenClosed((BlockPos)searchPositions.getFirst(), (BlockPos)searchPositions.getSecond())) {
            BlockState blockState = level.getBlockState(worldPos);
            if (blockState.getBlock() != ModRegistryBase.DarkLamp) continue;
            blockState = (BlockState)blockState.setValue((Property)BlockDarkLamp.LIT, (Comparable)Boolean.valueOf(turnOn));
            level.setBlock(worldPos, blockState, 3);
        }
    }

    private Tuple<BlockPos, BlockPos> getSearchStartAndEnd(BlockPos startingPos) {
        BlockPos startPos = startingPos.below(24).south(24).west(24);
        BlockPos endPos = startingPos.above(24).north(24).east(24);
        return new Tuple<BlockPos, BlockPos>(startPos, endPos);
    }
}

