/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.registries;

import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.level.Level;

public abstract class ILevelBasedRegistry<T> {
    protected ConcurrentHashMap<Level, Vector<T>> internalRegistry = new ConcurrentHashMap();

    protected ILevelBasedRegistry() {
    }

    public void register(Level level, T element) {
        Vector<Object> elements;
        if (!this.internalRegistry.containsKey(level)) {
            elements = new Vector();
            this.internalRegistry.put(level, elements);
        } else {
            elements = this.internalRegistry.get(level);
        }
        if (elements != null) {
            boolean foundExistingElement = false;
            for (Object existingElement : elements) {
                if (existingElement.hashCode() != element.hashCode()) continue;
                foundExistingElement = true;
                break;
            }
            if (!foundExistingElement) {
                elements.add(element);
                this.onElementRegistered(level, element);
            }
        }
    }

    public void remove(Level level, T originalElement) {
        Vector<T> elements;
        if (this.internalRegistry.containsKey(level) && (elements = this.internalRegistry.get(level)) != null) {
            for (int i = 0; i < elements.size(); ++i) {
                T element = elements.get(i);
                if (element.hashCode() != originalElement.hashCode()) continue;
                elements.remove(element);
                this.onElementRemoved(level, element);
                break;
            }
            if (elements.size() == 0) {
                this.internalRegistry.remove(level);
            }
        }
    }

    protected abstract void onElementRemoved(Level var1, T var2);

    protected abstract void onElementRegistered(Level var1, T var2);
}

