/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.prefab.ModRegistryBase;
import com.prefab.PrefabBase;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import org.apache.commons.lang3.StringUtils;

public class ConditionedSmeltingRecipe
extends SmeltingRecipe {
    private final String configName;

    public ConditionedSmeltingRecipe(String group, CookingBookCategory cookingBookCategory, Ingredient input, ItemStack output, float experience, int cookTime, String configName) {
        super(group, cookingBookCategory, input, output, experience, cookTime);
        this.configName = configName;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRegistryBase.ConditionedSmeltingRecipeSeriaizer;
    }

    public static class Serializer
    implements RecipeSerializer<ConditionedSmeltingRecipe> {
        public static final MapCodec<ConditionedSmeltingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(o -> ((ConditionedSmeltingRecipe)o).group), (App)CookingBookCategory.CODEC.fieldOf("category").orElse((Object)CookingBookCategory.MISC).forGetter(o -> ((ConditionedSmeltingRecipe)o).category), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(o -> ((ConditionedSmeltingRecipe)o).ingredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(o -> ((ConditionedSmeltingRecipe)o).result), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.1f)).forGetter(o -> Float.valueOf(((ConditionedSmeltingRecipe)o).experience)), (App)Codec.INT.optionalFieldOf("cookingtime", (Object)200).forGetter(o -> ((ConditionedSmeltingRecipe)o).cookingTime), (App)Codec.STRING.optionalFieldOf("configName", (Object)"").forGetter(o -> o.configName)).apply((Applicative)instance, ConditionedSmeltingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ConditionedSmeltingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ConditionedSmeltingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ConditionedSmeltingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static ConditionedSmeltingRecipe fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf) {
            String group = friendlyByteBuf.readUtf();
            String configName = friendlyByteBuf.readUtf();
            CookingBookCategory cookingBookCategory = (CookingBookCategory)friendlyByteBuf.readEnum(CookingBookCategory.class);
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)friendlyByteBuf);
            ItemStack itemStack = Serializer.validateRecipeOutput((ItemStack)ItemStack.STREAM_CODEC.decode((Object)friendlyByteBuf), configName);
            float experience = friendlyByteBuf.readFloat();
            int cookTime = friendlyByteBuf.readVarInt();
            return new ConditionedSmeltingRecipe(group, cookingBookCategory, ingredient, itemStack, experience, cookTime, configName);
        }

        public static void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, ConditionedSmeltingRecipe abstractCookingRecipe) {
            friendlyByteBuf.writeUtf(abstractCookingRecipe.group);
            friendlyByteBuf.writeUtf(abstractCookingRecipe.configName);
            friendlyByteBuf.writeEnum((Enum)abstractCookingRecipe.category());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)abstractCookingRecipe.ingredient);
            ItemStack.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)abstractCookingRecipe.result);
            friendlyByteBuf.writeFloat(abstractCookingRecipe.experience);
            friendlyByteBuf.writeVarInt(abstractCookingRecipe.cookingTime);
        }

        public static ItemStack validateRecipeOutput(ItemStack originalOutput, String configName) {
            if (originalOutput == ItemStack.EMPTY) {
                return ItemStack.EMPTY;
            }
            if (!StringUtils.isBlank((CharSequence)configName) && PrefabBase.serverConfiguration.recipes.containsKey(configName) && !PrefabBase.serverConfiguration.recipes.get(configName).booleanValue()) {
                return ItemStack.EMPTY;
            }
            return originalOutput;
        }
    }
}

