/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.prefab.ModRegistryBase;
import com.prefab.PrefabBase;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

public class ConditionedShapelessRecipe
extends ShapelessRecipe {
    private final String group;
    CraftingBookCategory category;
    private final ItemStack output;
    private final NonNullList<Ingredient> ingredients;
    private final String configName;

    public ConditionedShapelessRecipe(String group, CraftingBookCategory craftingBookCategory, ItemStack output, NonNullList<Ingredient> ingredients, String configName) {
        super(group, craftingBookCategory, output, ingredients);
        this.group = group;
        this.category = craftingBookCategory;
        this.output = output;
        this.ingredients = ingredients;
        this.configName = configName;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRegistryBase.ConditionedShapelessRecipeSeriaizer;
    }

    public String getGroup() {
        return this.group;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.output;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean matches(CraftingInput craftingInventory, Level world) {
        StackedContents stackedContents = new StackedContents();
        int i = 0;
        for (int j = 0; j < craftingInventory.size(); ++j) {
            ItemStack itemStack = craftingInventory.getItem(j);
            if (itemStack.isEmpty()) continue;
            ++i;
            stackedContents.accountStack(itemStack, 1);
        }
        return i == this.ingredients.size() && stackedContents.canCraft((Recipe)this, null);
    }

    public ItemStack assemble(CraftingInput craftingContainer, HolderLookup.Provider registryAccess) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public static class Serializer
    implements RecipeSerializer<ConditionedShapelessRecipe> {
        private static final MapCodec<ConditionedShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(shapelessRecipe -> shapelessRecipe.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(shapelessRecipe -> shapelessRecipe.category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(shapelessRecipe -> shapelessRecipe.output), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
            Object[] ingredients = (Ingredient[])list.stream().filter(ingredient -> !ingredient.isEmpty()).toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return ingredients.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(shapelessRecipe -> shapelessRecipe.ingredients), (App)Codec.STRING.optionalFieldOf("configName", (Object)"").forGetter(shapelessRecipe -> shapelessRecipe.configName)).apply((Applicative)instance, ConditionedShapelessRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ConditionedShapelessRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ConditionedShapelessRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ConditionedShapelessRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static ConditionedShapelessRecipe fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf) {
            String groupName = friendlyByteBuf.readUtf();
            String configName = friendlyByteBuf.readUtf();
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)friendlyByteBuf.readEnum(CraftingBookCategory.class);
            int i = friendlyByteBuf.readVarInt();
            NonNullList nonNullList = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            nonNullList.replaceAll(ignored -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)friendlyByteBuf));
            boolean isEmptyStack = friendlyByteBuf.readBoolean();
            ItemStack itemStack = ItemStack.EMPTY;
            if (!isEmptyStack) {
                itemStack = Serializer.validateRecipeOutput((ItemStack)ItemStack.STREAM_CODEC.decode((Object)friendlyByteBuf), configName);
            }
            return new ConditionedShapelessRecipe(groupName, craftingBookCategory, itemStack, (NonNullList<Ingredient>)nonNullList, configName);
        }

        public static void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, ConditionedShapelessRecipe shapelessRecipe) {
            friendlyByteBuf.writeUtf(shapelessRecipe.group);
            friendlyByteBuf.writeUtf(shapelessRecipe.configName);
            friendlyByteBuf.writeEnum((Enum)shapelessRecipe.category);
            friendlyByteBuf.writeVarInt(shapelessRecipe.ingredients.size());
            for (Ingredient ingredient : shapelessRecipe.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)ingredient);
            }
            if (!shapelessRecipe.output.isEmpty()) {
                friendlyByteBuf.writeBoolean(false);
                ItemStack.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)shapelessRecipe.output);
            } else {
                friendlyByteBuf.writeBoolean(true);
            }
        }

        public static ItemStack validateRecipeOutput(ItemStack originalOutput, String configName) {
            if (originalOutput == ItemStack.EMPTY) {
                return ItemStack.EMPTY;
            }
            if (!StringUtils.isBlank((CharSequence)configName) && PrefabBase.serverConfiguration.recipes.containsKey(configName) && !PrefabBase.serverConfiguration.recipes.get(configName).booleanValue()) {
                return ItemStack.EMPTY;
            }
            return originalOutput;
        }
    }
}

