/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.prefab.ModRegistryBase;
import com.prefab.PrefabBase;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

public class ConditionedShapedRecipe
extends ShapedRecipe {
    final int width;
    final int height;
    final CraftingBookCategory craftingBookCategory;
    final NonNullList<Ingredient> inputs;
    final String group;
    final String configName;
    final boolean recipeHasTags;
    ShapedRecipePattern pattern;
    ItemStack output;
    boolean reloadedTags;
    boolean showNotification;

    public ConditionedShapedRecipe(String group, CraftingBookCategory craftingBookCategory, ShapedRecipePattern pattern, ItemStack output, String configName, boolean recipeHasTags, boolean showNotification) {
        super(group, craftingBookCategory, pattern, output, showNotification);
        this.group = group;
        this.craftingBookCategory = craftingBookCategory;
        this.width = pattern.width();
        this.height = pattern.height();
        this.inputs = pattern.ingredients();
        this.pattern = pattern;
        this.output = output;
        this.configName = configName;
        this.recipeHasTags = recipeHasTags;
        this.reloadedTags = false;
        this.showNotification = showNotification;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRegistryBase.ConditionedShapedRecipeSeriaizer;
    }

    public String getGroup() {
        return this.group;
    }

    public CraftingBookCategory category() {
        return this.craftingBookCategory;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.output;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    public boolean showNotification() {
        return this.showNotification;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public boolean matches(CraftingInput craftingInventory, Level level) {
        if (this.recipeHasTags && !this.reloadedTags) {
            this.validateTagIngredients();
            this.reloadedTags = true;
        }
        for (int i = 0; i <= craftingInventory.width() - this.width; ++i) {
            for (int j = 0; j <= craftingInventory.height() - this.height; ++j) {
                if (this.matches(craftingInventory, i, j, true)) {
                    return true;
                }
                if (!this.matches(craftingInventory, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack assemble(CraftingInput craftingContainer, HolderLookup.Provider registryAccess) {
        ItemStack actualOutput = Serializer.validateRecipeOutput(this.output, this.configName);
        return actualOutput.copy();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private boolean matches(CraftingInput inv, int offsetX, int offsetY, boolean bl) {
        for (int i = 0; i < inv.width(); ++i) {
            for (int j = 0; j < inv.height(); ++j) {
                int k = i - offsetX;
                int l = j - offsetY;
                Ingredient ingredient = Ingredient.EMPTY;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = bl ? (Ingredient)this.inputs.get(this.width - k - 1 + l * this.width) : (Ingredient)this.inputs.get(k + l * this.width);
                }
                if (ingredient.test(inv.getItem(i + j * inv.width()))) continue;
                return false;
            }
        }
        return true;
    }

    private void validateTagIngredients() {
        boolean invalidRecipe = false;
        block0: for (Ingredient ingredient : this.getIngredients()) {
            if (ingredient.getItems().length != 0) continue;
            if (!this.pattern.data.isPresent()) break;
            for (Map.Entry keyMap : ((ShapedRecipePattern.Data)this.pattern.data.get()).key().entrySet()) {
                if (((Ingredient)keyMap.getValue()).itemStacks != null && ((Ingredient)keyMap.getValue()).itemStacks.length != 0) continue;
                invalidRecipe = true;
                break block0;
            }
        }
        if (invalidRecipe) {
            this.output = ItemStack.EMPTY;
        }
    }

    public static class Serializer
    implements RecipeSerializer<ConditionedShapedRecipe> {
        public static final MapCodec<ConditionedShapedRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(shapedRecipe -> shapedRecipe.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(shapedRecipe -> shapedRecipe.craftingBookCategory), (App)ShapedRecipePattern.MAP_CODEC.forGetter(shapedRecipe -> shapedRecipe.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(shapedRecipe -> shapedRecipe.output), (App)Codec.STRING.optionalFieldOf("configName", (Object)"").forGetter(shapedRecipe -> shapedRecipe.configName), (App)Codec.BOOL.optionalFieldOf("recipe_has_tags", (Object)true).forGetter(shapedRecipe -> shapedRecipe.recipeHasTags), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(shapedRecipe -> shapedRecipe.showNotification)).apply((Applicative)instance, ConditionedShapedRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ConditionedShapedRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static ItemStack validateRecipeOutput(ItemStack originalOutput, String configName) {
            if (originalOutput == ItemStack.EMPTY) {
                return ItemStack.EMPTY;
            }
            if (!StringUtils.isBlank((CharSequence)configName) && PrefabBase.serverConfiguration.recipes.containsKey(configName) && !PrefabBase.serverConfiguration.recipes.get(configName).booleanValue()) {
                PrefabBase.logger.debug("{} recipe is disabled, the item result is still available, but players may be unable to craft the associated item(s)", (Object)configName);
                return ItemStack.EMPTY;
            }
            return originalOutput;
        }

        public MapCodec<ConditionedShapedRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ConditionedShapedRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static ConditionedShapedRecipe fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf) {
            String groupName = friendlyByteBuf.readUtf();
            String configName = friendlyByteBuf.readUtf();
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)friendlyByteBuf.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern shapedRecipePattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)friendlyByteBuf);
            boolean isEmptyStack = friendlyByteBuf.readBoolean();
            ItemStack itemStack = ItemStack.EMPTY;
            if (!isEmptyStack) {
                itemStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)friendlyByteBuf);
            }
            boolean recipeHasTags = friendlyByteBuf.readBoolean();
            boolean showNotification = friendlyByteBuf.readBoolean();
            return new ConditionedShapedRecipe(groupName, craftingBookCategory, shapedRecipePattern, itemStack, configName, recipeHasTags, showNotification);
        }

        public static void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, ConditionedShapedRecipe shapedRecipe) {
            friendlyByteBuf.writeUtf(shapedRecipe.group);
            friendlyByteBuf.writeUtf(shapedRecipe.configName);
            friendlyByteBuf.writeEnum((Enum)shapedRecipe.craftingBookCategory);
            ShapedRecipePattern.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)shapedRecipe.pattern);
            if (!shapedRecipe.output.isEmpty()) {
                friendlyByteBuf.writeBoolean(false);
                ItemStack.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)shapedRecipe.output);
            } else {
                friendlyByteBuf.writeBoolean(true);
            }
            friendlyByteBuf.writeBoolean(shapedRecipe.recipeHasTags);
            friendlyByteBuf.writeBoolean(shapedRecipe.showNotification);
        }
    }
}

