/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.neoforge.network;

import com.prefab.blocks.entities.StructureScannerBlockEntity;
import com.prefab.config.StructureScannerConfig;
import com.prefab.network.payloads.ScanShapePayload;
import com.prefab.network.payloads.ScannerConfigPayload;
import com.prefab.network.payloads.StructurePayload;
import com.prefab.structures.config.StructureConfiguration;
import com.prefab.structures.messages.StructureTagMessage;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    public static void scannerConfigHandler(ScannerConfigPayload payload, IPayloadContext context) {
        context.player().getServer().execute(() -> {
            StructureScannerConfig config = payload.scannerInfo().ToConfig();
            BlockEntity blockEntity = context.player().level().getBlockEntity(config.blockPos.above());
            if (blockEntity instanceof StructureScannerBlockEntity) {
                StructureScannerBlockEntity actualEntity = (StructureScannerBlockEntity)blockEntity;
                actualEntity.setConfig(config);
            }
        });
    }

    public static void scannerScanHandler(ScanShapePayload payload, IPayloadContext context) {
        context.player().getServer().execute(() -> {
            StructureScannerConfig config = payload.scannerInfo().ToConfig();
            ServerPlayer serverPlayer = (ServerPlayer)context.player();
            StructureScannerBlockEntity.ScanShape(config, serverPlayer, serverPlayer.serverLevel());
        });
    }

    public static void structureBuilderHandler(StructurePayload payload, IPayloadContext context) {
        StructureTagMessage.EnumStructureConfiguration structureConfig = payload.structureTagMessage().getStructureConfig();
        context.player().getServer().execute(() -> {
            StructureConfiguration configuration = structureConfig.structureConfig.ReadFromCompoundTag(payload.structureTagMessage().getMessageTag());
            ServerPlayer serverPlayer = (ServerPlayer)context.player();
            configuration.BuildStructure(context.player(), serverPlayer.serverLevel());
        });
    }
}

