/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.neoforge.network;

import com.prefab.network.ClientToServerTypes;
import com.prefab.network.INetworkWrapper;
import com.prefab.network.ServerToClientTypes;
import com.prefab.network.message.ScannerInfo;
import com.prefab.network.message.TagMessage;
import com.prefab.network.payloads.ConfigSyncPayload;
import com.prefab.network.payloads.PlayerConfigPayload;
import com.prefab.network.payloads.ScanShapePayload;
import com.prefab.network.payloads.ScannerConfigPayload;
import com.prefab.network.payloads.StructurePayload;
import com.prefab.structures.messages.StructureTagMessage;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;

public class NetworkWrapper
implements INetworkWrapper {
    @Override
    public <T> void sendToServer(ClientToServerTypes messageType, T message) {
        switch (messageType) {
            case STRUCTURE_BUILD: {
                this.sendStructureTagMessage((StructureTagMessage)message);
                break;
            }
            case SCAN_SHAPE: {
                this.sendScannerScanMessage((ScannerInfo)message);
                break;
            }
            case SCANNER_CONFIG_UPDATE: {
                this.sendScannerConfigMessage((ScannerInfo)message);
            }
        }
    }

    @Override
    public <T> void sendToClient(ServerToClientTypes messageType, ServerPlayer targetEntity, T message) {
        switch (messageType) {
            case MOD_CONFIG_SYNC: {
                this.sendModConfigSyncMessage((TagMessage)message, targetEntity);
                break;
            }
            case PLAYER_CONFIG_SYNC: {
                this.sendPlayerConfigSyncMessage((TagMessage)message, targetEntity);
            }
        }
    }

    private void sendStructureTagMessage(StructureTagMessage message) {
        StructurePayload payload = new StructurePayload(message);
        PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void sendScannerConfigMessage(ScannerInfo message) {
        ScannerConfigPayload scannerConfigPayload = new ScannerConfigPayload(message);
        PacketDistributor.sendToServer((CustomPacketPayload)scannerConfigPayload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void sendScannerScanMessage(ScannerInfo message) {
        ScanShapePayload scanShapePayload = new ScanShapePayload(message);
        PacketDistributor.sendToServer((CustomPacketPayload)scanShapePayload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void sendModConfigSyncMessage(TagMessage message, ServerPlayer player) {
        ConfigSyncPayload configSyncPayload = new ConfigSyncPayload(message);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)configSyncPayload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void sendPlayerConfigSyncMessage(TagMessage message, ServerPlayer player) {
        PlayerConfigPayload playerConfigPayload = new PlayerConfigPayload(message);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)playerConfigPayload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

