/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.neoforge.items;

import com.prefab.Utils;
import com.prefab.gui.GuiLangKeys;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ItemBulldozer
extends com.prefab.structures.items.ItemBulldozer {
    public ItemBulldozer() {
    }

    public ItemBulldozer(boolean powered) {
        super(powered);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, Item.TooltipContext tooltipContext, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, tooltipContext, tooltip, flagIn);
        boolean advancedKeyDown = Screen.hasShiftDown();
        if (!advancedKeyDown) {
            tooltip.add(GuiLangKeys.translateToComponent("prefab.gui.tooltip.shift"));
        } else if (this.getPoweredValue(stack)) {
            tooltip.addAll(Utils.WrapStringToLiterals(GuiLangKeys.translateString("prefab.gui.tooltip.bulldozer_powered")));
        } else {
            tooltip.addAll(Utils.WrapStringToLiterals(GuiLangKeys.translateString("prefab.gui.tooltip.bulldozer_unpowered")));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil(@NotNull ItemStack stack) {
        return this.getPoweredValue(stack) || super.isFoil(stack);
    }
}

