/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.neoforge.events;

import com.prefab.ModRegistryBase;
import com.prefab.PrefabBase;
import com.prefab.config.EntityPlayerConfiguration;
import com.prefab.config.ModConfiguration;
import com.prefab.items.ItemSickle;
import com.prefab.network.ServerToClientTypes;
import com.prefab.network.message.TagMessage;
import com.prefab.registries.ModRegistries;
import com.prefab.structures.base.StructureGenerator;
import java.util.ArrayList;
import java.util.Objects;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class GameServerEvents {
    public static ArrayList<BlockPos> RedstoneAffectedBlockPositions = new ArrayList();

    @SubscribeEvent
    public void onServerAboutToStart(ServerAboutToStartEvent event) {
        ModRegistryBase.serverModRegistries = new ModRegistries();
        ItemSickle.setEffectiveBlocks();
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        ModConfiguration config = (ModConfiguration)AutoConfig.getConfigHolder(ModConfiguration.class).getConfig();
        CompoundTag tag = config.writeCompoundTag();
        PrefabBase.serverConfiguration = new ModConfiguration();
        PrefabBase.serverConfiguration.readFromTag(tag);
        ModRegistryBase.serverModRegistries.getStrictBuildingRegistry().processModConfiguration(config);
    }

    @SubscribeEvent
    public void playerJoinedServer(PlayerEvent.PlayerLoggedInEvent event) {
        Player player;
        if (!event.getEntity().level().isClientSide() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PrefabBase.logger.info("{} logged into server, sending config to client", (Object)Objects.requireNonNull(player2.getDisplayName()));
            TagMessage message = new TagMessage(PrefabBase.serverConfiguration.writeCompoundTag());
            PrefabBase.networkWrapper.sendToClient(ServerToClientTypes.MOD_CONFIG_SYNC, player2, message);
            EntityPlayerConfiguration playerConfig = EntityPlayerConfiguration.loadFromEntity((Player)player2);
            ModConfiguration.StartingItemOptions startingItem = PrefabBase.serverConfiguration.startingItem;
            if (!playerConfig.givenHouseBuilder && startingItem != null && PrefabBase.serverConfiguration.newPlayersGetStartingItem) {
                ItemStack stack = ItemStack.EMPTY;
                switch (startingItem) {
                    case StartingHouse: {
                        stack = new ItemStack((ItemLike)ModRegistryBase.House);
                        break;
                    }
                    case ModerateHouse: {
                        stack = new ItemStack((ItemLike)ModRegistryBase.HouseImproved);
                    }
                }
                if (!stack.isEmpty()) {
                    PrefabBase.logger.info("{} joined the game for the first time. Giving them starting item.", (Object)Objects.requireNonNull(player2.getDisplayName()));
                    player2.getInventory().add(stack);
                    player2.containerMenu.broadcastChanges();
                    playerConfig.givenHouseBuilder = true;
                }
            }
            TagMessage tagMessage = new TagMessage();
            tagMessage.setMessageTag(playerConfig.createPlayerTag());
            PrefabBase.networkWrapper.sendToClient(ServerToClientTypes.PLAYER_CONFIG_SYNC, player2, tagMessage);
        }
    }

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        if (event.getEntity() instanceof ServerPlayer) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Pre event) {
        StructureGenerator.CheckForStructureToBuildAndBuildIt();
    }
}

