/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.neoforge.events;

import com.prefab.ClientModRegistryBase;
import com.prefab.PrefabBase;
import com.prefab.neoforge.events.ModClientEvents;
import com.prefab.network.ClientToServerTypes;
import com.prefab.structures.config.BasicStructureConfiguration;
import com.prefab.structures.gui.GuiStructure;
import com.prefab.structures.items.ItemBasicStructure;
import com.prefab.structures.items.StructureItem;
import com.prefab.structures.messages.StructureTagMessage;
import com.prefab.structures.render.StructureRenderHandler;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="prefab", value={Dist.CLIENT})
public class GameClientEvents {
    @SubscribeEvent
    public static void KeyInput(InputEvent.Key event) {
        for (KeyMapping binding : ModClientEvents.keyBindings) {
            if (!binding.isDown()) continue;
            if (StructureRenderHandler.currentStructure == null) break;
            ItemStack mainHandStack = Minecraft.getInstance().player.getMainHandItem();
            ItemStack offHandStack = Minecraft.getInstance().player.getOffhandItem();
            boolean foundCorrectStructureItem = false;
            if (mainHandStack != ItemStack.EMPTY || offHandStack != ItemStack.EMPTY) {
                StructureTagMessage.EnumStructureConfiguration structureConfigurationEnum = StructureTagMessage.EnumStructureConfiguration.getByConfigurationInstance(StructureRenderHandler.currentConfiguration);
                if (mainHandStack != ItemStack.EMPTY && mainHandStack.getItem() instanceof StructureItem) {
                    foundCorrectStructureItem = GameClientEvents.checkIfStackIsCorrectGui(structureConfigurationEnum, mainHandStack);
                }
                if (!foundCorrectStructureItem && offHandStack != ItemStack.EMPTY && offHandStack.getItem() instanceof StructureItem) {
                    foundCorrectStructureItem = GameClientEvents.checkIfStackIsCorrectGui(structureConfigurationEnum, offHandStack);
                }
            }
            if (foundCorrectStructureItem) {
                StructureTagMessage message = new StructureTagMessage(StructureRenderHandler.currentConfiguration.WriteToCompoundTag(), StructureTagMessage.EnumStructureConfiguration.getByConfigurationInstance(StructureRenderHandler.currentConfiguration));
                PrefabBase.networkWrapper.sendToServer(ClientToServerTypes.STRUCTURE_BUILD, message);
            }
            StructureRenderHandler.currentStructure = null;
            break;
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (StructureRenderHandler.currentStructure != null && event.getEntity() == Minecraft.getInstance().player) {
            StructureRenderHandler.setStructure(null, null);
            event.setCanceled(true);
        }
    }

    public static boolean checkIfStackIsCorrectGui(StructureTagMessage.EnumStructureConfiguration currentConfiguration, ItemStack stack) {
        GuiStructure mainHandGui = ClientModRegistryBase.ModGuis.get(stack.getItem());
        if (currentConfiguration == mainHandGui.structureConfiguration) {
            if (currentConfiguration == StructureTagMessage.EnumStructureConfiguration.Basic) {
                ItemBasicStructure item = (ItemBasicStructure)stack.getItem();
                BasicStructureConfiguration.EnumBasicStructureName basicStructureName = ((BasicStructureConfiguration)StructureRenderHandler.currentConfiguration).basicStructureName;
                return item.structureType == basicStructureName;
            }
            return true;
        }
        return false;
    }
}

