/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.neoforge.blocks;

import com.prefab.blocks.BlockPhasic;
import com.prefab.neoforge.events.GameServerEvents;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class BlockPhasic
extends com.prefab.blocks.BlockPhasic {
    @NotNull
    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPhasic.EnumPhasingProgress currentState = (BlockPhasic.EnumPhasingProgress)((Object)state.getValue((Property)Phasing_Progress));
        super.playerWillDestroy(world, pos, state, player);
        GameServerEvents.RedstoneAffectedBlockPositions.remove(pos);
        boolean poweredSide = world.hasNeighborSignal(pos);
        if (poweredSide && currentState == BlockPhasic.EnumPhasingProgress.transparent) {
            this.updateNeighborPhasicBlocks(false, world, pos, state, false, false);
        }
        return state;
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        int updatedMeta;
        int tickDelay = this.tickRate;
        if (GameServerEvents.RedstoneAffectedBlockPositions.contains(pos)) {
            return;
        }
        BlockPhasic.EnumPhasingProgress progress = (BlockPhasic.EnumPhasingProgress)((Object)state.getValue((Property)Phasing_Progress));
        boolean phasingOut = (Boolean)state.getValue((Property)Phasing_Out);
        if (progress == BlockPhasic.EnumPhasingProgress.base) {
            for (Direction facing : Direction.values()) {
                Block currentBlock = worldIn.getBlockState(pos.relative(facing)).getBlock();
                if (!(currentBlock instanceof com.prefab.blocks.BlockPhasic) || GameServerEvents.RedstoneAffectedBlockPositions.contains(pos.relative(facing))) continue;
                worldIn.scheduleTick(pos.relative(facing), currentBlock, tickDelay);
            }
            phasingOut = true;
        }
        if ((updatedMeta = progress.getMeta()) == BlockPhasic.EnumPhasingProgress.eighty_percent.getMeta() && phasingOut) {
            tickDelay = 100;
        }
        if (updatedMeta == BlockPhasic.EnumPhasingProgress.transparent.getMeta() && phasingOut) {
            phasingOut = false;
        }
        if (updatedMeta == BlockPhasic.EnumPhasingProgress.twenty_percent.getMeta() && !phasingOut) {
            tickDelay = -1;
        }
        updatedMeta = phasingOut ? updatedMeta + 2 : updatedMeta - 2;
        progress = BlockPhasic.EnumPhasingProgress.ValueOf(updatedMeta);
        state = (BlockState)((BlockState)state.setValue((Property)Phasing_Out, (Comparable)Boolean.valueOf(phasingOut))).setValue((Property)Phasing_Progress, (Comparable)((Object)progress));
        worldIn.setBlock(pos, state, 3);
        if (tickDelay > 0) {
            worldIn.scheduleTick(pos, (Block)this, tickDelay);
        }
    }

    protected void updateNeighborPhasicBlocks(boolean setToTransparent, Level worldIn, BlockPos pos, BlockState phasicBlockState, boolean setCurrentBlock, boolean triggeredByRedstone) {
        ArrayList<BlockPos> blocksToUpdate = new ArrayList<BlockPos>();
        BlockState updatedBlockState = (BlockState)((BlockState)phasicBlockState.setValue((Property)Phasing_Out, (Comparable)Boolean.valueOf(setToTransparent))).setValue((Property)Phasing_Progress, (Comparable)((Object)(setToTransparent ? BlockPhasic.EnumPhasingProgress.transparent : BlockPhasic.EnumPhasingProgress.base)));
        this.findNeighborPhasicBlocks(worldIn, pos, updatedBlockState, 0, blocksToUpdate, setCurrentBlock);
        for (BlockPos positionToUpdate : blocksToUpdate) {
            worldIn.setBlock(positionToUpdate, updatedBlockState, 3);
            if (!triggeredByRedstone) continue;
            if (GameServerEvents.RedstoneAffectedBlockPositions.contains(positionToUpdate) && !setToTransparent) {
                GameServerEvents.RedstoneAffectedBlockPositions.remove(positionToUpdate);
                continue;
            }
            if (GameServerEvents.RedstoneAffectedBlockPositions.contains(positionToUpdate) || !setToTransparent) continue;
            GameServerEvents.RedstoneAffectedBlockPositions.add(positionToUpdate);
        }
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos p_189540_5_, boolean p_220069_6_) {
        if (!worldIn.isClientSide() && blockIn.defaultBlockState().isSignalSource()) {
            boolean poweredSide = worldIn.hasNeighborSignal(pos);
            BlockPhasic.EnumPhasingProgress currentState = (BlockPhasic.EnumPhasingProgress)((Object)state.getValue((Property)Phasing_Progress));
            boolean setToTransparent = false;
            if (poweredSide && currentState == BlockPhasic.EnumPhasingProgress.base) {
                setToTransparent = true;
            }
            if (currentState == BlockPhasic.EnumPhasingProgress.base || currentState == BlockPhasic.EnumPhasingProgress.transparent) {
                this.updateNeighborPhasicBlocks(setToTransparent, worldIn, pos, state, true, true);
            }
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean poweredSide = context.getLevel().hasNeighborSignal(context.getClickedPos());
        if (poweredSide) {
            this.updateNeighborPhasicBlocks(true, context.getLevel(), context.getClickedPos(), this.defaultBlockState(), false, false);
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)Phasing_Out, (Comparable)Boolean.valueOf(poweredSide))).setValue((Property)Phasing_Progress, (Comparable)((Object)BlockPhasic.EnumPhasingProgress.base));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        BlockPhasic.EnumPhasingProgress progress = (BlockPhasic.EnumPhasingProgress)((Object)state.getValue((Property)Phasing_Progress));
        return progress == BlockPhasic.EnumPhasingProgress.transparent;
    }
}

