/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.neoforge;

import com.prefab.ModRegistryBase;
import com.prefab.PrefabBase;
import com.prefab.blocks.BlockCompressedObsidian;
import com.prefab.blocks.BlockCompressedStone;
import com.prefab.blocks.BlockCustomWall;
import com.prefab.blocks.BlockStructureScanner;
import com.prefab.blocks.entities.LightSwitchBlockEntity;
import com.prefab.blocks.entities.StructureScannerBlockEntity;
import com.prefab.neoforge.Prefab;
import com.prefab.neoforge.blocks.BlockBoundary;
import com.prefab.neoforge.blocks.BlockGlassSlab;
import com.prefab.neoforge.blocks.BlockGlassStairs;
import com.prefab.neoforge.blocks.BlockPaperLantern;
import com.prefab.neoforge.blocks.BlockPhasic;
import com.prefab.neoforge.items.ItemBulldozer;
import com.prefab.neoforge.items.ItemCompressedChest;
import com.prefab.neoforge.items.ItemSickle;
import com.prefab.neoforge.network.ClientPayloadHandler;
import com.prefab.neoforge.network.ServerPayloadHandler;
import com.prefab.network.payloads.ConfigSyncPayload;
import com.prefab.network.payloads.PlayerConfigPayload;
import com.prefab.network.payloads.ScanShapePayload;
import com.prefab.network.payloads.ScannerConfigPayload;
import com.prefab.network.payloads.StructurePayload;
import com.prefab.structures.config.BasicStructureConfiguration;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;

public class ModRegistry
extends ModRegistryBase {
    public PayloadRegistrar registrar;
    private static final ArrayList<Item> ModItems = new ArrayList();
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> EXAMPLE_TAB = Prefab.CREATIVE_MODE_TABS.register("example_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.prefab.logo")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).icon(() -> ModRegistryBase.LogoItem.getDefaultInstance()).displayItems((parameters, output) -> {
        for (Item item : ModItems) {
            if (item == ModRegistryBase.StructureScannerItem && !PrefabBase.isDebug || item == ModRegistryBase.LogoItem) continue;
            output.accept((ItemLike)item);
        }
    }).build());

    @Override
    public void initializeModLoaderBlocks() {
        ModRegistryBase.Boundary = new BlockBoundary();
        ModRegistryBase.GlassSlab = new BlockGlassSlab(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS));
        ModRegistryBase.GlassStairs = new BlockGlassStairs(Blocks.GLASS.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS));
        ModRegistryBase.PaperLantern = new BlockPaperLantern();
        ModRegistryBase.Phasic = new BlockPhasic();
    }

    @Override
    public void initializeModLoaderBlockItems() {
        ModRegistryBase.BoundaryItem = new BlockItem((Block)ModRegistryBase.Boundary, new Item.Properties());
        ModRegistryBase.GlassSlabItem = new BlockItem((Block)ModRegistryBase.GlassSlab, new Item.Properties());
        ModRegistryBase.GlassStairsItem = new BlockItem((Block)ModRegistryBase.GlassStairs, new Item.Properties());
        ModRegistryBase.PaperLanternItem = new BlockItem((Block)ModRegistryBase.PaperLantern, new Item.Properties());
        ModRegistryBase.PhasicItem = new BlockItem((Block)ModRegistryBase.Phasic, new Item.Properties());
    }

    @Override
    public void initializeModLoaderItems() {
        ModRegistryBase.CompressedChest = new ItemCompressedChest();
        ModRegistryBase.SickleDiamond = new ItemSickle((Tier)Tiers.DIAMOND);
        ModRegistryBase.SickleGold = new ItemSickle((Tier)Tiers.GOLD);
        ModRegistryBase.SickleNetherite = new ItemSickle((Tier)Tiers.NETHERITE);
        ModRegistryBase.SickleIron = new ItemSickle((Tier)Tiers.IRON);
        ModRegistryBase.SickleStone = new ItemSickle((Tier)Tiers.STONE);
        ModRegistryBase.SickleWood = new ItemSickle((Tier)Tiers.WOOD);
    }

    @Override
    public void initializeModLoaderBluePrintItems() {
        ModRegistryBase.Bulldozer = new ItemBulldozer();
        ModRegistryBase.CreativeBulldozer = new ItemBulldozer(true);
    }

    public void register(RegisterEvent event) {
        if (event.getRegistryKey() == Registries.BLOCK) {
            this.initializeBlocks();
            this.registerBlocks();
        } else if (event.getRegistryKey() == Registries.ITEM) {
            this.initializeItems();
            this.initializeBluePrintItems();
            this.initializeBlockItems();
            this.registerItems();
            this.registerBluePrints();
            this.registerItemBlocks();
        } else if (event.getRegistryKey() == Registries.RECIPE_SERIALIZER) {
            this.initializeRecipeSerializers();
            this.RegisterRecipeSerializers();
        } else if (event.getRegistryKey() == Registries.ENTITY_TYPE) {
            this.registerBlockEntities();
        } else if (event.getRegistryKey() == Registries.SOUND_EVENT) {
            this.initializeSounds();
            this.registerSounds();
        }
    }

    public void registerPayLoads(RegisterPayloadHandlersEvent event) {
        this.registrar = event.registrar("1");
        this.registrar.playToServer(ScannerConfigPayload.PACKET_TYPE, ScannerConfigPayload.STREAM_CODEC, ServerPayloadHandler::scannerConfigHandler);
        this.registrar.playToServer(ScanShapePayload.PACKET_TYPE, ScanShapePayload.STREAM_CODEC, ServerPayloadHandler::scannerScanHandler);
        this.registrar.playToServer(StructurePayload.PACKET_TYPE, StructurePayload.STREAM_CODEC, ServerPayloadHandler::structureBuilderHandler);
        this.registrar.playToClient(PlayerConfigPayload.PACKET_TYPE, PlayerConfigPayload.STREAM_CODEC, ClientPayloadHandler::PlayerConfigHandler);
        this.registrar.playToClient(ConfigSyncPayload.PACKET_TYPE, ConfigSyncPayload.STREAM_CODEC, ClientPayloadHandler::ModConfigHandler);
    }

    private void registerSounds() {
        Registry.register((Registry)BuiltInRegistries.SOUND_EVENT, (ResourceLocation)Objects.requireNonNull(ResourceLocation.tryBuild((String)"prefab", (String)"building_blueprint")), (Object)ModRegistryBase.BuildingBlueprint);
    }

    private void registerBlockEntities() {
        if (PrefabBase.isDebug) {
            ModRegistryBase.StructureScannerEntityType = (BlockEntityType)Registry.register((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"prefab:structure_scanner_entity", (Object)BlockEntityType.Builder.of(StructureScannerBlockEntity::new, (Block[])new Block[]{ModRegistryBase.StructureScanner}).build(null));
        }
        ModRegistryBase.LightSwitchEntityType = (BlockEntityType)Registry.register((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"prefab:light_switch_entity", (Object)BlockEntityType.Builder.of(LightSwitchBlockEntity::new, (Block[])new Block[]{ModRegistryBase.LightSwitch}).build(null));
    }

    private void registerBlocks() {
        this.registerBlock(BlockCompressedStone.EnumType.COMPRESSED_STONE.getUnlocalizedName(), ModRegistryBase.CompressedStone);
        this.registerBlock(BlockCompressedStone.EnumType.DOUBLE_COMPRESSED_STONE.getUnlocalizedName(), ModRegistryBase.DoubleCompressedStone);
        this.registerBlock(BlockCompressedStone.EnumType.TRIPLE_COMPRESSED_STONE.getUnlocalizedName(), ModRegistryBase.TripleCompressedStone);
        this.registerBlock(BlockCompressedStone.EnumType.COMPRESSED_DIRT.getUnlocalizedName(), ModRegistryBase.CompressedDirt);
        this.registerBlock(BlockCompressedStone.EnumType.DOUBLE_COMPRESSED_DIRT.getUnlocalizedName(), ModRegistryBase.DoubleCompressedDirt);
        this.registerBlock(BlockCompressedStone.EnumType.COMPRESSED_GLOWSTONE.getUnlocalizedName(), ModRegistryBase.CompressedGlowstone);
        this.registerBlock(BlockCompressedStone.EnumType.DOUBLE_COMPRESSED_GLOWSTONE.getUnlocalizedName(), ModRegistryBase.DoubleCompressedGlowstone);
        this.registerBlock(BlockCompressedStone.EnumType.COMPRESSED_QUARTZCRETE.getUnlocalizedName(), ModRegistryBase.CompressedQuartzCrete);
        this.registerBlock(BlockCompressedStone.EnumType.DOUBLE_COMPRESSED_QUARTZCRETE.getUnlocalizedName(), ModRegistryBase.DoubleCompressedQuartzCrete);
        this.registerBlock(BlockCompressedObsidian.EnumType.COMPRESSED_OBSIDIAN.toString(), ModRegistryBase.CompressedObsidian);
        this.registerBlock(BlockCompressedObsidian.EnumType.DOUBLE_COMPRESSED_OBSIDIAN.toString(), ModRegistryBase.DoubleCompressedObsidian);
        this.registerBlock("block_glass_slab", (Block)ModRegistryBase.GlassSlab);
        this.registerBlock("block_glass_stairs", (Block)ModRegistryBase.GlassStairs);
        this.registerBlock("block_paper_lantern", ModRegistryBase.PaperLantern);
        this.registerBlock("block_phasic", ModRegistryBase.Phasic);
        this.registerBlock("block_boundary", ModRegistryBase.Boundary);
        this.registerBlock("block_grass_slab", (Block)ModRegistryBase.GrassSlab);
        this.registerBlock("block_grass_stairs", (Block)ModRegistryBase.GrassStairs);
        this.registerBlock(BlockCustomWall.EnumType.GRASS.getUnlocalizedName(), (Block)ModRegistryBase.GrassWall);
        this.registerBlock(BlockCustomWall.EnumType.DIRT.getUnlocalizedName(), (Block)ModRegistryBase.DirtWall);
        this.registerBlock("block_dirt_stairs", (Block)ModRegistryBase.DirtStairs);
        this.registerBlock("block_dirt_slab", (Block)ModRegistryBase.DirtSlab);
        this.registerBlock("item_pile_of_bricks", ModRegistryBase.PileOfBricks);
        this.registerBlock("item_pallet_of_bricks", ModRegistryBase.PalletOfBricks);
        this.registerBlock("item_bundle_of_timber", ModRegistryBase.BundleOfTimber);
        this.registerBlock("item_heap_of_timber", ModRegistryBase.HeapOfTimber);
        this.registerBlock("item_ton_of_timber", ModRegistryBase.TonOfTimber);
        this.registerBlock("item_wooden_crate", ModRegistryBase.EmptyCrate);
        this.registerBlock("item_carton_of_eggs", ModRegistryBase.CartonOfEggs);
        this.registerBlock("item_crate_of_potatoes", ModRegistryBase.CrateOfPotatoes);
        this.registerBlock("item_crate_of_carrots", ModRegistryBase.CrateOfCarrots);
        this.registerBlock("item_crate_of_beets", ModRegistryBase.CrateOfBeets);
        if (PrefabBase.isDebug) {
            ModRegistryBase.StructureScanner = new BlockStructureScanner();
            this.registerBlock("block_structure_scanner", (Block)ModRegistryBase.StructureScanner);
        }
        this.registerBlock("block_light_switch", (Block)ModRegistryBase.LightSwitch);
        this.registerBlock("block_dark_lamp", ModRegistryBase.DarkLamp);
        this.registerBlock("block_quartz_crete", ModRegistryBase.QuartzCrete);
        this.registerBlock("block_quartz_crete_wall", (Block)ModRegistryBase.QuartzCreteWall);
        this.registerBlock("block_quartz_crete_bricks", ModRegistryBase.QuartzCreteBricks);
        this.registerBlock("block_quartz_crete_chiseled", ModRegistryBase.ChiseledQuartzCrete);
        this.registerBlock("block_quartz_crete_pillar", (Block)ModRegistryBase.QuartzCretePillar);
        this.registerBlock("block_quartz_crete_stairs", (Block)ModRegistryBase.QuartzCreteStairs);
        this.registerBlock("block_quartz_crete_slab", (Block)ModRegistryBase.QuartzCreteSlab);
        this.registerBlock("block_quartz_crete_smooth", ModRegistryBase.SmoothQuartzCrete);
        this.registerBlock("block_quartz_crete_smooth_wall", (Block)ModRegistryBase.SmoothQuartzCreteWall);
        this.registerBlock("block_quartz_crete_smooth_stairs", (Block)ModRegistryBase.SmoothQuartzCreteStairs);
        this.registerBlock("block_quartz_crete_smooth_slab", (Block)ModRegistryBase.SmoothQuartzCreteSlab);
    }

    private void registerItems() {
        this.registerItem("item_logo", ModRegistryBase.LogoItem);
        this.registerItem("item_pile_of_bricks", ModRegistryBase.ItemPileOfBricks);
        this.registerItem("item_pallet_of_bricks", ModRegistryBase.ItemPalletOfBricks);
        this.registerItem("item_bundle_of_timber", ModRegistryBase.ItemBundleOfTimber);
        this.registerItem("item_heap_of_timber", ModRegistryBase.ItemHeapOfTimber);
        this.registerItem("item_ton_of_timber", ModRegistryBase.ItemTonOfTimber);
        this.registerItem("item_string_of_lanterns", ModRegistryBase.StringOfLanterns);
        this.registerItem("item_coil_of_lanterns", ModRegistryBase.CoilOfLanterns);
        this.registerItem("item_compressed_chest", ModRegistryBase.CompressedChest);
        this.registerItem("item_upgrade", ModRegistryBase.Upgrade);
        this.registerItem("item_swift_blade_wood", ModRegistryBase.SwiftBladeWood);
        this.registerItem("item_swift_blade_stone", ModRegistryBase.SwiftBladeStone);
        this.registerItem("item_swift_blade_iron", ModRegistryBase.SwiftBladeIron);
        this.registerItem("item_swift_blade_diamond", ModRegistryBase.SwiftBladeDiamond);
        this.registerItem("item_swift_blade_gold", ModRegistryBase.SwiftBladeGold);
        this.registerItem("item_swift_blade_copper", ModRegistryBase.SwiftBladeCopper);
        this.registerItem("item_swift_blade_osmium", ModRegistryBase.SwiftBladeOsmium);
        this.registerItem("item_swift_blade_bronze", ModRegistryBase.SwiftBladeBronze);
        this.registerItem("item_swift_blade_steel", ModRegistryBase.SwiftBladeSteel);
        this.registerItem("item_swift_blade_obsidian", ModRegistryBase.SwiftBladeObsidian);
        this.registerItem("item_swift_blade_netherite", ModRegistryBase.SwiftBladeNetherite);
        this.registerItem("item_sickle_wood", (Item)ModRegistryBase.SickleWood);
        this.registerItem("item_sickle_stone", (Item)ModRegistryBase.SickleStone);
        this.registerItem("item_sickle_gold", (Item)ModRegistryBase.SickleGold);
        this.registerItem("item_sickle_iron", (Item)ModRegistryBase.SickleIron);
        this.registerItem("item_sickle_diamond", (Item)ModRegistryBase.SickleDiamond);
        this.registerItem("item_sickle_netherite", (Item)ModRegistryBase.SickleNetherite);
        this.registerItem("item_wooden_crate", (Item)ModRegistryBase.ItemEmptyCrate);
        this.registerItem("item_clutch_of_eggs", ModRegistryBase.ClutchOfEggs);
        this.registerItem("item_carton_of_eggs", (Item)ModRegistryBase.ItemCartonOfEggs);
        this.registerItem("item_bunch_of_potatoes", ModRegistryBase.BunchOfPotatoes);
        this.registerItem("item_crate_of_potatoes", (Item)ModRegistryBase.ItemCrateOfPotatoes);
        this.registerItem("item_bunch_of_carrots", ModRegistryBase.BunchOfCarrots);
        this.registerItem("item_crate_of_carrots", (Item)ModRegistryBase.ItemCrateOfCarrots);
        this.registerItem("item_bunch_of_beets", ModRegistryBase.BunchOfBeets);
        this.registerItem("item_crate_of_beets", (Item)ModRegistryBase.ItemCrateOfBeets);
    }

    private void registerBluePrints() {
        this.registerItem("item_house", ModRegistryBase.House);
        this.registerItem("item_instant_bridge", ModRegistryBase.InstantBridge);
        this.registerItem("item_house_improved", ModRegistryBase.HouseImproved);
        this.registerItem("item_house_advanced", ModRegistryBase.HouseAdvanced);
        this.registerItem("item_bulldozer", ModRegistryBase.Bulldozer);
        this.registerItem("item_creative_bulldozer", ModRegistryBase.CreativeBulldozer);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.MachineryTower.getItemTextureLocation().getPath(), ModRegistryBase.MachineryTower);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.DefenseBunker.getItemTextureLocation().getPath(), ModRegistryBase.DefenseBunker);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance.getItemTextureLocation().getPath(), ModRegistryBase.MineshaftEntrance);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.EnderGateway.getItemTextureLocation().getPath(), ModRegistryBase.EnderGateway);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.AquaBase.getItemTextureLocation().getPath(), ModRegistryBase.AquaBase);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.GrassyPlain.getItemTextureLocation().getPath(), ModRegistryBase.GrassyPlain);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.MagicTemple.getItemTextureLocation().getPath(), ModRegistryBase.MagicTemple);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.WatchTower.getItemTextureLocation().getPath(), ModRegistryBase.WatchTower);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.WelcomeCenter.getItemTextureLocation().getPath(), ModRegistryBase.WelcomeCenter);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.Jail.getItemTextureLocation().getPath(), ModRegistryBase.Jail);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.Saloon.getItemTextureLocation().getPath(), ModRegistryBase.Saloon);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.SkiLodge.getItemTextureLocation().getPath(), ModRegistryBase.SkiLodge);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.WindMill.getItemTextureLocation().getPath(), ModRegistryBase.WindMill);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.TownHall.getItemTextureLocation().getPath(), ModRegistryBase.TownHall);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.NetherGate.getItemTextureLocation().getPath(), ModRegistryBase.NetherGate);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.AquaBaseImproved.getItemTextureLocation().getPath(), ModRegistryBase.AquaBaseImproved);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.Warehouse.getItemTextureLocation().getPath(), ModRegistryBase.Warehouse);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.WarehouseImproved.getItemTextureLocation().getPath(), ModRegistryBase.WareHouseImproved);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.VillagerHouses.getItemTextureLocation().getPath(), ModRegistryBase.VillagerHouses);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.ModernBuildings.getItemTextureLocation().getPath(), ModRegistryBase.ModernBuildings);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.ModernBuildingsImproved.getItemTextureLocation().getPath(), ModRegistryBase.ModernBuildingsImproved);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.ModernBuildingsAdvanced.getItemTextureLocation().getPath(), ModRegistryBase.ModernBuildingsAdvanced);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.Farm.getItemTextureLocation().getPath(), ModRegistryBase.Farm);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.FarmImproved.getItemTextureLocation().getPath(), ModRegistryBase.FarmImproved);
        this.registerItem(BasicStructureConfiguration.EnumBasicStructureName.FarmAdvanced.getItemTextureLocation().getPath(), ModRegistryBase.FarmAdvanced);
    }

    private void registerItemBlocks() {
        this.registerItem(BlockCompressedStone.EnumType.COMPRESSED_STONE.getUnlocalizedName(), (Item)ModRegistryBase.CompressedStoneItem);
        this.registerItem(BlockCompressedStone.EnumType.DOUBLE_COMPRESSED_STONE.getUnlocalizedName(), (Item)ModRegistryBase.DoubleCompressedStoneItem);
        this.registerItem(BlockCompressedStone.EnumType.TRIPLE_COMPRESSED_STONE.getUnlocalizedName(), (Item)ModRegistryBase.TripleCompressedStoneItem);
        this.registerItem(BlockCompressedStone.EnumType.COMPRESSED_DIRT.getUnlocalizedName(), (Item)ModRegistryBase.CompressedDirtItem);
        this.registerItem(BlockCompressedStone.EnumType.DOUBLE_COMPRESSED_DIRT.getUnlocalizedName(), (Item)ModRegistryBase.DoubleCompressedDirtItem);
        this.registerItem(BlockCompressedStone.EnumType.COMPRESSED_GLOWSTONE.getUnlocalizedName(), (Item)ModRegistryBase.CompressedGlowstoneItem);
        this.registerItem(BlockCompressedStone.EnumType.DOUBLE_COMPRESSED_GLOWSTONE.getUnlocalizedName(), (Item)ModRegistryBase.DoubleCompressedGlowstoneItem);
        this.registerItem(BlockCompressedStone.EnumType.COMPRESSED_QUARTZCRETE.getUnlocalizedName(), (Item)ModRegistryBase.CompressedQuartzCreteItem);
        this.registerItem(BlockCompressedStone.EnumType.DOUBLE_COMPRESSED_QUARTZCRETE.getUnlocalizedName(), (Item)ModRegistryBase.DoubleCompressedQuartzCreteItem);
        this.registerItem(BlockCompressedObsidian.EnumType.COMPRESSED_OBSIDIAN.toString(), (Item)ModRegistryBase.CompressedObsidianItem);
        this.registerItem(BlockCompressedObsidian.EnumType.DOUBLE_COMPRESSED_OBSIDIAN.toString(), (Item)ModRegistryBase.DoubleCompressedObsidianItem);
        this.registerItem("block_glass_slab", (Item)ModRegistryBase.GlassSlabItem);
        this.registerItem("block_glass_stairs", (Item)ModRegistryBase.GlassStairsItem);
        this.registerItem("block_paper_lantern", (Item)ModRegistryBase.PaperLanternItem);
        this.registerItem("block_phasic", (Item)ModRegistryBase.PhasicItem);
        this.registerItem("block_boundary", (Item)ModRegistryBase.BoundaryItem);
        this.registerItem("block_grass_slab", (Item)ModRegistryBase.GrassSlabItem);
        this.registerItem("block_grass_stairs", (Item)ModRegistryBase.GrassStairsItem);
        this.registerItem(BlockCustomWall.EnumType.GRASS.getUnlocalizedName(), (Item)ModRegistryBase.GrassWallItem);
        this.registerItem(BlockCustomWall.EnumType.DIRT.getUnlocalizedName(), (Item)ModRegistryBase.DirtWallItem);
        this.registerItem("block_dirt_stairs", (Item)ModRegistryBase.DirtStairsItem);
        this.registerItem("block_dirt_slab", (Item)ModRegistryBase.DirtSlabItem);
        if (PrefabBase.isDebug) {
            ModRegistryBase.StructureScannerItem = new BlockItem((Block)ModRegistryBase.StructureScanner, new Item.Properties());
            this.registerItem("block_structure_scanner", (Item)ModRegistryBase.StructureScannerItem);
        }
        this.registerItem("block_light_switch", (Item)ModRegistryBase.LightSwitchItem);
        this.registerItem("block_dark_lamp", (Item)ModRegistryBase.DarkLampItem);
        this.registerItem("block_quartz_crete", (Item)ModRegistryBase.QuartzCreteItem);
        this.registerItem("block_quartz_crete_wall", (Item)ModRegistryBase.QuartzCreteWallItem);
        this.registerItem("block_quartz_crete_bricks", (Item)ModRegistryBase.QuartzCreteBricksItem);
        this.registerItem("block_quartz_crete_chiseled", (Item)ModRegistryBase.ChiseledQuartzCreteItem);
        this.registerItem("block_quartz_crete_pillar", (Item)ModRegistryBase.QuartzCretePillarItem);
        this.registerItem("block_quartz_crete_stairs", (Item)ModRegistryBase.QuartzCreteStairsItem);
        this.registerItem("block_quartz_crete_slab", (Item)ModRegistryBase.QuartzCreteSlabItem);
        this.registerItem("block_quartz_crete_smooth", (Item)ModRegistryBase.SmoothQuartzCreteItem);
        this.registerItem("block_quartz_crete_smooth_wall", (Item)ModRegistryBase.SmoothQuartzCreteWallItem);
        this.registerItem("block_quartz_crete_smooth_stairs", (Item)ModRegistryBase.SmoothQuartzCreteStairsItem);
        this.registerItem("block_quartz_crete_smooth_slab", (Item)ModRegistryBase.SmoothQuartzCreteSlabItem);
    }

    private void RegisterRecipeSerializers() {
        Registry.register((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (ResourceLocation)Objects.requireNonNull(ResourceLocation.tryBuild((String)"prefab", (String)"condition_crafting_shaped")), ModRegistryBase.ConditionedShapedRecipeSeriaizer);
        Registry.register((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (ResourceLocation)Objects.requireNonNull(ResourceLocation.tryBuild((String)"prefab", (String)"condition_crafting_shapeless")), ModRegistryBase.ConditionedShapelessRecipeSeriaizer);
        Registry.register((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (ResourceLocation)Objects.requireNonNull(ResourceLocation.tryBuild((String)"prefab", (String)"condition_smelting")), ModRegistryBase.ConditionedSmeltingRecipeSeriaizer);
    }

    private void registerBlock(String registryName, Block block) {
        Registry.register((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)Objects.requireNonNull(ResourceLocation.tryBuild((String)"prefab", (String)registryName)), (Object)block);
    }

    private void registerItem(String registryName, Item item) {
        Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)Objects.requireNonNull(ResourceLocation.tryBuild((String)"prefab", (String)registryName)), (Object)item);
        ModItems.add(item);
    }
}

