/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.mixins;

import com.mojang.authlib.GameProfile;
import com.prefab.config.EntityPlayerConfiguration;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public class SavePlayerDataMixin {
    @Shadow
    @Final
    private GameProfile gameProfile;

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void writeCustomDataToTag(CompoundTag tag, CallbackInfo ci) {
        UUID prefabPlayerId = this.gameProfile.getId();
        EntityPlayerConfiguration prefabConfiguration = !EntityPlayerConfiguration.playerTagData.containsKey(prefabPlayerId) ? new EntityPlayerConfiguration() : EntityPlayerConfiguration.playerTagData.get(prefabPlayerId);
        CompoundTag prefabTag = prefabConfiguration.createPlayerTag();
        tag.put("PrefabTag", (Tag)prefabTag);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readCustomDataFromTag(CompoundTag tag, CallbackInfo ci) {
        UUID prefabPlayerId = this.gameProfile.getId();
        EntityPlayerConfiguration prefabConfiguration = new EntityPlayerConfiguration();
        if (tag.contains("PrefabTag")) {
            CompoundTag prefabTag = tag.getCompound("PrefabTag");
            prefabConfiguration.loadFromNBTTagCompound(prefabTag);
        }
        if (!EntityPlayerConfiguration.playerTagData.containsKey(prefabPlayerId)) {
            EntityPlayerConfiguration.playerTagData.put(prefabPlayerId, prefabConfiguration);
        } else {
            EntityPlayerConfiguration.playerTagData.replace(prefabPlayerId, prefabConfiguration);
        }
    }
}

