/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.items;

import com.prefab.ModRegistryBase;
import com.prefab.items.ItemBlockWoodenCrate;
import net.minecraft.world.item.Item;

public class ItemWoodenCrate
extends Item {
    public final CrateType crateType;

    public ItemWoodenCrate(CrateType crateType) {
        super(new Item.Properties().craftRemainder((Item)ItemWoodenCrate.getRecipeRemainderForCrateType(crateType)));
        this.crateType = crateType;
    }

    public static ItemBlockWoodenCrate getRecipeRemainderForCrateType(CrateType crateType) {
        if (crateType.isCrateOfFood) {
            return ModRegistryBase.ItemEmptyCrate;
        }
        return null;
    }

    public static enum CrateType {
        Empty(0, false),
        Clutch_Of_Eggs(1, false),
        Carton_Of_Eggs(2, true),
        Bunch_Of_Potatoes(3, false),
        Crate_Of_Potatoes(4, true),
        Bunch_Of_Carrots(5, false),
        Crate_Of_Carrots(6, true),
        Bunch_Of_Beets(7, false),
        Crate_Of_Beets(8, true);

        public final int meta;
        public final boolean isCrateOfFood;

        private CrateType(int meta, boolean isCrateOfFood) {
            this.meta = meta;
            this.isCrateOfFood = isCrateOfFood;
        }

        public static CrateType getValueFromMeta(int meta) {
            for (CrateType type : CrateType.values()) {
                if (type.meta != meta) continue;
                return type;
            }
            return Empty;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

