/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.items;

import com.prefab.Utils;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;

public class ItemSickle
extends TieredItem {
    public static HashSet<Block> effectiveBlocks = new HashSet();
    protected int breakRadius = 0;
    public Tier toolMaterial;

    public ItemSickle(Tier toolMaterial) {
        super(toolMaterial, new Item.Properties());
        this.breakRadius = 1 + (int)toolMaterial.getAttackDamageBonus();
        this.toolMaterial = toolMaterial;
    }

    public static void setEffectiveBlocks() {
        effectiveBlocks.clear();
        effectiveBlocks.addAll(Utils.getBlocksWithTagKey((TagKey<Block>)BlockTags.LEAVES));
        effectiveBlocks.addAll(Utils.getBlocksWithTagKey((TagKey<Block>)BlockTags.SMALL_FLOWERS));
        effectiveBlocks.addAll(Utils.getBlocksWithTagKey((TagKey<Block>)BlockTags.TALL_FLOWERS));
        effectiveBlocks.addAll(Utils.getBlocksWithTagKey((TagKey<Block>)BlockTags.FLOWERS));
        effectiveBlocks.add(Blocks.TALL_GRASS);
        effectiveBlocks.add(Blocks.DEAD_BUSH);
        effectiveBlocks.add(Blocks.SHORT_GRASS);
        effectiveBlocks.add(Blocks.SEAGRASS);
        effectiveBlocks.add(Blocks.TALL_SEAGRASS);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        Block block = state.getBlock();
        if (!effectiveBlocks.contains(block) && block != Blocks.COBWEB && state.getTags().noneMatch(blockTagKey -> blockTagKey.equals((Object)BlockTags.LEAVES))) {
            return super.getDestroySpeed(stack, state);
        }
        return 15.0f;
    }

    public boolean mineBlock(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.isClientSide) {
            stack.hurtAndBreak(1, entityLiving, EquipmentSlot.MAINHAND);
            if ((double)state.getDestroySpeed((BlockGetter)worldIn, pos) != 0.0 && !(state.getBlock() instanceof LeavesBlock)) {
                stack.hurtAndBreak(1, entityLiving, EquipmentSlot.MAINHAND);
            } else if ((state.getBlock() instanceof BushBlock || state.getBlock() instanceof LeavesBlock) && entityLiving instanceof Player) {
                BlockPos corner1 = pos.north(this.breakRadius).east(this.breakRadius).above(this.breakRadius);
                BlockPos corner2 = pos.south(this.breakRadius).west(this.breakRadius).below(this.breakRadius);
                for (BlockPos currentPos : BlockPos.betweenClosed((BlockPos)corner1, (BlockPos)corner2)) {
                    BlockState currentState = worldIn.getBlockState(currentPos);
                    if (currentState == null || !effectiveBlocks.contains(currentState.getBlock())) continue;
                    worldIn.destroyBlock(currentPos, true);
                }
            }
        }
        return true;
    }
}

