/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.gui.controls;

import com.mojang.blaze3d.systems.RenderSystem;
import com.prefab.Utils;
import com.prefab.gui.GuiUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class GuiCheckBox
extends AbstractButton {
    private static final ResourceLocation buttonTexture = ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/prefab_checkbox.png");
    private static final ResourceLocation buttonTexturePressed = ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/prefab_checkbox_selected.png");
    private static final ResourceLocation buttonTextureHover = ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/prefab_checkbox_hover.png");
    private static final ResourceLocation buttonTextureHoverSelected = ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/prefab_checkbox_hover_selected.png");
    protected int boxWidth = 11;
    protected int boxHeight;
    protected int stringColor;
    protected boolean withShadow;
    protected Minecraft mineCraft = Minecraft.getInstance();
    protected String displayString;
    protected IPressable handler;
    protected int labelWidth;
    protected boolean isChecked;

    public GuiCheckBox(int xPos, int yPos, String displayString, boolean isChecked, IPressable handler) {
        super(xPos, yPos, 11, 12, (Component)Utils.createTextComponent(displayString));
        this.displayString = displayString;
        this.stringColor = Color.DARK_GRAY.getRGB();
        this.handler = handler;
        this.withShadow = false;
        this.labelWidth = 98;
        this.isChecked = isChecked;
    }

    public int getStringColor() {
        return this.stringColor;
    }

    public GuiCheckBox setStringColor(int color) {
        this.stringColor = color;
        return this;
    }

    public void onPress() {
        boolean bl = this.isChecked = !this.isChecked;
        if (this.handler != null) {
            this.handler.onPress(this);
        }
    }

    public boolean getWithShadow() {
        return this.withShadow;
    }

    public GuiCheckBox setWithShadow(boolean value) {
        this.withShadow = value;
        return this;
    }

    public GuiCheckBox setLabelWidth(int value) {
        this.labelWidth = value;
        return this;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setIsChecked(boolean isChecked) {
        this.isChecked = isChecked;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        if (this.visible) {
            ResourceLocation resourceLocation = buttonTexture;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean bl = this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.boxWidth && mouseY < this.getY() + this.height;
            if (this.isChecked()) {
                resourceLocation = buttonTexturePressed;
                if (this.isHovered) {
                    resourceLocation = buttonTextureHoverSelected;
                }
            } else if (this.isHovered) {
                resourceLocation = buttonTextureHover;
            }
            GuiUtils.bindTexture(resourceLocation);
            GuiUtils.drawTexture(resourceLocation, guiGraphics, this.getX(), this.getY(), 1, 11, 11, 11, 11);
            int color = this.stringColor;
            if (this.withShadow) {
                guiGraphics.drawString(this.mineCraft.font, this.displayString, this.getX() + this.boxWidth + 2, this.getY() + 4, color);
            } else {
                guiGraphics.drawWordWrap(this.mineCraft.font, (FormattedText)Utils.createTextComponent(this.displayString), this.getX() + this.boxWidth + 2, this.getY() + 2, this.labelWidth, color);
            }
        }
    }

    public MutableComponent createNarrationMessage() {
        MutableComponent state = this.isChecked ? Component.translatable((String)"options.on") : Component.translatable((String)"options.off");
        String msg = this.displayString + ": ";
        return Component.translatable((String)"narration.checkbox", (Object[])new Object[]{Component.literal((String)msg).append((Component)state)});
    }

    public void updateWidgetNarration(NarrationElementOutput builder) {
        builder.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            if (this.isFocused()) {
                builder.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.focused"));
            } else {
                builder.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.hovered"));
            }
        }
    }

    public static interface IPressable {
        public void onPress(GuiCheckBox var1);
    }
}

