/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.gui.controls;

import com.mojang.blaze3d.vertex.PoseStack;
import com.prefab.Utils;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

public class ExtendedButton
extends Button {
    public float fontScale = 1.0f;

    public ExtendedButton(int xPos, int yPos, int width, int height, Component displayString, Button.OnPress handler, @Nullable String label) {
        super(xPos, yPos, width, height, displayString, handler, Button.DEFAULT_NARRATION);
    }

    public void renderString(GuiGraphics guiGraphics, Font font, int i) {
        Component buttonText = this.getMessage();
        int strWidth = font.width((FormattedText)buttonText);
        int ellipsisWidth = font.width("...");
        if (strWidth > this.width - 6 && strWidth > ellipsisWidth) {
            buttonText = Utils.createTextComponent(font.substrByWidth((FormattedText)buttonText, this.width - 6 - ellipsisWidth).getString() + "...");
        }
        PoseStack originalStack = new PoseStack();
        originalStack.pushPose();
        originalStack.scale(this.fontScale, this.fontScale, this.fontScale);
        int xPosition = this.getX() + this.width / 2;
        int yPosition = this.getY() + (this.height - 8) / 2;
        guiGraphics.drawCenteredString(font, buttonText, xPosition, yPosition, this.getFGColor());
        originalStack.popPose();
    }

    public int getFGColor() {
        return this.active ? 0xFFFFFF : 0xA0A0A0;
    }
}

